/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.msg;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.kube.discovery.process.MonitorProtectionPlanTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.AbstractKubeBackupModel;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubeVolumeSet;
import com.huawei.ism.drm.kube.sdk.model.MetadataPairInfo;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.HookBO;
import com.huawei.ism.drm.kube.sdk.model.bo.NamespaceBO;
import com.huawei.ism.drm.kube.sdk.model.bo.PersistentVolumeBO;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeCommonUtils;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.KubeHyperMetroProtectGroupRefreshWatcher;
import com.huawei.ism.drm.kube.service.KubeRefreshHyperMetroProtectGroupService;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.ism.drm.kube.utils.KubeResourceBuildUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.framework.service.group.context.CreateProtectGroupContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.ReplicationSpeedPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class KubeObserverImpl
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(KubeObserverImpl.class);

    public void before(MessageEvent messageEvent) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)messageEvent.getObjectList())) {
            return;
        }
        for (DRMObject drmObj : messageEvent.getObjectList()) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || !PolicyTemplateType.KUBE_BACKUP_TYPES.contains((protectGroup = (ProtectGroup)drmObj).getTemplate().getType()) && !PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType()) && !PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(protectGroup.getTemplate().getType())) continue;
            this.checkKubeObserverByMessageEvent(messageEvent, protectGroup);
        }
    }

    private void checkKubeObserverByMessageEvent(MessageEvent messageEvent, ProtectGroup protectGroup) {
        switch (messageEvent.getMessageType()) {
            case 0: {
                this.createResourceCheck(protectGroup);
                break;
            }
            case 2: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.deleteCDRResources(protectGroup);
                break;
            }
            case 1: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.refreshCDRResources(protectGroup);
                break;
            }
            case 12: 
            case 13: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.addOrUpdateSchedules(protectGroup, messageEvent);
                break;
            }
            case 3: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.addCDRResources(protectGroup);
                break;
            }
            case 4: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.removeCDRResources(protectGroup, messageEvent);
                break;
            }
            case 9: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.enableProtectGroup(protectGroup);
                break;
            }
            case 8: {
                this.checkPgStatus(protectGroup, messageEvent);
                this.disableProtectGroup(protectGroup);
                break;
            }
            default: {
                LOGGER.error((Object)"No correct message.");
            }
        }
    }

    private void checkPgStatus(ProtectGroup protectGroup, MessageEvent messageEvent) {
        String sn = protectGroup.getPoProviderSN();
        String targetSn = ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
        String protectionPlanName = protectGroup.getProperty("kube_protection_plan");
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType()) || PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(protectGroup.getTemplate().getType())) {
            Optional protectionPlanMaster = this.getKubeHandler().getProtectionPlan(sn, protectionPlanName);
            Optional protectionPlanSlave = this.getKubeHandler().getProtectionPlan(targetSn, protectionPlanName);
            switch (messageEvent.getMessageType()) {
                case 1: {
                    this.checkPlanStatusWhenMesUpdate(protectGroup, protectionPlanName, protectionPlanMaster);
                    break;
                }
                case 2: {
                    this.checkPlanStatusWhenMesDelete(protectGroup, protectionPlanName, protectionPlanMaster, protectionPlanSlave);
                    break;
                }
                default: {
                    KubeObserverImpl.checkPlanStatusWhenMesDefault(protectGroup, protectionPlanName, protectionPlanMaster, protectionPlanSlave);
                    break;
                }
            }
        } else {
            if (this.isBackupInstanceInfoExistWhenDelete(protectGroup, messageEvent, sn)) {
                return;
            }
            BackupInstanceInfo backupInstanceInfo = this.getKubeHandler().getBackupInstanceInfo(sn, protectGroup.getProperty("kube_backup_instance"));
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)backupInstanceInfo)) {
                LOGGER.error((Object)"BackupInstance %s is not exist.", new Object[]{protectGroup.getProperty("kube_backup_instance")});
                throw new LegoCheckedException(201L);
            }
            if (messageEvent.getMessageType() == 9) {
                if (KubeEnumDefine.BackupInstanceStatus.NORMAL.getValue().equals(backupInstanceInfo.getStatus()) || KubeEnumDefine.BackupInstanceStatus.DISABLE.getValue().equals(backupInstanceInfo.getStatus())) {
                    return;
                }
                throw new LegoCheckedException(1073947754L, new String[]{backupInstanceInfo.getName(), backupInstanceInfo.getStatus()});
            }
            if (!KubeEnumDefine.BackupInstanceStatus.NORMAL.getValue().equals(backupInstanceInfo.getStatus())) {
                LOGGER.error((Object)"BackupInstance %s status is %s.", new Object[]{backupInstanceInfo.getName(), backupInstanceInfo.getStatus()});
                throw new LegoCheckedException(1073947754L, new String[]{backupInstanceInfo.getName(), backupInstanceInfo.getStatus()});
            }
        }
    }

    private boolean isBackupInstanceInfoExistWhenDelete(ProtectGroup protectGroup, MessageEvent messageEvent, String sn) {
        if (messageEvent.getMessageType() == 2) {
            try {
                BackupInstanceInfo info = this.getKubeHandler().getBackupInstanceInfo(sn, protectGroup.getProperty("kube_backup_instance"));
                HashSet<String> deletedInstanceStatus = new HashSet<String>(Arrays.asList(KubeEnumDefine.CDRProtectGroupStatus.DISABLE.getValue(), KubeEnumDefine.CDRProtectGroupStatus.NORMAL.getValue(), KubeEnumDefine.CDRProtectGroupStatus.ERROR.getValue()));
                if (deletedInstanceStatus.contains(info.getStatus())) {
                    return true;
                }
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"BackupInstance not exist.");
                return true;
            }
        }
        return false;
    }

    private void checkPlanStatusWhenMesUpdate(ProtectGroup protectGroup, String protectionPlanName, Optional<KubeProtectionPlan> protectionPlanMaster) {
        if (!protectionPlanMaster.isPresent()) {
            LOGGER.error((Object)"Master protection plan %s is not exist", new Object[]{protectionPlanName});
            throw new LegoCheckedException(201L);
        }
        KubeProtectionPlan plan = protectionPlanMaster.get();
        if (!KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)plan.getStatus()) && !KubeEnumDefine.CDRProtectGroupStatus.ERROR.equals((Object)plan.getStatus())) {
            throw new LegoCheckedException(1073947751L, new String[]{protectionPlanName, String.valueOf(plan.getStatus())});
        }
    }

    private void checkPlanStatusWhenMesDelete(ProtectGroup protectGroup, String protectionPlanName, Optional<KubeProtectionPlan> protectionPlanMaster, Optional<KubeProtectionPlan> protectionPlanSlave) {
        boolean isProtectionPlanMasterStatus;
        boolean isProtectionPlanExist = this.getKubeHandler().checkProtectionPlanExist(protectGroup.getPoProviderSN(), protectionPlanName) && this.getKubeHandler().checkProtectionPlanExist(((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn(), protectionPlanName);
        boolean isProtectionPlanStatusErrorOrNormal = true;
        HashSet<KubeEnumDefine.CDRProtectGroupStatus> set = new HashSet<KubeEnumDefine.CDRProtectGroupStatus>(Arrays.asList(KubeEnumDefine.CDRProtectGroupStatus.ERROR, KubeEnumDefine.CDRProtectGroupStatus.NORMAL, KubeEnumDefine.CDRProtectGroupStatus.DISABLE));
        boolean bl = isProtectionPlanMasterStatus = protectionPlanMaster.isPresent() && set.contains(protectionPlanMaster.get().getStatus());
        if (isProtectionPlanExist) {
            boolean bl2 = isProtectionPlanStatusErrorOrNormal = isProtectionPlanMasterStatus && set.contains(protectionPlanSlave.get().getStatus());
        }
        if (!isProtectionPlanStatusErrorOrNormal) {
            if (!isProtectionPlanMasterStatus) {
                throw new LegoCheckedException(1073947751L, new String[]{protectionPlanName, protectionPlanMaster.get().getStatus().getValue()});
            }
            throw new LegoCheckedException(1073947751L, new String[]{protectionPlanName, protectionPlanSlave.get().getStatus().getValue()});
        }
    }

    private static void checkPlanStatusWhenMesDefault(ProtectGroup protectGroup, String protectionPlanName, Optional<KubeProtectionPlan> protectionPlanMaster, Optional<KubeProtectionPlan> protectionPlanSlave) {
        boolean isProtectionPlanStatusNormalOrDisabled;
        protectionPlanSlave.ifPresent(plan -> {
            if (!KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)plan.getStatus()) && !KubeEnumDefine.CDRProtectGroupStatus.DISABLE.equals((Object)plan.getStatus())) {
                throw new LegoCheckedException(1073947751L, new String[]{protectionPlanName, ((KubeProtectionPlan)protectionPlanSlave.get()).getStatus().getValue()});
            }
        });
        if (!protectionPlanSlave.isPresent()) {
            LOGGER.error((Object)"Slave protection plan %s is not exist", new Object[]{protectionPlanName});
            throw new LegoCheckedException(201L);
        }
        HashSet<KubeEnumDefine.CDRProtectGroupStatus> set = new HashSet<KubeEnumDefine.CDRProtectGroupStatus>(Arrays.asList(KubeEnumDefine.CDRProtectGroupStatus.NORMAL, KubeEnumDefine.CDRProtectGroupStatus.DISABLE));
        boolean bl = isProtectionPlanStatusNormalOrDisabled = set.contains(protectionPlanMaster.get().getStatus()) && set.contains(protectionPlanSlave.get().getStatus());
        if (!isProtectionPlanStatusNormalOrDisabled) {
            throw new LegoCheckedException(1073947751L, new String[]{protectionPlanName, protectionPlanMaster.get().getStatus().getValue()});
        }
    }

    private void checkLicenseCapacity(Set<ProtectObject> protectObjects) {
        LOGGER.debug((Object)"Start check kube licence capacity.");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(protectObjects)) {
            return;
        }
        double addCapacity = 0.0;
        for (ProtectObject po : protectObjects) {
            addCapacity += NumberUtil.convertToDouble((Object)po.getProps().getOrDefault("capacity", "0")).doubleValue();
        }
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkLicenseEnableWithCapacity("BOMBCMREPSWTB", new Double(addCapacity).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdateSchedules(ProtectGroup protectGroup, MessageEvent messageEvent) {
        String lockId = ResourceLockUtil.lockRes((String)protectGroup.getUuid(), (String)"ProtectGroup", (long)300000L);
        try {
            if (messageEvent.getMessageType() == 13) {
                this.updateCDRSchedules(protectGroup, messageEvent);
            } else {
                this.addSchedules(protectGroup, messageEvent);
            }
        }
        finally {
            ResourceLockUtil.unlockRes((String)lockId);
        }
    }

    private void disableProtectGroup(ProtectGroup protectGroup) {
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.rebuildProtectionPlanStatus(protectGroup, false);
        } else {
            this.rebuildBackupInstanceStatus(protectGroup, false);
        }
        Set schedules = protectGroup.getTemplate().getSchedules();
        List<String> enableScheduleIds = schedules.stream().filter(Schedule::isEnable).collect(Collectors.toList()).stream().map(Schedule::getScheduleId).collect(Collectors.toList());
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        String pgId = protectGroup.getUuid();
        enableScheduleIds.forEach(id -> protectGroupService.disableSchedule(pgId, id));
        ProtectGroup currentProtectGroup = protectGroupService.getProtectGroupByID(pgId);
        currentProtectGroup.setProperty("enable_schedules", (Object)JSONArray.fromObject(enableScheduleIds).toString());
        currentProtectGroup.setProperty("sourceProtectionPlanStatus", (Object)"Disabled");
        currentProtectGroup.setProperty("targetProtectionPlanStatus", (Object)"Disabled");
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)currentProtectGroup);
    }

    private void enableProtectGroup(ProtectGroup protectGroup) {
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.rebuildProtectionPlanStatus(protectGroup, true);
        } else {
            this.rebuildBackupInstanceStatus(protectGroup, true);
        }
        HashSet<String> enableScheduleIds = new HashSet<String>(this.getListFromProps(protectGroup.getProps(), "enable_schedules"));
        Set schedules = protectGroup.getTemplate().getSchedules();
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        String pgId = protectGroup.getUuid();
        schedules.stream().filter(schedule -> enableScheduleIds.contains(schedule.getScheduleId())).collect(Collectors.toList()).forEach(schedule -> protectGroupService.enableSchedule(pgId, schedule.getScheduleId()));
        ProtectGroup currentProtectGroup = protectGroupService.getProtectGroupByID(pgId);
        currentProtectGroup.setProperty("enable_schedules", (Object)Collections.emptyList().toString());
        currentProtectGroup.setProperty("sourceProtectionPlanStatus", (Object)"Normal");
        currentProtectGroup.setProperty("targetProtectionPlanStatus", (Object)"Normal");
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)currentProtectGroup);
    }

    private void rebuildProtectionPlanStatus(ProtectGroup protectGroup, boolean isEnable) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        String srcSn = protectGroup.getPoProviderSN();
        String trgSn = ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
        String protectionPlanName = protectGroup.getProperty("kube_protection_plan");
        kubeHandler.editProtectionPlanWithEnable(srcSn, protectionPlanName, isEnable);
        kubeHandler.editProtectionPlanWithEnable(trgSn, protectionPlanName, isEnable);
    }

    private void rebuildBackupInstanceStatus(ProtectGroup protectGroup, boolean isEnable) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        String srcSn = protectGroup.getPoProviderSN();
        LOGGER.debug((Object)"Begin get backupInstance.");
        String instanceName = protectGroup.getProperty("kube_backup_instance");
        BackupInstanceInfo info = kubeHandler.getBackupInstanceInfo(srcSn, instanceName);
        LOGGER.debug((Object)"Already get backupInstance.");
        LOGGER.debug((Object)"Begin rebuild backupInstance.");
        info.setEnable(isEnable);
        kubeHandler.rebuildBackupInstance(srcSn, info);
    }

    private void addCDRResources(ProtectGroup protectGroup) {
        if (protectGroup.getTemplate().getType() != 55) {
            return;
        }
        protectGroup.setProperty("isBuildIngPo", (Object)"1");
        String storageName = ((ProtectObject)protectGroup.getPolist().iterator().next()).getProperty("storageName");
        List<ProtectObject> newPos = protectGroup.getPolist().stream().filter(po -> !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)((String)po.getProps().get("isNewPo")))).collect(Collectors.toList());
        if (protectGroup.getTemplate().getType() == 55) {
            this.checkPvcSize(newPos);
        }
        for (ProtectObject po2 : newPos) {
            if (storageName.equals(po2.getProps().get("storageName"))) continue;
            LOGGER.error((Object)"Po:%s is not in storageClass: %s", new Object[]{po2.getName(), storageName});
            throw new LegoCheckedException(-1L);
        }
        this.checkLicenseCapacity(new HashSet<ProtectObject>(newPos));
        String trgSn = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray();
        IKubeHandler kubeHandler = this.getKubeHandler();
        List nameSpaces = kubeHandler.getNamespaces(trgSn);
        ArrayList persistentVolumeBOS = new ArrayList();
        nameSpaces.forEach(nameSpace -> persistentVolumeBOS.addAll(kubeHandler.getKubePersistentVolumeClaims(trgSn, nameSpace.getName())));
        HashSet<String> scNames = new HashSet<String>();
        persistentVolumeBOS.forEach(bo -> scNames.add(bo.getStorageClassName()));
        ArrayList<MetadataPairInfo> newInfos = new ArrayList<MetadataPairInfo>(newPos.size());
        this.dealWithNewPos(protectGroup, newPos, kubeHandler, scNames, newInfos);
        KubeVolumeSet srcVolumeSet = kubeHandler.getVolumeSet(protectGroup.getPoProviderSN(), protectGroup.getProperty("kube_volume_set_name"));
        KubeVolumeSet trgVolumeSet = kubeHandler.getVolumeSet(trgSn, protectGroup.getProperty("kube_volume_set_name"));
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)trgVolumeSet) && !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)srcVolumeSet)) {
            srcVolumeSet.getVolumePairs().addAll(newInfos);
            kubeHandler.rebuildVolumeSet(protectGroup.getPoProviderSN(), srcVolumeSet);
            trgVolumeSet.getVolumePairs().addAll(newInfos);
            kubeHandler.rebuildVolumeSet(trgSn, trgVolumeSet);
        }
        kubeHandler.rebuildProtectionPlan(protectGroup.getPoProviderSN(), (String)protectGroup.getProps().get("kube_protection_plan"));
        kubeHandler.rebuildProtectionPlan(trgSn, (String)protectGroup.getProps().get("kube_protection_plan"));
        ExecutionService.submit((Runnable)new MonitorProtectionPlanTask(protectGroup, (KubeProtectionPlan)kubeHandler.getProtectionPlan(trgSn, protectGroup.getProperty("kube_protection_plan")).orElseThrow(() -> new LegoCheckedException(2117645L, "ProtectPlan not exist."))));
    }

    private void dealWithNewPos(ProtectGroup protectGroup, List<ProtectObject> newPos, IKubeHandler kubeHandler, Set<String> scNames, List<MetadataPairInfo> newInfos) {
        String kubeTargetStorage = null;
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)((String)schedule.getExtParameters().get("kubeTargetStorage")))) continue;
            kubeTargetStorage = (String)schedule.getExtParameters().get("kubeTargetStorage");
            break;
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(kubeTargetStorage)) {
            LOGGER.error((Object)"Target storage name not in schedule params.");
            throw new LegoCheckedException(1073947394L);
        }
        String trgSn = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray();
        for (ProtectObject po : newPos) {
            String nameSpace = (String)po.getProps().get("namespace");
            if (!kubeHandler.getNamespace(trgSn, nameSpace).isPresent()) {
                NamespaceBO namespaceBO = new NamespaceBO();
                namespaceBO.setName(nameSpace);
                kubeHandler.createNamespace(trgSn, namespaceBO);
            }
            if (!scNames.contains(po.getProps().get("storage_class"))) {
                KubeObserverImpl.checkAndCreateTargetSC(protectGroup, kubeHandler, kubeTargetStorage, trgSn, po);
            }
            PersistentVolumeClaimInfo srcInfo = (PersistentVolumeClaimInfo)kubeHandler.getPersistentVolumeClaimInfo(protectGroup.getPoProviderSN(), po.getName(), nameSpace).orElseThrow(() -> new LegoCheckedException(1073947394L, "Pvc not exist in source device."));
            kubeHandler.createPersistentVolumeClaim(trgSn, srcInfo);
        }
        this.buildInfosByPVC(protectGroup, newPos, kubeHandler, newInfos, trgSn);
    }

    private void buildInfosByPVC(ProtectGroup protectGroup, List<ProtectObject> newPos, IKubeHandler kubeHandler, List<MetadataPairInfo> newInfos, String trgSn) {
        int curIndex = 0;
        int curTime = 0;
        while (curIndex < newPos.size() && curTime <= newPos.size() + 5) {
            ProtectObject po = newPos.get(curIndex);
            String nameSpace = (String)po.getProps().get("namespace");
            PersistentVolumeClaimInfo trgInfo = (PersistentVolumeClaimInfo)kubeHandler.getPersistentVolumeClaimInfo(trgSn, po.getName(), nameSpace).get();
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)trgInfo.getVolumeName())) {
                ++curTime;
                CommUtil.pauseThread((long)5000L);
                continue;
            }
            MetadataPairInfo pairInfo = new MetadataPairInfo();
            PersistentVolumeClaimInfo srcInfo = (PersistentVolumeClaimInfo)kubeHandler.getPersistentVolumeClaimInfo(protectGroup.getPoProviderSN(), po.getName(), nameSpace).get();
            pairInfo.setPvcMeta(srcInfo.getNameSpace() + File.separator + srcInfo.getName());
            pairInfo.setPrimaryPVName(srcInfo.getVolumeName());
            pairInfo.setSecondaryPVName(trgInfo.getVolumeName());
            po.setProperty("kube_remote_persistent_volume", (Object)trgInfo.getVolumeName());
            newInfos.add(pairInfo);
            ++curIndex;
        }
    }

    private static void checkAndCreateTargetSC(ProtectGroup protectGroup, IKubeHandler kubeHandler, String kubeTargetStorage, String trgSn, ProtectObject po) {
        StorageClassInfo srcSC = (StorageClassInfo)kubeHandler.getStorageClassByName(protectGroup.getPoProviderSN(), (String)po.getProps().get("storage_class")).orElseThrow(() -> new LegoCheckedException(1073947394L, "StorageClass:%s not in sourceDevice"));
        Optional targetSC = kubeHandler.getStorageClassByName(trgSn, srcSC.getName());
        if (targetSC.isPresent()) {
            Map targetSCParameters = ((StorageClassInfo)targetSC.get()).getParameters();
            String realBackend = (String)targetSCParameters.get("backend");
            if (kubeTargetStorage.equals(realBackend)) {
                return;
            }
            LOGGER.error((Object)"The backend: %s does not match the protect group target backend: %s.", new Object[]{realBackend, kubeTargetStorage});
            throw new LegoCheckedException(1073947758L, new String[]{kubeTargetStorage, realBackend});
        }
        Map map = srcSC.getParameters();
        map.put("backend", kubeTargetStorage);
        kubeHandler.createStorageClass(trgSn, srcSC);
    }

    private void removeCDRResources(ProtectGroup protectGroup, MessageEvent messageEvent) {
        boolean isSCDelete;
        if (protectGroup.getTemplate().getType() != 55) {
            return;
        }
        protectGroup.setProperty("isBuildIngPo", (Object)"1");
        String trgSn = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray();
        Set resultItemSet = null;
        if (messageEvent.getMessageMap().get("TASK_RESULT_ITEM_LIST_KEY") != null && messageEvent.getMessageMap().get("TASK_RESULT_ITEM_LIST_KEY") instanceof Set) {
            resultItemSet = (Set)messageEvent.getMessageMap().get("TASK_RESULT_ITEM_LIST_KEY");
        }
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject(resultItemSet);
        IKubeHandler kubeHandler = this.getKubeHandler();
        ArrayList<String> names = new ArrayList<String>(resultItemSet.size());
        ArrayList<PersistentVolumeClaimInfo> infos = new ArrayList<PersistentVolumeClaimInfo>();
        for (TaskResultItem item : resultItemSet) {
            ProtectObject po = ProtectObjectAppUtil.getProtectObjectByPoUUID((String)item.getResId());
            names.add((String)po.getProps().get("namespace") + "/" + po.getName());
            kubeHandler.getPersistentVolumeClaimInfo(trgSn, po.getName(), (String)po.getProps().get("namespace")).ifPresent(infos::add);
        }
        kubeHandler.deletePersistentVolumeClaim(trgSn, KubeResourceBuildUtil.buildPVCs(names, trgSn));
        this.rebuildVolumeSets(protectGroup, kubeHandler, trgSn, names);
        kubeHandler.rebuildProtectionPlan(protectGroup.getPoProviderSN(), (String)protectGroup.getProps().get("kube_protection_plan"));
        kubeHandler.rebuildProtectionPlan(trgSn, (String)protectGroup.getProps().get("kube_protection_plan"));
        List<String> scNames = this.buildScNames(kubeHandler, trgSn, infos);
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(scNames) && !(isSCDelete = kubeHandler.deleteStorageClass(trgSn, KubeResourceBuildUtil.buildSCs(scNames)))) {
            LOGGER.error((Object)"Delete CDR Resource failed. isSCDelete:%s.", new Object[]{isSCDelete});
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            throw new LegoCheckedException(-1L);
        }
        ExecutionService.submit((Runnable)new MonitorProtectionPlanTask(protectGroup, (KubeProtectionPlan)kubeHandler.getProtectionPlan(trgSn, protectGroup.getProperty("kube_protection_plan")).orElseThrow(() -> new LegoCheckedException(2117645L, "ProtectPlan not exist."))));
    }

    private List<String> buildScNames(IKubeHandler kubeHandler, String trgSn, List<PersistentVolumeClaimInfo> infos) {
        List nameSpaces = kubeHandler.getNamespaces(trgSn);
        ArrayList persistentVolumeBOS = new ArrayList();
        nameSpaces.forEach(nameSpace -> persistentVolumeBOS.addAll(kubeHandler.getKubePersistentVolumeClaims(trgSn, nameSpace.getName())));
        ArrayList<String> scNames = new ArrayList<String>(infos.size());
        HashSet oldScNames = new HashSet();
        persistentVolumeBOS.forEach(info -> oldScNames.add(info.getStorageClassName()));
        for (PersistentVolumeClaimInfo info2 : infos) {
            String scName = info2.getStorageClassName();
            if (oldScNames.contains(scName)) {
                LOGGER.warn((Object)"Sc:%s is used.", new Object[]{scName});
                continue;
            }
            scNames.add(info2.getStorageClassName());
        }
        return scNames;
    }

    private void rebuildVolumeSets(ProtectGroup protectGroup, IKubeHandler kubeHandler, String trgSn, List<String> names) {
        KubeVolumeSet srcVolumeSet = kubeHandler.getVolumeSet(protectGroup.getPoProviderSN(), protectGroup.getProperty("kube_volume_set_name"));
        KubeVolumeSet trgVolumeSet = kubeHandler.getVolumeSet(trgSn, protectGroup.getProperty("kube_volume_set_name"));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)srcVolumeSet) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)trgVolumeSet)) {
            return;
        }
        List srcVolumePairs = srcVolumeSet.getVolumePairs();
        srcVolumePairs.removeIf(pair -> names.contains(pair.getPvcMeta()));
        List trgVolumePairs = trgVolumeSet.getVolumePairs();
        trgVolumePairs.removeIf(pair -> names.contains(pair.getPvcMeta()));
        kubeHandler.rebuildVolumeSet(protectGroup.getPoProviderSN(), srcVolumeSet);
        kubeHandler.rebuildVolumeSet(trgSn, trgVolumeSet);
    }

    private void addSchedules(ProtectGroup protectGroup, MessageEvent messageEvent) {
        PolicyTemplate template = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid()).getTemplate();
        Schedule schedule = null;
        if (messageEvent.getMessageMap().get("Schedule") instanceof Schedule) {
            schedule = (Schedule)messageEvent.getMessageMap().get("Schedule");
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(schedule)) {
            template.addSchedule(schedule);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)template);
        }
        ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
        this.updateCDRSchedules(curProtectGroup, messageEvent);
    }

    private void updateCDRSchedules(ProtectGroup protectGroup, MessageEvent messageEvent) {
        Schedule schedule = null;
        if (messageEvent.getMessageMap().get("Schedule") instanceof Schedule) {
            schedule = (Schedule)messageEvent.getMessageMap().get("Schedule");
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(schedule)) {
            LOGGER.error((Object)"Schedule is null.");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.updateReplicationSchedules(curProtectGroup, messageEvent, schedule);
        } else if (PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.modifyProtectionPlanSpeed(schedule, protectGroup);
        } else {
            this.updateBackupSchedules(curProtectGroup, messageEvent, schedule);
        }
        PolicyTemplate template = curProtectGroup.getTemplate();
        schedule.setEnable(Boolean.valueOf(true));
        schedule.setPolicyTemplate(template);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)schedule);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
        protectGroup.setProps(curProtectGroup.getProps());
    }

    private void modifyProtectionPlanSpeed(Schedule schedule, ProtectGroup protectGroup) {
        List list = (List)JSONObject.toBean((String)schedule.getReplicationSpeedPolicyData(), List.class);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(((Map)list.get(0)).get("syncRateLevel"))) {
            LOGGER.error((Object)"Data error, Could not find volume speed from schedule of protect group ( %s )", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        KubeEnumDefine.VolumeSpeed newSpeed = KubeEnumDefine.VolumeSpeed.getVolumeSpeed((int)Integer.parseInt(String.valueOf(((Map)list.get(0)).get("syncRateLevel"))));
        this.getKubeHandler().modifyVolumeSpeed(schedule.getSourceSn(), protectGroup.getProperty("kube_protection_plan"), newSpeed.getValue());
        this.getKubeHandler().modifyVolumeSpeed(schedule.getTargetSn(), protectGroup.getProperty("kube_protection_plan"), newSpeed.getValue());
    }

    private void updateBackupSchedules(ProtectGroup protectGroup, MessageEvent messageEvent, Schedule schedule) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        if (schedule.getScheduleMode() == 1) {
            this.checkHookExist(protectGroup, protectGroup.getPoProviderSN());
            BackupInstanceInfo backupInstanceInfo = this.buildBackupInstance(protectGroup, schedule, kubeHandler);
            kubeHandler.rebuildBackupInstance(protectGroup.getPoProviderSN(), backupInstanceInfo);
            return;
        }
        String devSn = protectGroup.getPoProviderSN();
        List<String> kubeScheduleNames = this.getListFromProps(protectGroup.getProps(), "kube_policy");
        HashSet<KubeSchedulePolicy> policies = new HashSet<KubeSchedulePolicy>();
        for (String name : kubeScheduleNames) {
            Optional kubeSchedulePolicy = kubeHandler.getKubeSchedulePolicy(devSn, name);
            kubeSchedulePolicy.ifPresent(policies::add);
        }
        HashMap<Integer, KubeSchedulePolicy> policyTypeMap = new HashMap<Integer, KubeSchedulePolicy>();
        this.buildPolicyTypeMap(policies, policyTypeMap);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)schedule)) {
            LOGGER.error((Object)"Schedule is empty.");
            return;
        }
        this.rebuildPolicyTypeMapBySchedules(schedule, policyTypeMap);
        kubeHandler.rebuildSchedule(devSn, Arrays.asList((KubeSchedulePolicy)policyTypeMap.get(schedule.getPeriodType())));
        HashSet<String> kubeScheduleNamesSet = new HashSet<String>(kubeScheduleNames);
        String kubeScheduleName = ((KubeSchedulePolicy)policyTypeMap.get(schedule.getPeriodType())).getName();
        if (!kubeScheduleNamesSet.contains(kubeScheduleName)) {
            kubeScheduleNames.add(((KubeSchedulePolicy)policyTypeMap.get(schedule.getPeriodType())).getName());
            protectGroup.getProps().put("kube_policy", JSONArray.fromObject(kubeScheduleNames).toString());
        }
        ArrayList<KubeSchedulePolicy> kubeSchedulePolicies = new ArrayList<KubeSchedulePolicy>(policyTypeMap.values());
        this.checkHookExist(protectGroup, protectGroup.getPoProviderSN());
        this.rebuildInstance(protectGroup, kubeSchedulePolicies, (String)protectGroup.getProps().get("kube_backup_instance"), schedule);
    }

    private BackupInstanceInfo buildBackupInstance(ProtectGroup protectGroup, Schedule schedule, IKubeHandler kubeHandler) {
        BackupInstanceInfo backupInstanceInfo = kubeHandler.getBackupInstanceInfo(protectGroup.getPoProviderSN(), protectGroup.getProperty("kube_backup_instance"));
        backupInstanceInfo.setBackupSpeed(((ReplicationSpeedPolicy)schedule.getReplicationSpeedPolicies().iterator().next()).getSyncRateLevel());
        backupInstanceInfo.setBackupPolicyNames(Collections.emptyList());
        if (schedule.getExtParameters().containsKey("preHook")) {
            backupInstanceInfo.setPreHookName((String)schedule.getExtParameters().get("preHook"));
        }
        if (schedule.getExtParameters().containsKey("postHook")) {
            backupInstanceInfo.setPostHookName((String)schedule.getExtParameters().get("postHook"));
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)schedule.isAppConsistent())) {
            backupInstanceInfo.setEnableConsistentSnapshot(schedule.isAppConsistent().booleanValue());
        }
        return backupInstanceInfo;
    }

    private String getStorageBackendName(String kubeSn, ProtectObject protectObject) {
        String resourceDetailName = (String)protectObject.getProps().get("resourceDetailName");
        List pvcList = this.getKubeHandler().getResourceSetPVCs(kubeSn, resourceDetailName);
        for (KubeResourceSetPVC pvc : pvcList) {
            KubePersistentVolume pv = pvc.getKubePV();
            if (!"csi.huawei.com".equals(pv.getDriver())) continue;
            return "huawei-csi" + File.separator + pv.getBackend();
        }
        return "";
    }

    private BackupLocationInfo rebuildBackupLocation(ProtectGroup protectGroup, String backend, String kubeLocationName) {
        BackupLocationInfo backupLocationInfo = new BackupLocationInfo();
        backupLocationInfo.setName(kubeLocationName);
        backupLocationInfo.setBackupType(KubeEnumDefine.BackupType.LOCAL);
        backupLocationInfo.setSourceBackendName(backend);
        backupLocationInfo.setBackupBackendName(backend);
        backupLocationInfo.setRestoreBackendName(backend);
        this.getKubeHandler().rebuildBackupLocation(protectGroup.getPoProviderSN(), backupLocationInfo);
        return backupLocationInfo;
    }

    private void rebuildInstance(ProtectGroup protectGroup, List<KubeSchedulePolicy> policies, String backupInstanceName, Schedule schedule) {
        BackupInstanceInfo backupInstance = new BackupInstanceInfo();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)schedule.getReplicationSpeedPolicies())) {
            backupInstance.setBackupSpeed(((ReplicationSpeedPolicy)schedule.getReplicationSpeedPolicies().iterator().next()).getSyncRateLevel());
        }
        backupInstance.setName(backupInstanceName);
        backupInstance.setBackupPolicyNames(policies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toList()));
        backupInstance.setMetadataBackupLocation("metadata-backup-location");
        backupInstance.setVolumeBackupLocation(protectGroup.getProperty("kube_backup_location"));
        backupInstance.setResourceSetName(((ProtectObject)protectGroup.getPolist().iterator().next()).getName());
        if (schedule.getExtParameters().containsKey("preHook")) {
            backupInstance.setPreHookName((String)schedule.getExtParameters().get("preHook"));
        }
        if (schedule.getExtParameters().containsKey("postHook")) {
            backupInstance.setPostHookName((String)schedule.getExtParameters().get("postHook"));
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)schedule.isAppConsistent())) {
            backupInstance.setEnableConsistentSnapshot(schedule.isAppConsistent().booleanValue());
        }
        this.getKubeHandler().rebuildBackupInstance(protectGroup.getPoProviderSN(), backupInstance);
    }

    private void updateReplicationSchedules(ProtectGroup protectGroup, MessageEvent messageEvent, Schedule schedule) {
        String kubeScheduleName;
        HashSet<String> kubeScheduleNamesSet;
        IKubeHandler kubeHandler = this.getKubeHandler();
        if (schedule.getScheduleMode() == 1) {
            this.rebuildProtectionPlanWithSchedule(schedule, protectGroup, kubeHandler);
            return;
        }
        String devSn = protectGroup.getPoProviderSN();
        List<String> kubeScheduleNames = this.getListFromProps(protectGroup.getProps(), "kube_policy");
        HashSet<KubeSchedulePolicy> policies = new HashSet<KubeSchedulePolicy>();
        for (String name : kubeScheduleNames) {
            Optional kubeSchedulePolicy = kubeHandler.getKubeSchedulePolicy(devSn, name);
            kubeSchedulePolicy.ifPresent(policies::add);
        }
        HashMap<Integer, KubeSchedulePolicy> policyTypeMap = new HashMap<Integer, KubeSchedulePolicy>();
        this.buildPolicyTypeMap(policies, policyTypeMap);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)schedule)) {
            LOGGER.error((Object)"Schedule is empty.");
            return;
        }
        this.rebuildPolicyTypeMapBySchedules(schedule, policyTypeMap);
        kubeHandler.rebuildSchedule(devSn, Collections.singletonList(policyTypeMap.get(schedule.getPeriodType())));
        kubeHandler.rebuildSchedule(((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray(), Collections.singletonList(policyTypeMap.get(schedule.getPeriodType())));
        this.checkHookExist(protectGroup, protectGroup.getPoProviderSN());
        this.checkHookExist(protectGroup, ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray());
        if (messageEvent.getMessageType() == 12 && !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)schedule)) {
            protectGroup.getTemplate().getSchedules().add(schedule);
        }
        if (!(kubeScheduleNamesSet = new HashSet<String>(kubeScheduleNames)).contains(kubeScheduleName = ((KubeSchedulePolicy)policyTypeMap.get(schedule.getPeriodType())).getName())) {
            kubeScheduleNames.add(((KubeSchedulePolicy)policyTypeMap.get(schedule.getPeriodType())).getName());
            protectGroup.getProps().put("kube_policy", JSONArray.fromObject(kubeScheduleNames).toString());
        }
        this.rebuildProtectionPlanWithSchedule(schedule, protectGroup, kubeHandler);
    }

    private void rebuildProtectionPlanWithSchedule(Schedule schedule, ProtectGroup protectGroup, IKubeHandler kubeHandler) {
        Map props = protectGroup.getProps();
        String srcSN = schedule.getSourceSn();
        String trgSN = schedule.getTargetSn();
        String planName = protectGroup.getProperty("kube_protection_plan");
        KubeProtectionPlan srcPlan = (KubeProtectionPlan)kubeHandler.getProtectionPlan(srcSN, planName).orElseThrow(() -> new LegoCheckedException(2117645L));
        KubeResourceBuildUtil.buildPlanWithSchedule(schedule, srcPlan);
        KubeProtectionPlan trgPlan = (KubeProtectionPlan)kubeHandler.getProtectionPlan(trgSN, planName).orElseThrow(() -> new LegoCheckedException(2117645L));
        KubeResourceBuildUtil.buildPlanWithSchedule(schedule, trgPlan);
        if (props.containsKey("kube_policy")) {
            srcPlan.setProtectionPolicies(this.getListFromProps(props, "kube_policy"));
            trgPlan.setProtectionPolicies(this.getListFromProps(props, "kube_policy"));
        }
        kubeHandler.rebuildProtectionPlan(srcSN, srcPlan);
        kubeHandler.rebuildProtectionPlan(trgSN, trgPlan);
    }

    private KubeProtectionPlan rbuildTrgProtectionPlan(ProtectGroup protectGroup, Schedule schedule, KubeProtectionPlan protectionPlan) {
        Optional<KubeStorage> targetOpt = KubeResourceBuildUtil.getTargetKubeStorage(schedule);
        if (!targetOpt.isPresent()) {
            LOGGER.error((Object)"Not find target kube storage.");
            throw new LegoCheckedException(2117645L);
        }
        KubeStorage storage = null;
        storage = protectGroup.getTemplate().getType() == 55 ? KubeResourceBuildUtil.getPVCSBC((ProtectObject)protectGroup.getPolist().iterator().next()) : KubeResourceBuildUtil.getSBC((ProtectObject)protectGroup.getPolist().iterator().next());
        KubeStorage targetStorage = targetOpt.get();
        protectionPlan.setRoleType(KubeEnumDefine.RoleType.RECOVERY);
        protectionPlan.setLocalSBCName(targetStorage.getNamespace() + "/" + targetStorage.getName());
        protectionPlan.setLocalSBCSn(targetStorage.getDeviceSn());
        protectionPlan.setRemoteSBCName(storage.getNamespace() + "/" + storage.getName());
        protectionPlan.setRemoteSBCSn(storage.getDeviceSn());
        return protectionPlan;
    }

    private void rebuildPolicyTypeMapBySchedules(Schedule schedule, Map<Integer, KubeSchedulePolicy> policyTypeMap) {
        int periodType = schedule.getPeriodType();
        KubeSchedulePolicy policy = policyTypeMap.getOrDefault(periodType, new KubeSchedulePolicy());
        policyTypeMap.put(periodType, policy);
        policy.setName(com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)policy.getName()) ? KubeResourceNameGenerator.generate() : policy.getName());
        switch (periodType) {
            case 4: {
                KubeObserverImpl.buildMonthPolicy(schedule, policy);
                break;
            }
            case 3: {
                KubeObserverImpl.buildWeeklyPolicy(schedule, policy);
                break;
            }
            case 2: {
                KubeObserverImpl.buildDailyPolicy(schedule, policy);
                break;
            }
            case 1: {
                KubeObserverImpl.buildHourPolicy(schedule, policy);
                break;
            }
            case 5: {
                KubeObserverImpl.buildTimeWaitPolicy(schedule, policy);
                break;
            }
            default: {
                LOGGER.error((Object)"Not support type:%s", new Object[]{String.valueOf(periodType)});
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private void buildPolicyTypeMap(Set<KubeSchedulePolicy> policies, Map<Integer, KubeSchedulePolicy> policyTypeMap) {
        block6: for (KubeSchedulePolicy kubeSchedulePolicy : policies) {
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)kubeSchedulePolicy.getPolicyType()) && !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)kubeSchedulePolicy.getTimeWait())) {
                policyTypeMap.put(5, kubeSchedulePolicy);
                continue;
            }
            switch (kubeSchedulePolicy.getPolicyType()) {
                case HOURS: {
                    policyTypeMap.put(1, kubeSchedulePolicy);
                    continue block6;
                }
                case DAILY: {
                    policyTypeMap.put(2, kubeSchedulePolicy);
                    continue block6;
                }
                case WEEKLY: {
                    policyTypeMap.put(3, kubeSchedulePolicy);
                    continue block6;
                }
                case MONTHLY: {
                    policyTypeMap.put(4, kubeSchedulePolicy);
                    continue block6;
                }
            }
            LOGGER.error((Object)"Not support type:%s", new Object[]{kubeSchedulePolicy.getPolicyType().getValue()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void createResourceCheck(ProtectGroup protectGroup) {
        this.checkHookExist(protectGroup, protectGroup.getPoProviderSN());
        this.checkCreateNeedResource(protectGroup);
        this.checkLicenseCapacity(protectGroup.getPolist());
        if (protectGroup.getTemplate().getType() == 55) {
            this.checkPvcSize(new ArrayList<ProtectObject>(protectGroup.getPolist()));
        }
        CreateProtectGroupContext.updateProgress((int)10);
    }

    private void checkPvcSize(List<ProtectObject> pos) {
        if (pos.size() > 128) {
            LOGGER.error((Object)"Persistent Volume is over limit.");
            throw new LegoCheckedException(1073947764L);
        }
    }

    private void checkCreateNeedResource(ProtectGroup protectGroup) {
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
            this.checkReplicationCreateResource(protectGroup, iKubeHandler);
        }
        String domainType = protectGroup.getProperty("domainType");
        if (KubeEnumDefine.DomainType.AA_TYPE.getValue().equals(domainType)) {
            this.checkHyperMetroCreateResource(protectGroup);
        }
    }

    private void checkHyperMetroCreateResource(ProtectGroup protectGroup) {
        KubeStorage systemVStoreBackend = KubeCommonUtils.getHyperMetroSystemVStoreBackend((ProtectGroup)protectGroup);
        KubeStorage pvcBackend = KubeCommonUtils.getHyperMetroPvcBackend((ProtectGroup)protectGroup);
        if (!StringUtils.equals((CharSequence)systemVStoreBackend.getDeviceSn(), (CharSequence)pvcBackend.getDeviceSn())) {
            LOGGER.error((Object)"The system vStore backend( %s ) and the backend for provisioning the PV( %s ) do not belong to the same storage.", new Object[]{systemVStoreBackend, pvcBackend});
            throw new LegoCheckedException(1073947770L, new String[]{systemVStoreBackend.getName(), pvcBackend.getName()});
        }
    }

    private void checkReplicationCreateResource(ProtectGroup protectGroup, IKubeHandler iKubeHandler) {
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        String targetSn = schedule.getTargetSn();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)targetSn)) {
            LOGGER.error((Object)"The targetSn is null, error.", new Object[]{schedule.getName()});
            throw new LegoCheckedException(2117645L);
        }
        this.checkTargetResourceSet(protectGroup, iKubeHandler, targetSn);
        String targetStorageName = this.getTargetBackendName(schedule);
        this.checkTargetStorageBackend(iKubeHandler, protectGroup.getPoProviderSN(), targetSn, targetStorageName);
    }

    private String getTargetBackendName(Schedule schedule) {
        Map extParameters = schedule.getExtParameters();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)extParameters) || !extParameters.containsKey("kubeTargetStorage")) {
            LOGGER.error((Object)"Not find kubeTargetStorage info by schedule: %s.", new Object[]{schedule.getName()});
            throw new LegoCheckedException(2117645L);
        }
        return (String)extParameters.get("kubeTargetStorage");
    }

    private void checkTargetStorageBackend(IKubeHandler iKubeHandler, String providerSn, String targetSn, String targetStorageName) {
        List providerStorages = iKubeHandler.getStorageBackendClaims(providerSn);
        Optional<String> optTargetSn = iKubeHandler.getStorageBackendClaims(targetSn).stream().filter(item -> "huawei-csi".equals(item.getNamespace())).filter(item -> Objects.equals(item.getName(), targetStorageName)).map(KubeStorage::getDeviceSn).findFirst();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)providerStorages) || !optTargetSn.isPresent()) {
            LOGGER.error((Object)"Not find needed for sn resource.");
            throw new LegoCheckedException(2117645L);
        }
        Optional<String> opt = providerStorages.stream().filter(kubeStorage -> !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)kubeStorage.getRemoteDeviceSNs())).map(KubeStorage::getRemoteDeviceSNs).flatMap(Collection::stream).filter(Objects::nonNull).filter(item -> item.equals(optTargetSn.get())).findAny();
        if (!opt.isPresent()) {
            LOGGER.error((Object)"The remote SNs is not in target kube, localSN: %s.", new Object[]{SecurityUtil.desensitizeId((String)providerSn)});
            throw new LegoCheckedException(1073947748L);
        }
    }

    private void checkTargetResourceSet(ProtectGroup protectGroup, IKubeHandler iKubeHandler, String targetSn) {
        if (protectGroup.getTemplate().getType() != 54) {
            return;
        }
        List targetResourceSets = iKubeHandler.getResourceSetInfos(targetSn).stream().map(ResourceSetInfo::getName).filter(Objects::nonNull).collect(Collectors.toList());
        Optional<String> nameOpt = protectGroup.getPolist().stream().map(ProtectObject::getName).filter(Objects::nonNull).filter(targetResourceSets::contains).findAny();
        if (nameOpt.isPresent()) {
            LOGGER.error((Object)"The recovery kube already has the resourceSet: %s", new Object[]{nameOpt.get()});
            throw new LegoCheckedException(1073947742L);
        }
    }

    private void checkHookExist(ProtectGroup protectGroup, String devSn) {
        ArrayList checkHookList = Lists.newArrayList();
        Set schedules = protectGroup.getTemplate().getSchedules();
        for (Schedule schedule : schedules) {
            String postHook;
            String preHook;
            Map extParam = schedule.getExtParameters();
            if (extParam.containsKey("preHook") && !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)(preHook = (String)extParam.get("preHook")))) {
                checkHookList.add(preHook);
            }
            if (!extParam.containsKey("postHook") || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)(postHook = (String)extParam.get("postHook")))) continue;
            checkHookList.add(postHook);
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)checkHookList)) {
            LOGGER.warn((Object)"No hook need to check.");
            return;
        }
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Set hookNameSet = iKubeHandler.getHooks(devSn).stream().map(HookBO::getName).collect(Collectors.toSet());
        checkHookList.forEach(hook -> {
            if (!hookNameSet.contains(hook)) {
                LOGGER.error((Object)"Hook %s not exist. DevSn: %s", new Object[]{hook, devSn});
                throw new LegoCheckedException(2117645L);
            }
        });
    }

    private void deleteCDRResources(ProtectGroup protectGroup) {
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType()) || PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.deleteReplicationProtectGroup(protectGroup);
        }
        if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.deleteBackUpProtectGroup(protectGroup);
        }
    }

    private void deleteBackUpProtectGroup(ProtectGroup protectGroup) {
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
            LOGGER.error((Object)"ProtectGroup:%s has replica.Can not delete.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947756L);
        }
        Map props = protectGroup.getProps();
        boolean isInstanceDel = false;
        List<BackupInstanceInfo> instances = KubeResourceBuildUtil.buildBackupInstance(Arrays.asList((String)props.get("kube_backup_instance")));
        IKubeHandler kubeHandler = this.getKubeHandler();
        isInstanceDel = this.isBackupInstanceDelete(protectGroup, kubeHandler, isInstanceDel, instances);
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.BACKUP_INSTANCE.getValue()), Arrays.asList(isInstanceDel));
        List<BackupLocationInfo> locations = KubeResourceBuildUtil.buildBackLocations(Arrays.asList((String)props.get("kube_backup_location")));
        List<KubeSchedulePolicy> policies = KubeResourceBuildUtil.buildKubePolicies(this.getListFromProps(props, "kube_policy"));
        String devSn = protectGroup.getPoProviderSN();
        boolean isLocationDel = false;
        boolean isPolicyDel = false;
        for (int retryTime = 1; !(retryTime >= 5 || isLocationDel && isPolicyDel); ++retryTime) {
            CommUtil.pauseThread((long)((long)retryTime * 1000L));
            isLocationDel = this.isBackUpLocationDelete(kubeHandler, isLocationDel, devSn, locations);
            isPolicyDel = this.isBackUpPolicyDelete(kubeHandler, isPolicyDel, devSn, policies);
        }
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.BACKUP_LOCATION.getValue(), KubeEnumDefine.KubeResourceType.SCHEDULE_POLICY.getValue()), Arrays.asList(isLocationDel, isPolicyDel));
        this.deleteCreatedVolumeSet(protectGroup, kubeHandler, protectGroup.getPoProviderSN());
    }

    private boolean isBackUpLocationDelete(IKubeHandler kubeHandler, boolean isBackUpLocationDelete, String devSn, List<BackupLocationInfo> backupLocations) {
        return isBackUpLocationDelete ? isBackUpLocationDelete : kubeHandler.deleteBackupLocations(devSn, backupLocations);
    }

    private boolean isBackUpPolicyDelete(IKubeHandler kubeHandler, boolean isBackUpPolicyDelete, String devSn, List<KubeSchedulePolicy> backupPolicies) {
        return isBackUpPolicyDelete ? isBackUpPolicyDelete : kubeHandler.deleteSchedulePolicy(devSn, backupPolicies);
    }

    private boolean isBackupInstanceDelete(ProtectGroup protectGroup, IKubeHandler kubeHandler, boolean isBackupInstanceDelete, List<BackupInstanceInfo> backupInstances) {
        block2: {
            long curTime;
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(backupInstances)) {
                LOGGER.error((Object)"BackupInstances are empty.");
                return true;
            }
            BackupInstanceInfo info = backupInstances.iterator().next();
            long startTime = System.currentTimeMillis();
            long waitTime = 180000L;
            do {
                kubeHandler.deleteBackupInstance(protectGroup.getPoProviderSN(), backupInstances);
                CommUtil.pauseThread((long)3000L);
                if (!kubeHandler.checkInstanceExist(protectGroup.getPoProviderSN(), info.getName())) break block2;
            } while ((curTime = System.currentTimeMillis()) - startTime <= waitTime);
            LOGGER.error((Object)"Delete backupInstance fail.");
            throw new LegoCheckedException(1073947760L, new String[]{KubeEnumDefine.KubeResourceType.BACKUP_INSTANCE.getValue()});
        }
        return true;
    }

    private void deleteReplicationProtectGroup(ProtectGroup protectGroup) {
        String srcSn = protectGroup.getPoProviderSN();
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        String trgSn = schedule.getTargetSn();
        IKubeHandler kubeHandler = this.getKubeHandler();
        KubeHyperMetroProtectGroupRefreshWatcher hyperMetroWatcher = (KubeHyperMetroProtectGroupRefreshWatcher)ServiceLocator.getInstance().getService(KubeHyperMetroProtectGroupRefreshWatcher.class);
        hyperMetroWatcher.deregister(protectGroup.getUuid());
        this.preDeleteCDRResource(srcSn, trgSn, kubeHandler, protectGroup);
        boolean isLocalScheduleDelete = false;
        boolean isRemoteScheduleDelete = false;
        boolean isProtectionPlanDelete = false;
        int maxTime = 360;
        for (int retryTime = 1; !(retryTime >= maxTime || isLocalScheduleDelete && isRemoteScheduleDelete && isProtectionPlanDelete); ++retryTime) {
            long millis = 5000L;
            CommUtil.pauseThread((long)millis);
            isProtectionPlanDelete = isProtectionPlanDelete ? isProtectionPlanDelete : this.checkProtectPlanDeleted(protectGroup, (String)protectGroup.getProps().get("kube_protection_plan"));
            List<KubeSchedulePolicy> schedules = KubeResourceBuildUtil.buildKubePolicies(this.getListFromProps(protectGroup.getProps(), "kube_policy"));
            isLocalScheduleDelete = isLocalScheduleDelete ? isLocalScheduleDelete : kubeHandler.deleteSchedulePolicy(srcSn, schedules);
            isRemoteScheduleDelete = isRemoteScheduleDelete ? isRemoteScheduleDelete : kubeHandler.deleteSchedulePolicy(trgSn, schedules);
        }
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.SCHEDULE_POLICY.getValue(), KubeEnumDefine.KubeResourceType.SCHEDULE_POLICY.getValue(), KubeEnumDefine.KubeResourceType.PROTECTION_PLAN.getValue()), Arrays.asList(isLocalScheduleDelete, isRemoteScheduleDelete, isProtectionPlanDelete));
        this.deleteTrgResourceSet(protectGroup, trgSn);
        this.postDeleteCDRResource(trgSn, kubeHandler, protectGroup.getProps(), protectGroup);
        this.deleteCreatedVolumeSet(protectGroup, kubeHandler, protectGroup.getPoProviderSN());
        this.deleteCreatedVolumeSet(protectGroup, kubeHandler, trgSn);
    }

    private void checkCDRResourceDeleted(ProtectGroup protectGroup, List<String> resourceNames, List<Boolean> isResourcesDeleted) {
        if (resourceNames.size() != isResourcesDeleted.size() || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(resourceNames)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> unDeletedResourceNames = new HashSet<String>();
        for (int i = 0; i < resourceNames.size(); ++i) {
            if (isResourcesDeleted.get(i).booleanValue()) continue;
            LOGGER.error((Object)"Delete %s failed.", new Object[]{resourceNames.get(i)});
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            unDeletedResourceNames.add(resourceNames.get(i));
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(unDeletedResourceNames)) {
            throw new LegoCheckedException(1073947760L, new String[]{((Object)unDeletedResourceNames).toString()});
        }
    }

    private void deleteTrgResourceSet(ProtectGroup protectGroup, String trgSn) {
        if (protectGroup.getTemplate().getType() == 55 || PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(protectGroup.getTemplate().getType())) {
            return;
        }
        boolean isKubeResourceSetDelete = true;
        try {
            for (ProtectObject po : protectGroup.getPolist()) {
                this.getKubeService().deleteKubeResourceSetByName(trgSn, po.getName());
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Delete CDR Resource failed. IsKubeResourceSetDelete:%s.", new Object[]{isKubeResourceSetDelete});
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            throw new LegoCheckedException(1073947760L, new String[]{KubeEnumDefine.KubeResourceType.RESOURCESET.getValue()});
        }
    }

    private boolean checkProtectPlanDeleted(ProtectGroup protectGroup, String name) {
        boolean isRemoteProtectPlanDeleted;
        IKubeHandler kubeHandler = this.getKubeHandler();
        boolean isLocalProtectPlanDeleted = !kubeHandler.checkProtectionPlanExist(protectGroup.getPoProviderSN(), name);
        boolean bl = isRemoteProtectPlanDeleted = !kubeHandler.checkProtectionPlanExist(((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray(), name);
        return isLocalProtectPlanDeleted && isRemoteProtectPlanDeleted;
    }

    private void deleteCreatedVolumeSet(ProtectGroup protectGroup, IKubeHandler kubeHandler, String devSn) {
        Map props = protectGroup.getProps();
        if (!props.containsKey("kube_volume_set_name")) {
            LOGGER.info((Object)"Not find wait deleted volumeSet");
            return;
        }
        String volumeSetName = (String)props.get("kube_volume_set_name");
        boolean isVolumeSetDelete = kubeHandler.deleteVolumeSet(devSn, volumeSetName);
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.VOLUMESET.getValue()), Arrays.asList(isVolumeSetDelete));
    }

    private void preDeleteCDRResource(String srcSn, String trgSn, IKubeHandler kubeHandler, ProtectGroup protectGroup) {
        Map props = protectGroup.getProps();
        boolean isSrcprotectPlanDelete = kubeHandler.deleteProtectionPlan(srcSn, KubeResourceBuildUtil.buildProtectionPlans(new ArrayList<String>(Arrays.asList((String)props.get("kube_protection_plan")))));
        boolean isTrgprotectPlanDelete = kubeHandler.deleteProtectionPlan(trgSn, KubeResourceBuildUtil.buildProtectionPlans(new ArrayList<String>(Arrays.asList((String)props.get("kube_protection_plan")))));
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.PROTECTION_PLAN.getValue(), KubeEnumDefine.KubeResourceType.PROTECTION_PLAN.getValue()), Arrays.asList(isSrcprotectPlanDelete, isTrgprotectPlanDelete));
    }

    private void postDeleteCDRResource(String trgSn, IKubeHandler kubeHandler, Map<String, String> props, ProtectGroup protectGroup) {
        String srcSn = protectGroup.getPoProviderSN();
        List<String> pvcWithNamespace = KubeResourceBuildUtil.buildPvcWithNamespace(protectGroup);
        List<PersistentVolumeClaimInfo> claimInfos = KubeResourceBuildUtil.buildPVCs(pvcWithNamespace, srcSn);
        HashSet podUsedClaimNames = new HashSet();
        boolean isPVCDelete = true;
        List pods = kubeHandler.getPods(trgSn, "");
        pods.forEach(pod -> podUsedClaimNames.addAll(pod.getClaims().stream().map(claim -> pod.getNameSpace() + claim).collect(Collectors.toSet())));
        List usedInfos = claimInfos.stream().filter(info -> podUsedClaimNames.contains(info.getNameSpace() + info.getName())).collect(Collectors.toList());
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(usedInfos)) {
            isPVCDelete = kubeHandler.deletePersistentVolumeClaim(trgSn, claimInfos);
        }
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.PERSISTENT_VOLUME_CLAIM.getValue()), Arrays.asList(isPVCDelete));
        kubeHandler.deleteCluster(srcSn, protectGroup.getProperty("localCluster"));
        kubeHandler.deleteCluster(srcSn, protectGroup.getProperty("remoteCluster"));
        kubeHandler.deleteCluster(trgSn, protectGroup.getProperty("localCluster"));
        kubeHandler.deleteCluster(trgSn, protectGroup.getProperty("remoteCluster"));
        String pvcMeta = props.get("kube_metadata_pvc_name");
        List<PersistentVolumeClaimInfo> infos = KubeResourceBuildUtil.buildPVCs(Collections.singletonList(pvcMeta), srcSn);
        kubeHandler.deletePersistentVolumeClaim(srcSn, infos);
        kubeHandler.deletePersistentVolumeClaim(trgSn, infos);
        List nameSpaces = kubeHandler.getNameSpaces(trgSn);
        ArrayList<PersistentVolumeClaimInfo> persistentVolumeBOS = new ArrayList<PersistentVolumeClaimInfo>();
        nameSpaces.forEach(name -> persistentVolumeBOS.addAll(kubeHandler.getKubePersistentVolumeClaims(trgSn, name)));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(claimInfos)) {
            return;
        }
        List<String> scNames = this.getListFromProps(props, "storage_class");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(scNames) || this.isScUsed(scNames, persistentVolumeBOS)) {
            LOGGER.warn((Object)"Sc is used.");
            return;
        }
        boolean isSCDelete = kubeHandler.deleteStorageClass(trgSn, KubeResourceBuildUtil.buildSCs(scNames));
        this.checkCDRResourceDeleted(protectGroup, Arrays.asList(KubeEnumDefine.KubeResourceType.STORAGE_CLASS.getValue()), Arrays.asList(isSCDelete));
    }

    private boolean isScUsed(List<String> scNames, List<PersistentVolumeClaimInfo> persistentVolumeBOS) {
        HashSet<String> scNameSet = new HashSet<String>(scNames);
        for (PersistentVolumeClaimInfo info : persistentVolumeBOS) {
            if (!scNameSet.contains(info.getStorageClassName())) continue;
            return true;
        }
        return false;
    }

    private static void buildTimeWaitPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        int syncType = schedule.getSyncType();
        if (syncType == 1) {
            policy.setTimeWait(KubeEnumDefine.TimeWaitType.AFTER_SYNC_BEGINS);
        } else if (syncType == 2) {
            policy.setTimeWait(KubeEnumDefine.TimeWaitType.AFTER_SYNC_ENDS);
        } else {
            LOGGER.error((Object)"The timeWait type value: %s is error", new Object[]{String.valueOf(syncType)});
            throw new LegoCheckedException(2117645L);
        }
        policy.setSeconds(NumberUtil.convertToInteger((Object)schedule.getSeconds()).intValue());
    }

    private static void buildHourPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        policy.setPolicyType(KubeEnumDefine.PolicyType.HOURS);
        policy.setMinutes(NumberUtil.convertToInteger((Object)schedule.getMinutes()).intValue());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getLatestCopies());
        }
    }

    private static void buildDailyPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        policy.setPolicyType(KubeEnumDefine.PolicyType.DAILY);
        policy.setTime(schedule.getHours() + ":" + schedule.getMinutes());
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getDailyCopies());
        }
    }

    private static void buildWeeklyPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        String daysOfWeek = schedule.getDaysOfWeek();
        String[] days = daysOfWeek.split(",");
        policy.setWeeklyDays(Arrays.stream(days).map(item -> KubeEnumDefine.DayOfWeek.getValue((int)NumberUtil.convertToInteger((Object)item))).collect(Collectors.toList()));
        policy.setPolicyType(KubeEnumDefine.PolicyType.WEEKLY);
        policy.setTime(schedule.getHours() + ":" + schedule.getMinutes());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getWeeklyCopies());
        }
    }

    private static void buildMonthPolicy(Schedule schedule, KubeSchedulePolicy policy) {
        policy.setPolicyType(KubeEnumDefine.PolicyType.MONTHLY);
        String dayOfMonth = schedule.getDaysOfMonth();
        String[] days = dayOfMonth.split(",");
        policy.setMonthlyDates(Arrays.stream(days).map(NumberUtil::convertToInteger).collect(Collectors.toList()));
        policy.setTime(schedule.getHours() + ":" + schedule.getMinutes());
        if (!VerifyUtil.isEmpty((Object)schedule.getRetentionPolicy())) {
            policy.setRetain(schedule.getRetentionPolicy().getMonthlyCopyies());
        }
    }

    private List<String> getListFromProps(Map<String, String> props, String prop) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)props.get(prop))) {
            return new ArrayList<String>();
        }
        List strs = (List)JSONObject.toBean((String)props.get(prop), List.class);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)strs)) {
            return new ArrayList<String>();
        }
        return strs;
    }

    private void refreshCDRResources(ProtectGroup protectGroup) {
        int templateType = protectGroup.getTemplate().getType();
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.refreshReplicationRespources(protectGroup);
        } else if (PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(templateType)) {
            KubeRefreshHyperMetroProtectGroupService hyperMetroRefreshService = (KubeRefreshHyperMetroProtectGroupService)ServiceLocator.getInstance().getService(KubeRefreshHyperMetroProtectGroupService.class);
            hyperMetroRefreshService.refreshHyperMetroProtectGroup(protectGroup);
        } else {
            this.refreshBackupResources(protectGroup);
        }
    }

    private void refreshReplicationRespources(ProtectGroup protectGroup) {
        if (protectGroup.getTemplate().getType() == 54) {
            this.refreshResourceSetProtectGroup(protectGroup);
        } else {
            this.refreshPVCProtectGroup(protectGroup);
        }
    }

    private void refreshResourceSetProtectGroup(ProtectGroup protectGroup) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        String srcSn = protectGroup.getPoProviderSN();
        String trgSn = ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
        String planName = protectGroup.getProperty("kube_protection_plan");
        if (!kubeHandler.checkProtectionPlanExist(srcSn, planName)) {
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            LOGGER.error((Object)"Protect plan:%s not in source device.", new Object[]{planName});
            throw new LegoCheckedException(1073947394L);
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            String resourceSetName = po.getName();
            Optional srcResourceSetInfoOpt = kubeHandler.getResourceSetInfo(srcSn, resourceSetName);
            Optional trgResourceSetInfoOpt = kubeHandler.getResourceSetInfo(trgSn, resourceSetName);
            if (!srcResourceSetInfoOpt.isPresent() || !trgResourceSetInfoOpt.isPresent()) {
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
                LOGGER.error((Object)"Resourceset:%s not in source device or target device.", new Object[]{resourceSetName});
                throw new LegoCheckedException(1073947394L);
            }
            KubeRefreshResourceUtils.refreshResourceSet(srcSn, resourceSetName);
        }
        this.checkAndSetResourceSetCapacity(protectGroup, kubeHandler);
        this.refreshVolumeSet(protectGroup);
        this.monitorProtectionPlan(protectGroup, kubeHandler, planName);
    }

    private void checkAndSetResourceSetCapacity(ProtectGroup pg, IKubeHandler kubeHandler) {
        double count = 0.0;
        for (ProtectObject po : pg.getPolist()) {
            List pvcList = kubeHandler.getResourceSetPVCs(pg.getPoProviderSN(), (String)po.getProps().get("resourceDetailName"));
            double sumCapacity = 0.0;
            for (KubeResourceSetPVC pvc : pvcList) {
                sumCapacity += pvc.getKubePV().getCapacity();
            }
            double oldUsed = NumberUtil.convertToDouble((Object)po.getProps().getOrDefault("capacity", "0"));
            po.getProps().put("capacity", String.valueOf(sumCapacity));
            count += sumCapacity - oldUsed;
        }
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkLicenseEnableWithCapacity("BOMBCMREPSWTB", new Double(count).intValue());
    }

    private void refreshVolumeSet(ProtectGroup protectGroup) {
        String srcSn;
        IKubeHandler kubeHandler = this.getKubeHandler();
        Set<KubeResourceSetPVC> srcPvcs = this.getResourceSetPvcs(protectGroup, kubeHandler, srcSn = protectGroup.getPoProviderSN());
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(srcPvcs)) {
            LOGGER.error((Object)"Pvc not exist in source device.");
            throw new LegoCheckedException(2117645L);
        }
        String trgSn = ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
        KubeVolumeSet trgVolumeSet = kubeHandler.getVolumeSet(trgSn, protectGroup.getProperty("kube_volume_set_name"));
        Set<String> trgPVCNames = trgVolumeSet.getVolumePairs().stream().map(MetadataPairInfo::getPvcMeta).collect(Collectors.toSet());
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(trgPVCNames)) {
            LOGGER.error((Object)"Pvc not exist in target device.");
            throw new LegoCheckedException(2117645L);
        }
        Set<String> srcPvcName = srcPvcs.stream().map(pvc -> pvc.getNamespace() + "/" + pvc.getName()).collect(Collectors.toSet());
        Set<String> addPvcNames = this.getAdditionalPvcs(srcPvcName, trgPVCNames);
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(addPvcNames)) {
            for (String name : addPvcNames) {
                String[] array = name.split("/");
                PersistentVolumeClaimInfo info = (PersistentVolumeClaimInfo)kubeHandler.getPersistentVolumeClaimInfo(srcSn, array[1], array[0]).orElseThrow(() -> new LegoCheckedException(2117645L, "ResourceSet not exist."));
                kubeHandler.createPersistentVolumeClaim(trgSn, info);
            }
        }
        ArrayList pairInfos = new ArrayList(srcPvcs.size());
        srcPvcs.forEach(pvc -> pairInfos.add(this.transToVolumePair((KubeResourceSetPVC)pvc, srcSn, trgSn)));
        KubeVolumeSet srcVolumeSet = kubeHandler.getVolumeSet(srcSn, protectGroup.getProperty("kube_volume_set_name"));
        srcVolumeSet.setVolumePairs(pairInfos);
        trgVolumeSet.setVolumePairs(pairInfos);
        kubeHandler.rebuildVolumeSet(srcSn, srcVolumeSet);
        kubeHandler.rebuildVolumeSet(trgSn, trgVolumeSet);
        Set<String> deletePvcNames = this.getAdditionalPvcs(trgPVCNames, srcPvcName);
        kubeHandler.deletePersistentVolumeClaim(trgSn, KubeResourceBuildUtil.buildPVCs(new ArrayList<String>(deletePvcNames), trgSn));
    }

    private Set<String> getAdditionalPvcs(Set<String> srcPvcs, Set<String> trgPvcs) {
        return srcPvcs.stream().filter(pvc -> !trgPvcs.contains(pvc)).collect(Collectors.toSet());
    }

    private Set<KubeResourceSetPVC> getResourceSetPvcs(ProtectGroup protectGroup, IKubeHandler kubeHandler, String devSn) {
        ResourceSetInfo srcInfo = (ResourceSetInfo)kubeHandler.getResourceSetInfo(devSn, ((ProtectObject)protectGroup.getPolist().iterator().next()).getName()).orElseThrow(() -> new LegoCheckedException(2117645L, "ResourceSet not exist."));
        return new HashSet<KubeResourceSetPVC>(kubeHandler.getResourceSetPVCs(devSn, srcInfo.getResourceDetailName()));
    }

    private MetadataPairInfo transToVolumePair(KubeResourceSetPVC pvc, String providerSn, String targetSn) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        MetadataPairInfo pairInfo = new MetadataPairInfo();
        pairInfo.setPvcMeta(pvc.getNamespace() + "/" + pvc.getName());
        int maxTime = 5;
        for (int retryTime = 1; retryTime < maxTime; ++retryTime) {
            Optional priOpt = kubeHandler.getPersistentVolumeClaimInfo(providerSn, pvc.getName(), pvc.getNamespace());
            Optional targetOpt = kubeHandler.getPersistentVolumeClaimInfo(targetSn, pvc.getName(), pvc.getNamespace());
            if (!priOpt.isPresent() || !targetOpt.isPresent()) {
                LOGGER.warn((Object)"No volumeName in pvc:%s at retryTime:%s.", new Object[]{pvc.getName(), retryTime});
                CommUtil.pauseThread((long)6000L);
                continue;
            }
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)((PersistentVolumeClaimInfo)priOpt.get()).getVolumeName()) || VerifyUtil.isEmpty((String)((PersistentVolumeClaimInfo)targetOpt.get()).getVolumeName())) {
                LOGGER.warn((Object)"No volumeName in pvc:%s at retryTime:%s.", new Object[]{pvc.getName(), retryTime});
                CommUtil.pauseThread((long)6000L);
                continue;
            }
            pairInfo.setPrimaryPVName(((PersistentVolumeClaimInfo)priOpt.get()).getVolumeName());
            pairInfo.setSecondaryPVName(((PersistentVolumeClaimInfo)targetOpt.get()).getVolumeName());
            break;
        }
        return pairInfo;
    }

    private void checkProtectionPlanExist(ProtectGroup protectGroup, IKubeHandler kubeHandler, String srcSn, String planName) {
        Optional protectionPlanOpt = kubeHandler.getProtectionPlan(srcSn, planName);
        if (!protectionPlanOpt.isPresent()) {
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            LOGGER.error((Object)"Protect plan:%s not in source device.", new Object[]{planName});
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void monitorProtectionPlan(ProtectGroup protectGroup, IKubeHandler kubeHandler, String planName) {
        String[] params = new String[]{planName, protectGroup.getName(), protectGroup.getName()};
        KubeProtectionPlan protectionPlan = (KubeProtectionPlan)kubeHandler.getProtectionPlan(protectGroup.getPoProviderSN(), planName).get();
        kubeHandler.rebuildProtectionPlan(protectGroup.getPoProviderSN(), planName);
        AlarmReporter.restoreAlarm((String)"0x3230087", (String[])params);
        ExecutionService.submit((Runnable)new MonitorProtectionPlanTask(protectGroup, protectionPlan));
    }

    private void refreshPVCProtectGroup(ProtectGroup protectGroup) {
        IKubeHandler kubeHandler = this.getKubeHandler();
        String srcSn = protectGroup.getPoProviderSN();
        String trgSn = ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
        String planName = protectGroup.getProperty("kube_protection_plan");
        this.checkProtectionPlanExist(protectGroup, kubeHandler, srcSn, planName);
        for (ProtectObject po : protectGroup.getPolist()) {
            String pvcName = po.getName();
            String nameSpace = po.getProperty("namespace");
            Optional srcPVCInfoOpt = kubeHandler.getPersistentVolumeClaimInfo(srcSn, pvcName, nameSpace);
            Optional trgPVCInfoOpt = kubeHandler.getPersistentVolumeClaimInfo(trgSn, pvcName, nameSpace);
            if (srcPVCInfoOpt.isPresent() && trgPVCInfoOpt.isPresent()) continue;
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            LOGGER.error((Object)"Resourceset:%s not in source device or target device.", new Object[]{pvcName});
            throw new LegoCheckedException(1073947394L);
        }
        this.monitorProtectionPlan(protectGroup, kubeHandler, planName);
    }

    private void refreshBackupResources(ProtectGroup protectGroup) {
        Map props = protectGroup.getProps();
        String srcSn = protectGroup.getPoProviderSN();
        IKubeHandler kubeHandler = this.getKubeHandler();
        Set<String> backupInstanceInfoNameSet = kubeHandler.getBackupInstanceInfos(srcSn).stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toSet());
        String backupInstanceInfoName = (String)props.get("kube_backup_instance");
        String backupLocationInfoName = (String)props.get("kube_backup_location");
        this.checkCDRBackupResource(protectGroup, Arrays.asList(backupInstanceInfoName), backupInstanceInfoNameSet, BackupInstanceInfo.class);
        Set<String> backupLocationInfoNameSet = kubeHandler.getBackupLocationInfos(srcSn).stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toSet());
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)backupLocationInfoName)) {
            this.checkCDRBackupResource(protectGroup, Arrays.asList(backupLocationInfoName), backupLocationInfoNameSet, BackupLocationInfo.class);
        }
        Set<String> kubeSchedulePolicieNamesSet = kubeHandler.getKubeSchedulePolicys(srcSn).stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toSet());
        List<String> kubeSchedulePolicieNames = this.getListFromProps(props, "kube_policy");
        this.checkCDRBackupResource(protectGroup, kubeSchedulePolicieNames, kubeSchedulePolicieNamesSet, KubeSchedulePolicy.class);
        protectGroup.getPolist().forEach(po -> KubeRefreshResourceUtils.refreshResourceSet(protectGroup.getPoProviderSN(), po.getName()));
        this.checkAndSetResourceSetCapacity(protectGroup, kubeHandler);
    }

    private <T extends AbstractKubeBackupModel> void checkCDRBackupResource(ProtectGroup protectGroup, List<String> localNames, Set<String> cdrNames, Class<T> clazz) {
        boolean isCDRBackupResourceExist = true;
        String[] params = new String[]{clazz.getName(), protectGroup.getName()};
        for (String name : localNames) {
            if (cdrNames.contains(name)) continue;
            LOGGER.error((Object)"%s:%s not exist.", new Object[]{clazz.getSimpleName(), name});
            isCDRBackupResourceExist = false;
        }
        if (!isCDRBackupResourceExist) {
            AlarmReporter.sendAlarm((String)"0x3230078", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
            LOGGER.error((Object)"CDRBackupResource %s not exist.", new Object[]{clazz.getSimpleName()});
            throw new LegoCheckedException(2117645L);
        }
        AlarmReporter.restoreAlarm((String)"0x3230078", (String[])params);
    }

    private boolean isCDRPVChange(List<String> persistentVolumeNmaes, Map<String, PersistentVolumeBO> pvcMap) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(persistentVolumeNmaes)) {
            LOGGER.warn((Object)"PersistentVolume is null.");
            return true;
        }
        for (String name : persistentVolumeNmaes) {
            if (pvcMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isCDRResourceSetChange(List<ResourceSetInfo> resourceSetInfos, Map<String, ResourceSetInfo> resourcesetMap) {
        List changedResourceSets = resourceSetInfos.stream().filter(resourceSetInfo -> !resourceSetInfo.equals(resourcesetMap.get(resourceSetInfo.getName()))).collect(Collectors.toList());
        return changedResourceSets.size() != 0;
    }

    private IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    private IKubeService getKubeService() {
        return (IKubeService)ServiceLocator.getInstance().getService(KubeServiceImpl.class);
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

