/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.msg;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.recovery.process.reprotect.hypermetro.KubeHyperMetroRoleReverseProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Component;

@Component
public class KubeRecoveryPlanObserverImpl
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(KubeHyperMetroRoleReverseProcessor.class);

    public void before(MessageEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(MessageEvent event) {
        if (VerifyUtil.isEmpty((Collection)event.getObjectList())) {
            return;
        }
        for (DRMObject drmObj : event.getObjectList()) {
            RecoveryPlan recoveryPlan;
            ProtectGroup protectGroup;
            if (!(drmObj instanceof RecoveryPlan) || !PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains((protectGroup = (recoveryPlan = (RecoveryPlan)drmObj).getProtectGroup()).getTemplate().getType()) || Boolean.parseBoolean(String.valueOf(event.getMessageMap().get("IS_RE_PROTECT_SUCCESS")))) continue;
            Session session = null;
            LOGGER.info((Object)"Start update protect group status to invalid. Group id: %s, group name: %s", new Object[]{protectGroup.getUuid(), protectGroup.getName()});
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET status=3 WHERE pgid=:pgid";
                session.beginTransaction();
                NativeQuery query = session.createSQLQuery(sql);
                query.setString("pgid", protectGroup.getUuid());
                query.executeUpdate();
                session.getTransaction().commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession((Session)session);
                    LOGGER.error((Object)"Update protect group status failed. Group id: %s, group name: %s", new Object[]{protectGroup.getUuid(), protectGroup.getName()});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
            DBOperationUtil.closeSession((Session)session);
            LOGGER.info((Object)"Update protect group status complete. Group id: %s, group name: %s", new Object[]{protectGroup.getUuid(), protectGroup.getName()});
        }
    }

    public String getObserverType() {
        return RecoveryPlan.class.getName();
    }
}

