/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.calculator;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class KubeReplicationRecoveryPointObjectiveCalculator
extends BaseRecoveryPointObjectiveCalculator {
    private static final Log LOGGER = LogFactory.getInstance(KubeReplicationRecoveryPointObjectiveCalculator.class);
    private final String comma = ",";

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class).get();
        String key = protectGroup.getProductSiteId() + "," + ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSiteId() + "," + String.valueOf(protectGroup.getTemplate().getType());
        Schedule schedule = protectGroup.getTemplate().getSchedules().stream().filter(schedule1 -> schedule1.getScheduleMode() == 0 && schedule1.isEnable() != false && Boolean.TRUE.equals(schedule1.isEnableRpoCheck())).findAny().orElse(null);
        HashMap<String, Object> configuredRPO = new HashMap<String, Object>();
        configuredRPO.put(key, VerifyUtil.isEmpty((Object)schedule) || VerifyUtil.isEmpty((Object)schedule.getExpectedRPO()) ? -1L : schedule.getExpectedRPO().getExpectedRPOValue());
        return configuredRPO;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        HashMap<String, Object> actualRPOs = new HashMap<String, Object>();
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class).get();
        String key = protectGroup.getProductSiteId() + "," + ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSiteId() + "," + String.valueOf(protectGroup.getTemplate().getType());
        if (VerifyUtil.isEmpty((Object)protectGroup.getLastExecTime()) || protectGroup.getLastExecTime() == 0L) {
            actualRPOs.put(key, -1);
            return actualRPOs;
        }
        Schedule schedule = protectGroup.getTemplate().getSchedules().stream().filter(schedule1 -> schedule1.getScheduleMode() == 0 && schedule1.isEnable() != false).findAny().orElse(null);
        Long lastSuccessExecuteTime = this.getLastSuccessExecuteTime(protectGroup.getUuid());
        actualRPOs.put(key, !VerifyUtil.isEmpty((Object)schedule) && lastSuccessExecuteTime != -1L ? System.currentTimeMillis() - lastSuccessExecuteTime : -1L);
        return actualRPOs;
    }

    private Long getLastSuccessExecuteTime(String pgId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ProtectGroupLog.class);
        criteria.add((Criterion)Restrictions.eq((String)"pgId", (Object)pgId));
        criteria.add((Criterion)Restrictions.eq((String)"result", (Object)1L));
        criteria.addOrder(Order.desc((String)"endTime"));
        List byCriteria = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)byCriteria)) {
            return -1L;
        }
        return Long.parseLong(((ProtectGroupLog)byCriteria.iterator().next()).getEndTime());
    }

    public List<String> getTypes() {
        LOGGER.info((Object)"Get types : %s,%s,%s", new Object[]{String.valueOf(54), String.valueOf(49), String.valueOf(50)});
        return Arrays.asList(String.valueOf(54), String.valueOf(49), String.valueOf(50));
    }

    protected Object getProductSiteId(String key) {
        String[] siteIdArray = key.split(",");
        if (siteIdArray.length != 3) {
            LOGGER.error((Object)("Get productSiteId error! key: " + key), 90160758787071L);
            return "";
        }
        return siteIdArray[0];
    }

    protected Object getProtectedType(String str) {
        String[] siteIdArray = str.split(",");
        if (siteIdArray.length != 3) {
            LOGGER.error((Object)"Get site id error! str:%s", new Object[]{str});
            return "";
        }
        return siteIdArray[2];
    }

    protected String getSiteId(String str) {
        String[] siteIdArray = str.split(",");
        if (siteIdArray.length != 3) {
            LOGGER.error((Object)"getSiteId error! str:%s", new Object[]{str});
            return "";
        }
        return siteIdArray[1];
    }
}

