/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.synchronizer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeBackup;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class KubeBackupReplicaAutoSynchronizer
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(KubeBackupReplicaAutoSynchronizer.class);
    private static final Long ADMIN_USER_ID = 1L;
    private static final int SCHEDULE_DELAY = 5;
    private static final int SCHEDULE_INITIAL_DELAY = 10;
    private static final List<Integer> SYNCHRONIZE_BACKUP_TEMPLATE_TYPES = Collections.unmodifiableList(Arrays.asList(49, 50));
    private static final List<Integer> SYNCHRONIZE_REPLICATION_TEMPLATE_TYPES = Collections.unmodifiableList(Arrays.asList(54, 55));

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            LOGGER.info((Object)"Start-up kubernetes replica synchronizer");
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("kube-replica-synchronizer-task-thread").build());
            executor.scheduleWithFixedDelay(new SynchronizeReplicaTask(), 10L, 5L, TimeUnit.SECONDS);
        }
    }

    private void dealWithKubeJobs(ProtectGroup protectGroup) {
        if (SYNCHRONIZE_BACKUP_TEMPLATE_TYPES.contains(protectGroup.getTemplate().getType())) {
            String backupInstanceName = (String)protectGroup.getProps().get("kube_backup_instance");
            if (VerifyUtil.isEmpty((String)backupInstanceName)) {
                LOGGER.warn((Object)"Can not find backup instance name from props (key: %s) of protect group (%s)", new Object[]{"kube_backup_instance", protectGroup.getName()});
                return;
            }
            LOGGER.info((Object)"Start deal with backup jobs of backup instance %s", new Object[]{backupInstanceName});
            this.checkIfCreateBackupProcessor(protectGroup, backupInstanceName);
            this.removeBackup(protectGroup);
        } else {
            String planName = (String)protectGroup.getProps().get("kube_protection_plan");
            if (VerifyUtil.isEmpty((String)planName)) {
                LOGGER.warn((Object)"Can not find protection plan name from props (key: %s) of protect group (%s)", new Object[]{"kube_protection_plan", protectGroup.getName()});
                return;
            }
            LOGGER.info((Object)"Start deal with protection jobs of protection plan %s", new Object[]{planName});
            this.checkIfCreateReplicationProcessor(protectGroup, planName);
        }
    }

    private void removeBackup(ProtectGroup protectGroup) {
        List backups = this.getIKubeHandler().getBackupByBackupLocation(protectGroup.getPoProviderSN(), (String)protectGroup.getProps().get("kube_backup_location"));
        if (VerifyUtil.isEmpty((Collection)backups)) {
            return;
        }
        List backupNames = backups.stream().map(KubeBackup::getName).collect(Collectors.toList());
        List replicas = this.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), null, false);
        List shouldRemoveReplicas = replicas.stream().filter(e -> !backupNames.contains(e.getName())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(shouldRemoveReplicas)) {
            return;
        }
        for (ProtectGroupReplica removeItem : shouldRemoveReplicas) {
            LOGGER.warn((Object)"Remove protect group replica (%s) of group (%s)", new Object[]{removeItem.getId(), protectGroup.getName()});
            this.getReplicaService().deleteProtectGroupReplicaById(removeItem.getId());
        }
    }

    private void checkIfCreateBackupProcessor(ProtectGroup protectGroup, String backupInstanceName) {
        IKubeHandler kubeHandler = this.getIKubeHandler();
        List backupJobs = kubeHandler.getBackupJobByInstance(protectGroup.getPoProviderSN(), backupInstanceName);
        if (VerifyUtil.isEmpty((Collection)backupJobs)) {
            LOGGER.info((Object)"Could not find BackupJob of BackupInstance %s", new Object[]{backupInstanceName});
            return;
        }
        List newJobs = backupJobs.stream().filter(e -> !e.getLabels().containsKey("bcm-backupjob")).collect(Collectors.toList());
        LOGGER.info((Object)"New jobs: %s", new Object[]{newJobs.stream().map(KubeBackupJob::getName).collect(Collectors.joining(","))});
        for (KubeBackupJob job : newJobs) {
            boolean isJobStatusFail = KubeEnumDefine.BackupJobStatus.FAILED.getValue().equals(job.getStatus());
            boolean isJobStatusComplete = KubeEnumDefine.BackupJobStatus.COMPLETED.getValue().equals(job.getStatus());
            boolean isJobEventEmpty = VerifyUtil.isEmpty((Collection)kubeHandler.getKubeEvent(protectGroup.getPoProviderSN(), job.getName()));
            boolean isJobStageFinished = KubeEnumDefine.BackupJobStage.FINISHED.getValue().equals(job.getStage());
            LOGGER.info((Object)"Start handle BackupJob %s. isJobStatusFail: %s, isJobStatusComplete: %s, isJobEventEmpty: %s, isJobStageFinished: %s", new Object[]{job.getName(), isJobStatusFail, isJobStatusComplete, isJobEventEmpty, isJobStageFinished});
            if (!isJobEventEmpty || !isJobStatusFail && (!isJobStatusComplete || !isJobStageFinished)) continue;
            this.editjobWithLabel(protectGroup, kubeHandler, job);
        }
        List addedJobs = backupJobs.stream().filter(e -> !e.getLabels().containsKey("bcm-backupjob")).collect(Collectors.toList());
        for (KubeBackupJob job : addedJobs) {
            Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
            HashMap<String, KubeBackupJob> parameter = new HashMap<String, KubeBackupJob>();
            parameter.put("backupJob", job);
            Map<String, String> labels = VerifyUtil.isEmpty((Map)job.getLabels()) ? new HashMap() : job.getLabels();
            labels.put("bcm-backupjob", String.valueOf(System.currentTimeMillis()));
            this.getIKubeHandler().editBackupJobWithLabel(protectGroup.getPoProviderSN(), job.getName(), labels);
            this.getProtectGroupService().runSchedule(protectGroup.getUuid(), schedule.getScheduleId(), parameter);
        }
    }

    private void checkIfCreateReplicationProcessor(ProtectGroup protectGroup, String planName) {
        IKubeHandler kubeHandler = this.getIKubeHandler();
        KubeProtectionPlan plan = (KubeProtectionPlan)kubeHandler.getProtectionPlan(protectGroup.getPoProviderSN(), planName).orElseThrow(() -> new LegoCheckedException(1073947394L, "Protection plan not exist."));
        ArrayList protectionJobs = new ArrayList();
        if (VerifyUtil.isEmpty((Collection)plan.getProtectionSchedulesInStatus())) {
            return;
        }
        plan.getProtectionSchedulesInStatus().forEach(scheduleName -> protectionJobs.addAll(kubeHandler.getProtectionJobByPlanName(protectGroup.getPoProviderSN(), scheduleName)));
        if (VerifyUtil.isEmpty(protectionJobs)) {
            return;
        }
        for (KubeProtectionJob job : protectionJobs) {
            boolean isJobStatusFail = KubeEnumDefine.BackupJobStatus.FAILED.getValue().equals(job.getStatus());
            boolean isJobStatusComplete = KubeEnumDefine.BackupJobStatus.COMPLETED.getValue().equals(job.getStatus());
            boolean isJobEventEmpty = VerifyUtil.isEmpty((Collection)kubeHandler.getKubeEvent(protectGroup.getPoProviderSN(), job.getName()));
            boolean isJobStageFinished = KubeEnumDefine.BackupJobStage.FINISHED.getValue().equals(job.getStage());
            LOGGER.info((Object)"Start handle ProtectionJob %s. isJobStatusFail: %s, isJobStatusComplete: %s, isJobEventEmpty: %s, isJobStageFinished: %s", new Object[]{job.getName(), isJobStatusFail, isJobStatusComplete, isJobEventEmpty, isJobStageFinished});
            if (!isJobEventEmpty || !isJobStatusFail && (!isJobStatusComplete || !isJobStageFinished)) continue;
            this.editjobWithLabel(protectGroup, kubeHandler, job);
        }
        List addedJobs = protectionJobs.stream().filter(e -> !e.getLabels().containsKey("bcm-protectionjob")).collect(Collectors.toList());
        for (KubeProtectionJob job : addedJobs) {
            this.editjobWithLabel(protectGroup, kubeHandler, job);
            Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
            HashMap<String, KubeProtectionJob> parameter = new HashMap<String, KubeProtectionJob>();
            parameter.put("protectionJob", job);
            this.getProtectGroupService().runSchedule(protectGroup.getUuid(), schedule.getScheduleId(), parameter);
        }
    }

    private void editjobWithLabel(ProtectGroup protectGroup, IKubeHandler kubeHandler, KubeProtectionJob job) {
        Map<String, String> labels = VerifyUtil.isEmpty((Map)job.getLabels()) ? new HashMap() : job.getLabels();
        labels.put("bcm-protectionjob", String.valueOf(System.currentTimeMillis()));
        job.setLabels(labels);
        kubeHandler.editProtectionJobWithLabel(protectGroup.getPoProviderSN(), job.getName(), labels);
    }

    private void editjobWithLabel(ProtectGroup protectGroup, IKubeHandler kubeHandler, KubeBackupJob job) {
        Map<String, String> labels = VerifyUtil.isEmpty((Map)job.getLabels()) ? new HashMap() : job.getLabels();
        labels.put("bcm-backupjob", String.valueOf(System.currentTimeMillis()));
        job.setLabels(labels);
        kubeHandler.editBackupJobWithLabel(protectGroup.getPoProviderSN(), job.getName(), labels);
    }

    private IKubeHandler getIKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    private IProtectGroupService getProtectGroupService() {
        return (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
    }

    private IReplicaBaseService getReplicaService() {
        return (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
    }

    private class SynchronizeReplicaTask
    implements Runnable {
        private SynchronizeReplicaTask() {
        }

        @Override
        public void run() {
            List protectGroups = null;
            try {
                protectGroups = KubeBackupReplicaAutoSynchronizer.this.getProtectGroupService().getProtectGroupByType(20, ADMIN_USER_ID, true);
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Query protect group failed", e);
            }
            if (VerifyUtil.isEmpty((Collection)protectGroups)) {
                return;
            }
            for (ProtectGroup protectGroup : protectGroups) {
                if (!SYNCHRONIZE_BACKUP_TEMPLATE_TYPES.contains(protectGroup.getTemplate().getType()) && !SYNCHRONIZE_REPLICATION_TEMPLATE_TYPES.contains(protectGroup.getTemplate().getType())) continue;
                try {
                    KubeBackupReplicaAutoSynchronizer.this.dealWithKubeJobs(protectGroup);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)"Synchronize Kube Backup Replica failed", e);
                }
            }
        }
    }
}

