/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.plugin;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.utils.KubeRecoveryUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryPlanUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class KubeRecoveryPlanPluginUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryPlanPluginUtil.class);
    private static final int SITE_INDEX_PRODUCTION = 0;
    private static final int SITE_INDEX_DISASTER = 1;

    public static void validate(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String[] deviceSnArr = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)recoveryPlan);
        String productSn = deviceSnArr[0];
        VerifyUtil.checkStrs((String[])new String[]{productSn});
        String postHook = (String)globalSettings.get("postHook");
        int policyTemplate = RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType();
        if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(policyTemplate)) {
            String namespace = (String)globalSettings.get("namespace");
            KubeRecoveryUtils.checkNamespace(productSn, namespace);
            KubeRecoveryUtils.checkHook(productSn, postHook);
            KubeRecoveryUtils.checkBoolSetting(globalSettings, "preserveNodePort", false);
            KubeRecoveryUtils.checkBoolSetting(globalSettings, "preserveClusterIpAddr", false);
            String restorePrefix = (String)globalSettings.get("restorePrefix");
            KubeRecoveryUtils.checkPrefix(restorePrefix);
            KubeRecoveryPlanPluginUtil.getKubeHandler().checkClusterStatus(productSn);
        } else if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(policyTemplate)) {
            String disasterSn = deviceSnArr[1];
            VerifyUtil.checkStrs((String[])new String[]{disasterSn});
            KubeRecoveryUtils.checkHook(disasterSn, postHook);
            KubeRecoveryUtils.checkCdrStatus(disasterSn, recoveryPlan.getProtectGroup());
            KubeRecoveryPlanPluginUtil.getKubeHandler().checkClusterStatus(disasterSn);
        } else if (PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(policyTemplate)) {
            String disasterSn = deviceSnArr[1];
            VerifyUtil.checkStrs((String[])new String[]{disasterSn});
            KubeRecoveryUtils.checkCdrStatus(disasterSn, recoveryPlan.getProtectGroup());
            KubeRecoveryPlanPluginUtil.getKubeHandler().checkClusterStatus(disasterSn);
        } else {
            LOGGER.error((Object)"Create recovery plan error,cause invalid policy template.template: %s", new Object[]{policyTemplate});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkCdrRecoveryPlanExist(String devSn, RecoveryPlan recoveryPlan) {
        Optional recoveryPlanOptional = KubeRecoveryPlanPluginUtil.getKubeHandler().getKubeRecoveryPlan(devSn, KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(recoveryPlan));
        if (!recoveryPlanOptional.isPresent()) {
            LOGGER.error((Object)"Validate kubernetes parameter error, target recovery plan is not exist while modifying plan");
            throw new LegoCheckedException(2117645L);
        }
    }

    public static KubeRecoveryPlan convertRecoveryPlan(RecoveryPlan src, String role) {
        KubeRecoveryPlan dst = new KubeRecoveryPlan();
        dst.setRole(role);
        dst.setName(KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(src));
        Map globalSettings = src.getGlobalSettings();
        String postHook = (String)globalSettings.get("postHook");
        dst.setPostHookName(postHook);
        Map props = ((ProtectGroup)src.getProtectGroups().iterator().next()).getProps();
        String kubeProtectionPlanName = (String)props.get("kube_protection_plan");
        dst.setProtectionPlanName(kubeProtectionPlanName);
        return dst;
    }

    public static void createRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType()) || PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType())) {
            LOGGER.info((Object)"Start creating recovery plan of replication types");
            String[] deviceSnArr = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)recoveryPlan);
            String disasterSn = deviceSnArr[1];
            KubeRecoveryPlanPluginUtil.getKubeHandler().createRecoveryPlan(disasterSn, KubeRecoveryPlanPluginUtil.convertRecoveryPlan(recoveryPlan, KubeEnumDefine.RoleType.RECOVERY.getValue()));
            String[] sites = RecoveryPlanUtil.getDeviceSiteFromRecovery((RecoveryPlan)recoveryPlan);
            recoveryPlan.getGlobalSettings().put("PRODUCT_SITE_ID", sites[0]);
            recoveryPlan.getGlobalSettings().put("DISASTER_SITE_ID", sites[1]);
        }
        KubeRecoveryPlanPluginUtil.updateGlobalSettings(recoveryPlan);
    }

    private static void updateGlobalSettings(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (!VerifyUtil.isEmpty((Map)globalSettings)) {
            HashMap<String, String> newGlobalSettings = new HashMap<String, String>();
            for (Map.Entry entry : globalSettings.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (VerifyUtil.isEmpty((String)val)) continue;
                newGlobalSettings.put(key, val);
            }
            recoveryPlan.setGlobalSettings(newGlobalSettings);
        }
    }

    public static void modifyRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType())) {
            LOGGER.info((Object)"Start modifying recovery plan of copy model");
            String[] deviceSnArr = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)recoveryPlan);
            String productSn = deviceSnArr[0];
            String disasterSn = deviceSnArr[1];
            KubeRecoveryPlanPluginUtil.checkCdrRecoveryPlanExist(disasterSn, recoveryPlan);
            if (KubeRecoveryPlanPluginUtil.getKubeHandler().getKubeRecoveryPlan(productSn, KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(recoveryPlan)).isPresent()) {
                KubeRecoveryPlanPluginUtil.getKubeHandler().modifyRecoveryPlan(productSn, KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(recoveryPlan), (String)recoveryPlan.getGlobalSettings().get("postHook"));
            }
            KubeRecoveryPlanPluginUtil.getKubeHandler().modifyRecoveryPlan(disasterSn, KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(recoveryPlan), (String)recoveryPlan.getGlobalSettings().get("postHook"));
        }
        KubeRecoveryPlanPluginUtil.updateGlobalSettings(recoveryPlan);
    }

    public static String getCdrRecoveryPlanName(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String cdrRecoveryName = (String)globalSettings.get("cdrRecoveryName");
        if (VerifyUtil.isEmpty((String)cdrRecoveryName)) {
            cdrRecoveryName = KubeResourceNameGenerator.generate();
            globalSettings.put("cdrRecoveryName", cdrRecoveryName);
        }
        return cdrRecoveryName;
    }

    public static void deleteRecoveryPlan(RecoveryPlan recoveryPlan) {
        String[] deviceSnArr = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)recoveryPlan);
        String productSn = deviceSnArr[0];
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType()) || PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType())) {
            LOGGER.info((Object)"Start deleting recovery plan of copy model");
            if (!VerifyUtil.isEmpty((String)recoveryPlan.getProtectGroup().getProperty("isProductionRecoveryPlanExist"))) {
                KubeRecoveryUtils.checkCdrStatus(productSn, recoveryPlan.getProtectGroup());
                KubeRecoveryPlanPluginUtil.getKubeHandler().checkClusterStatus(productSn);
                KubeRecoveryPlanPluginUtil.getKubeHandler().deleteRecoveryPlan(productSn, KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(recoveryPlan));
            }
            String disasterSn = deviceSnArr[1];
            KubeRecoveryUtils.checkCdrStatus(disasterSn, recoveryPlan.getProtectGroup());
            KubeRecoveryPlanPluginUtil.getKubeHandler().checkClusterStatus(disasterSn);
            KubeRecoveryPlanPluginUtil.getKubeHandler().deleteRecoveryPlan(disasterSn, KubeRecoveryPlanPluginUtil.getCdrRecoveryPlanName(recoveryPlan));
        }
        if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType())) {
            KubeRecoveryPlanPluginUtil.getKubeHandler().checkClusterStatus(productSn);
        }
        KubeRecoveryPlanPluginUtil.deleteRecoveryProcessor(recoveryPlan.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteRecoveryProcessor(String planId) {
        LOGGER.warn((Object)"Start delete recovery processor before delete recovery plan manually,planId: %s", new Object[]{planId});
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            String sql = "delete from ti_recoveryprocessor where planid=:planid";
            NativeQuery query = session.createSQLQuery(sql);
            query.setString("planid", planId);
            query.executeUpdate();
            session.getTransaction().commit();
            LOGGER.warn((Object)"Delete recovery processor before delete recovery plan manually succeed, planId: %s", new Object[]{planId});
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"Delete recovery processor before delete recovery plan manually failed, planId: %s", new Object[]{planId});
                DBOperationUtil.rollbackSession((Session)session);
                ExceptionUtil.rethrowException((Throwable)e, (String)("Deleting recovery plan processors failed. planId:" + planId), (long)1073948688L, null, (Log)LOGGER);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }
}

