/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.listener.KubeJobListenerExecutor;
import com.huawei.ism.drm.kube.model.KubeJobListenerExecuteParam;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryJob;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobOperation;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobType;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseKubeRecoveryEventProcessor
extends BaseKubeRecoveryProcessor {
    protected static final String RECOVERY_JOB_STAGE_RESOURCES = "Resources";
    protected static final String RECOVERY_JOB_STAGE_VOLUMES = "Volumes";
    private static final long serialVersionUID = 9217008430076106539L;
    private static final Log LOGGER = LogFactory.getInstance(BaseKubeRecoveryEventProcessor.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss-ms");
    private static final long MODIFY_RECOVERY_JOB_INITIAL_DELAY = 2L;

    protected boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        return false;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected KubeRecoveryJobType getJobType() {
        return KubeRecoveryJobType.NONE;
    }

    protected KubeJobType getJobSubType() {
        return KubeJobType.NONE;
    }

    protected KubeRecoveryJobOperation getCurrentJobOperation() {
        return KubeRecoveryJobOperation.NONE;
    }

    protected String getStage() {
        return "";
    }

    protected abstract String getStartKeyword();

    protected abstract String getEndKeyword();

    protected KubeRecoveryJob createRecoveryJob() {
        KubeRecoveryJob kubeRecoveryJob = new KubeRecoveryJob();
        RecoveryPlan recoveryPlan = this.getRecoveryPlan();
        kubeRecoveryJob.setName(this.getJobName());
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String cdrRecoveryName = (String)globalSettings.get("cdrRecoveryName");
        kubeRecoveryJob.setRecoveryPlanName(cdrRecoveryName);
        this.checkJobType();
        kubeRecoveryJob.setType(this.getJobType().getValue());
        this.checkJobOperation();
        kubeRecoveryJob.setOperation(this.getCurrentJobOperation().getValue());
        return BaseKubeRecoveryEventProcessor.getKubeHandler().createRecoveryJob(this.getDevSn(), kubeRecoveryJob);
    }

    protected void modifyRecoveryJob() {
        this.modifyRecoveryJob(null);
    }

    protected void modifyRecoveryJob(String operation) {
        CommonUtil.sleep((long)2L, (TimeUnit)TimeUnit.SECONDS);
        BaseKubeRecoveryEventProcessor.getKubeHandler().modifyRecoveryJob(this.getDevSn(), this.getJobName(), StringUtils.isEmpty((CharSequence)operation) ? this.getCurrentJobOperation().getValue() : operation);
    }

    protected void createReProtectionJob(List<String> operations) {
        Map globalSettings = this.getRecoveryPlan().getGlobalSettings();
        String cdrRecoveryName = (String)globalSettings.get("cdrRecoveryName");
        BaseKubeRecoveryEventProcessor.getKubeHandler().createReprotectionJob(this.getDevSn(), cdrRecoveryName, this.getJobName(), operations);
    }

    protected String getJobName() {
        StringBuilder jobNameKeyBuilder = new StringBuilder();
        if (this.isProduct()) {
            jobNameKeyBuilder.append("masterJobName");
        } else {
            jobNameKeyBuilder.append("slaveJobName");
        }
        jobNameKeyBuilder.append("-").append(this.getJobSubType());
        String jobNameKey = jobNameKeyBuilder.toString();
        Object jobNameObj = this.getContextRef().getAttribute(jobNameKey);
        if (VerifyUtil.isEmpty((Object)jobNameObj)) {
            String jobName = KubeResourceNameGenerator.generate();
            this.getContextRef().setAttribute(jobNameKey, (Object)jobName);
            return jobName;
        }
        if (!(jobNameObj instanceof String)) {
            throw new LegoCheckedException(0x200909L);
        }
        return (String)jobNameObj;
    }

    protected boolean listenEvent(KubeJobListenerExecuteParam param) {
        String errorMessage;
        this.checkJobSubType();
        Date startTime = new Date();
        String startTimeStr = DateFormatUtil.format((DateFormat)DATE_FORMAT, (Date)startTime);
        LOGGER.info((Object)"Execute kube job [ %s ] with operation [ %s ] start.Start at [ %s ]", new Object[]{this.getJobName(), this.getCurrentJobOperation(), startTimeStr});
        final ConcurrentHashMap extendAttr = new ConcurrentHashMap();
        final AtomicBoolean jobExecResult = new AtomicBoolean(true);
        final CopyOnWriteArrayList errorMessages = new CopyOnWriteArrayList();
        KubeJobListenerExecuteParam listenParam = param == null ? this.buildListenParam() : param;
        KubeJobListenerExecutor listener = KubeJobListenerExecutor.getInstance();
        listener.startListen(listenParam, new KubeJobListenerExecutor.ListenCallback(){

            @Override
            public void success(String devSn, String jobName, Map<String, Object> extend) {
                LOGGER.info((Object)"Listen CDR event [ %s ] success.jobName: %s", new Object[]{BaseKubeRecoveryEventProcessor.this.getCurrentJobOperation().getValue(), jobName});
                jobExecResult.set(true);
                if (!VerifyUtil.isEmpty(extend)) {
                    extendAttr.putAll(extend);
                }
            }

            @Override
            public void error(String jobName, String message, String reason) {
                LOGGER.error((Object)"Listen CDR event [ %s ] error.jobName: %s, reason: %s, message: %s", new Object[]{BaseKubeRecoveryEventProcessor.this.getCurrentJobOperation().getValue(), jobName, reason, message});
                jobExecResult.set(false);
                errorMessages.add(message);
            }

            @Override
            public void timeout(String jobName, long startTime, long endTime) {
                LOGGER.error((Object)"Listen CDR event [ %s ] timeout.jobName: %s, lasted time: %s ms", new Object[]{BaseKubeRecoveryEventProcessor.this.getCurrentJobOperation().getValue(), jobName, endTime - startTime});
                jobExecResult.set(false);
            }
        });
        if (!VerifyUtil.isEmpty(extendAttr)) {
            this.setLastUpdateTimeStamp(extendAttr.get("lastUpdateTimestamp"));
        }
        Date endTime = new Date();
        String endTimeStr = DateFormatUtil.format((DateFormat)DATE_FORMAT, (Date)endTime);
        LOGGER.info((Object)"Execute kube job [ %s ] with operation [ %s ] complete.Start at [ %s ],end at [ %s ], lasted [ %s ] ms", new Object[]{this.getJobName(), this.getCurrentJobOperation(), startTimeStr, endTimeStr, endTime.getTime() - startTime.getTime()});
        String string = errorMessage = errorMessages.size() > 0 ? (String)errorMessages.get(0) : "";
        if (jobExecResult.get()) {
            return this.success();
        }
        return this.failure(new LegoCheckedException(1073947753L, new String[]{errorMessage}));
    }

    protected boolean listenEvent() {
        return this.listenEvent(null);
    }

    private KubeJobListenerExecuteParam buildListenParam() {
        String currentStage;
        KubeJobListenerExecuteParam param = new KubeJobListenerExecuteParam();
        param.setDevSn(this.getDevSn());
        param.setJobType(this.getJobSubType());
        param.setJobName(this.getJobName());
        param.setStartKeyword(this.getStartKeyword());
        param.setEndKeyword(this.getEndKeyword());
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        String lastUpdateTimeStamp = this.getLastUpdateTimeStamp();
        if (!VerifyUtil.isEmpty((String)lastUpdateTimeStamp)) {
            extendParams.put("lastUpdateTimestamp", lastUpdateTimeStamp);
        }
        if (!VerifyUtil.isEmpty((String)(currentStage = this.getStage()))) {
            extendParams.put("stage", this.getStage());
        }
        param.setExtend(extendParams);
        return param;
    }

    protected String getLastUpdateTimeStamp() {
        String lastUpdateTimeStamp = null;
        Object attribute = this.isProduct() ? this.getContextRef().getAttribute("lastUpdateTimestamp-production") : this.getContextRef().getAttribute("lastUpdateTimestamp-disaster");
        if (attribute instanceof String) {
            lastUpdateTimeStamp = (String)attribute;
        }
        return lastUpdateTimeStamp;
    }

    private void setLastUpdateTimeStamp(Object timestamp) {
        if (this.isProduct()) {
            this.getContextRef().setAttribute("lastUpdateTimestamp-production", timestamp);
        } else {
            this.getContextRef().setAttribute("lastUpdateTimestamp-disaster", timestamp);
        }
    }

    private void checkJobType() {
        KubeRecoveryJobType jobType = this.getJobType();
        if (jobType == null || KubeRecoveryJobType.NONE.equals((Object)jobType)) {
            LOGGER.error((Object)"Kube recovery job type is invalid, default type [ None ] or empty is not allowed to create recovery job");
            throw new LegoCheckedException(0x300001L);
        }
    }

    private void checkJobSubType() {
        KubeJobType jobType = this.getJobSubType();
        if (jobType == null || KubeJobType.NONE.equals((Object)jobType)) {
            LOGGER.error((Object)"Kube recovery job sub type is invalid, default type [ None ] or empty is not allowed to monitor job event");
            throw new LegoCheckedException(0x300001L);
        }
    }

    private void checkJobOperation() {
        KubeRecoveryJobOperation currentJobOperation = this.getCurrentJobOperation();
        if (currentJobOperation == null || KubeRecoveryJobOperation.NONE.equals((Object)currentJobOperation)) {
            LOGGER.error((Object)"Kube recovery job operation is invalid, default operation [ None ] or empty is not allowed to create recovery job");
            throw new LegoCheckedException(0x300001L);
        }
    }
}

