/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.kube.recovery.model.KubeRecoveryExecuteRecord;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryPlanUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.ResourceNotFoundException;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public abstract class BaseKubeRecoveryProcessor
extends BaseRecoveryProcessor {
    protected static final int SN_INDEX_PRODUCTION = 0;
    protected static final int SN_INDEX_DISASTER = 1;
    protected static final String PROCESSOR_NAME_SUFFIX_SOURCE = ".source";
    protected static final String PROCESSOR_NAME_SUFFIX_TARGET = ".target";
    protected static final String DISABLE_RESOURCE_RESULT = "disable_resource_result";
    protected static final int WAIT_TIME_BEFORE_RE_PROTECT = 5;
    private static final long serialVersionUID = -5986309845290871516L;
    private static final Log LOGGER = LogFactory.getInstance(BaseKubeRecoveryProcessor.class);
    private static final String NULL_STRING_VALUE = "null";

    protected static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    protected boolean isProduct() {
        return false;
    }

    protected RecoveryPlan getRecoveryPlan() {
        String planId = this.getContextRef().getRecoveryPlan().getUuid();
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            LOGGER.error((Object)"Execute recovery plan failed,cause target recovery plan of id [%s] is not exist.", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        return recoveryPlan;
    }

    protected String getDevSn() {
        String[] deviceSn = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)this.getRecoveryPlan());
        return this.isProduct() ? deviceSn[0] : deviceSn[1];
    }

    protected String getDevSn(int index) {
        if (index != 0 && index != 1) {
            throw new LegoCheckedException(1073947393L);
        }
        String[] deviceSn = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)this.getRecoveryPlan());
        return deviceSn[index];
    }

    protected void refreshResourceSet(String kubeSn) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan();
        int policyTemplate = RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType();
        if (policyTemplate == 54) {
            ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
            Set protectObjects = protectGroup.getPolist();
            String resourceSetName = ((ProtectObject)protectObjects.iterator().next()).getName();
            LOGGER.info((Object)"Start to refresh resource set (%s) of sn(%s) after executing recovery plan", new Object[]{resourceSetName, kubeSn});
            try {
                KubeRefreshResourceUtils.refreshResourceSet(kubeSn, resourceSetName);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Refresh resource set (%s) of sn(%s) after executing recovery plan failed", (Throwable)e);
            }
        }
    }

    protected boolean checkReprotectReentrantable(RecoveryPlan recoveryPlan) {
        return !this.isReentrantable() && this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() && VerifyUtil.isEmpty((Collection)this.getChildProc());
    }

    protected boolean checkIfRefractSucceed() {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan();
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        return String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes);
    }

    protected String getGlobalSetting(String key) {
        String result = null;
        String settingValue = (String)this.getRecoveryPlan().getGlobalSettings().get(key);
        if (StringUtils.equals((CharSequence)settingValue, (CharSequence)NULL_STRING_VALUE)) {
            return result;
        }
        result = settingValue;
        return result;
    }

    protected int getPoType() {
        return RecoveryPlanUtil.getPoTypeFromRecovery((RecoveryPlan)this.getRecoveryPlan());
    }

    protected String getCdrProtectPlanName() {
        ProtectGroup protectGroup = RecoveryPlanUtil.getProtectGroupFromRecovery((RecoveryPlan)this.getRecoveryPlan());
        Map props = protectGroup.getProps();
        String kubeProtectPlanName = (String)props.get("kube_protection_plan");
        if (VerifyUtil.isEmpty((String)kubeProtectPlanName)) {
            LOGGER.error((Object)"Get protection plan name failed");
            throw new LegoCheckedException(1073947393L);
        }
        return kubeProtectPlanName;
    }

    protected String getHyperMetroDomainType(RecoveryPlan recoveryPlan) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String domainType = protectGroup.getProperty("domainType");
        if (StringUtils.isEmpty((CharSequence)domainType)) {
            LOGGER.error((Object)"Could not find domainType from the prop of ProtectGroup ( %s )", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return domainType;
    }

    protected String createProcNameSuffix() {
        return this.isProduct() ? PROCESSOR_NAME_SUFFIX_SOURCE : PROCESSOR_NAME_SUFFIX_TARGET;
    }

    protected boolean exceptionCaught(Throwable e) {
        if (super.exceptionCaught(e)) {
            return true;
        }
        if (e instanceof ResourceNotFoundException) {
            this.updateProcessDetail("lego.err.201", new String[0]);
            return true;
        }
        if (e instanceof WebSocketHandshakeException) {
            WebSocketHandshakeException exception = (WebSocketHandshakeException)e;
            String host = exception.getResponse().request().uri().getHost();
            this.updateProcessDetail("lego.err.1073947398", new String[]{host});
            return true;
        }
        if (e instanceof KubernetesClientTimeoutException) {
            this.updateProcessDetail("lego.err.1073947401", new String[0]);
            return true;
        }
        if (e instanceof KubernetesClientException) {
            this.updateProcessDetail("lego.err.1073947407", new String[0]);
            return true;
        }
        return false;
    }

    protected boolean checkOperationAlreadySucceed(String operation) {
        KubeRecoveryExecuteRecord record = (KubeRecoveryExecuteRecord)this.getContextRef().getAttribute("executeRecord", KubeRecoveryExecuteRecord.class);
        Object operationValue = record.parseRecord().get(operation);
        return !VerifyUtil.isEmpty(operationValue) && Boolean.TRUE.equals(operationValue);
    }

    protected void updateExecuteRecord(Object operation, Object value) {
        DetachedCriteria criteria = DetachedCriteria.forClass(KubeRecoveryExecuteRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)this.getPlanId()));
        criteria.add((Criterion)Restrictions.eq((String)"procType", (Object)this.getProcType()));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)objects)) {
            return;
        }
        Object recordObj = CommonUtil.getFirstElement((Collection)objects);
        if (!(recordObj instanceof KubeRecoveryExecuteRecord)) {
            return;
        }
        KubeRecoveryExecuteRecord record = (KubeRecoveryExecuteRecord)recordObj;
        record.updateOperation(operation, value);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)record);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BaseKubeRecoveryProcessor)) {
            return false;
        }
        BaseKubeRecoveryProcessor that = (BaseKubeRecoveryProcessor)((Object)object);
        return Objects.equals(this.hashData(), that.hashData());
    }

    protected List<Object> hashData() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(((Object)((Object)this)).getClass());
        data.add(this.getPlanId());
        data.add(this.getParentProcId());
        return data;
    }

    public int hashCode() {
        return this.hashData().hashCode();
    }
}

