/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.common;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.recovery.model.KubeRecoveryExecuteRecord;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.service.KubeHyperMetroProtectGroupRefreshWatcher;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class KubeRecoveryPrepareProcessor
extends BaseKubeRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryPrepareProcessor.class);

    protected boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        this.checkProductionCluster();
        this.checkDisasterCluster();
        this.checkProductionProtectionPlanStatus();
        this.checkDisasterProtectionPlanStatus();
        this.closeHyperMetroWatch();
        this.updateRecoveryContext();
        return this.success();
    }

    private void updateRecoveryContext() {
        DetachedCriteria criteria = DetachedCriteria.forClass(KubeRecoveryExecuteRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)this.getPlanId()));
        criteria.add((Criterion)Restrictions.eq((String)"procType", (Object)this.getProcType()));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)objects)) {
            KubeRecoveryExecuteRecord record = new KubeRecoveryExecuteRecord();
            record.setPlanId(this.getPlanId());
            record.setProcType(this.getProcType());
            record.setRecord("{}");
            CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)record);
            this.getContextRef().setAttribute("executeRecord", (Object)record);
            return;
        }
        Object recordObj = CommonUtil.getFirstElement((Collection)objects);
        this.getContextRef().setAttribute("executeRecord", recordObj);
    }

    private void closeHyperMetroWatch() {
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)executeType)) {
            KubeHyperMetroProtectGroupRefreshWatcher hyperMetroWatcher = (KubeHyperMetroProtectGroupRefreshWatcher)ServiceLocator.getInstance().getService(KubeHyperMetroProtectGroupRefreshWatcher.class);
            ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
            hyperMetroWatcher.deregister(protectGroup.getUuid());
        }
    }

    protected void checkProductionCluster() {
        KubeRecoveryPrepareProcessor.getKubeHandler().checkClusterStatus(this.getDevSn(0));
    }

    protected void checkDisasterCluster() {
        KubeRecoveryPrepareProcessor.getKubeHandler().checkClusterStatus(this.getDevSn(1));
    }

    protected void checkProductionProtectionPlanStatus() {
        this.checkProtectionPlan(this.getDevSn(0));
    }

    protected void checkDisasterProtectionPlanStatus() {
        this.checkProtectionPlan(this.getDevSn(1));
    }

    private void checkProtectionPlan(String kubeSn) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan();
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String protectionPlanName = protectGroup.getProperty("kube_protection_plan");
        if (VerifyUtil.isEmpty((String)protectionPlanName)) {
            LOGGER.error((Object)"Prepare for executing recovery plan failed, could not find protection plan name from props of pg (%s).", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        Optional optional = KubeRecoveryPrepareProcessor.getKubeHandler().getProtectionPlan(kubeSn, protectionPlanName);
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Prepare for executing recovery plan failed, target protection plan (%s) is not exist.", new Object[]{protectionPlanName});
            throw new LegoCheckedException(2117645L);
        }
        KubeProtectionPlan protectionPlan = (KubeProtectionPlan)optional.get();
        KubeEnumDefine.CDRProtectGroupStatus status = protectionPlan.getStatus();
        if (!KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)status)) {
            DrmEnumDefine.RecoveryPlanExecuteTypeE executeType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
            if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)executeType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)executeType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.equals((Object)executeType)) && KubeEnumDefine.CDRProtectGroupStatus.DISABLE.equals((Object)status)) {
                return;
            }
            throw new LegoCheckedException(1073947751L, new String[]{protectionPlanName, protectionPlan.getStatus().getValue()});
        }
    }
}

