/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.migrate.disable;

import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractKubeRecoveryDisableResourceSubProcessor
extends BaseKubeRecoveryProcessor {
    protected static final String NO_EXECUTE = "NoExecute";
    protected static final String NO_SCHEDULE = "NoSchedule";
    protected static final String EQUAL = "Equal";
    private static final Log LOGGER = LogFactory.getInstance(AbstractKubeRecoveryDisableResourceSubProcessor.class);
    private static final String MONITOR_RESOURCE_CONTROLLER_DURATION_KEY = "monitor.kube.resource.controller.duration";
    private static final int MONITOR_RESOURCE_CONTROLLER_DURATION = (int)LegoBaseConfig.getInstance().getNumber("monitor.kube.resource.controller.duration", 5L);
    private static final String MONITOR_RESOURCE_CONTROLLER_TIMEOUT_KEY = "monitor.kube.resource.controller.timeout";
    private static final int MONITOR_RESOURCE_CONTROLLER_TIMEOUT = (int)LegoBaseConfig.getInstance().getNumber("monitor.kube.resource.controller.timeout", 30L);
    private static final List<String> KUBE_CONTROLLER_KINDS = Collections.unmodifiableList(Arrays.asList(Pod.class.getSimpleName(), ReplicaSet.class.getSimpleName(), DaemonSet.class.getSimpleName(), StatefulSet.class.getSimpleName()));
    private String resourceName;
    private String resourceNamespace;
    private String resourceKind;

    @Override
    protected boolean isProduct() {
        return true;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.resourceNamespace, this.resourceName});
        return this.handle(context);
    }

    protected void checkAndWaitSubResources() {
        LOGGER.info((Object)"Start check if resource controller (Kind: %s, name: %s, namespace: %s)  has terminated", new Object[]{this.resourceName, this.resourceKind, this.resourceNamespace});
        ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
        ProtectObject protectObject = (ProtectObject)CommonUtil.getFirstElement((Collection)protectGroup.getPolist());
        if (protectObject == null) {
            LOGGER.error((Object)"Can not find any protect object in protect group %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        String kubeSn = protectGroup.getPoProviderSN();
        long startTime = System.currentTimeMillis();
        while (true) {
            boolean isTerminated;
            if (isTerminated = AbstractKubeRecoveryDisableResourceSubProcessor.getKubeHandler().checkResourceControllerTerminated(kubeSn, this.resourceKind, this.resourceName, this.resourceNamespace)) {
                LOGGER.info((Object)"Resource controller (Kind: %s, name: %s, namespace: %s) has terminated", new Object[]{this.resourceKind, this.resourceName, this.resourceNamespace});
                break;
            }
            if (System.currentTimeMillis() - startTime > TimeUnit.MINUTES.toMillis(MONITOR_RESOURCE_CONTROLLER_TIMEOUT)) {
                LOGGER.info((Object)"Resource controller (Kind: %s, name: %s, namespace: %s) has not terminated yet after 10 minutes", new Object[]{this.resourceKind, this.resourceName, this.resourceNamespace});
                break;
            }
            CommonUtil.sleep((long)MONITOR_RESOURCE_CONTROLLER_DURATION, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected abstract boolean handle(RecoveryProcessorContext var1);

    @Override
    protected List<Object> hashData() {
        List<Object> data = super.hashData();
        data.add(this.resourceNamespace);
        data.add(this.resourceName);
        return data;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNamespace() {
        return this.resourceNamespace;
    }

    public String getResourceKind() {
        return this.resourceKind;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setResourceNamespace(String resourceNamespace) {
        this.resourceNamespace = resourceNamespace;
    }

    public void setResourceKind(String resourceKind) {
        this.resourceKind = resourceKind;
    }
}

