/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.migrate.disable;

import com.huawei.ism.drm.kube.recovery.process.migrate.disable.AbstractKubeRecoveryDisableResourceSubProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class KubeRecoveryDisablePodSubProcessor
extends AbstractKubeRecoveryDisableResourceSubProcessor {
    @Override
    protected boolean handle(RecoveryProcessorContext context) {
        IKubeHandler kubeHandler = KubeRecoveryDisablePodSubProcessor.getKubeHandler();
        String kubeSn = this.getDevSn();
        kubeHandler.addPodImagePrefix(kubeSn, this.getResourceNamespace(), this.getResourceName(), ":");
        long limit = LegoBaseConfig.getInstance().getNumberWithMaxValue("migrate.disable.k8s.pod#status.wait.limit", 60L, 360L);
        AtomicInteger counter = new AtomicInteger();
        while ((long)counter.get() < limit) {
            boolean isDisabled;
            if (counter.getAndIncrement() > 0) {
                CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (!(isDisabled = kubeHandler.checkAllContainerOfPodDisabled(kubeSn, this.getResourceNamespace(), this.getResourceName()))) continue;
            context.setAttribute("disable_resource_result", (Object)true);
            return this.success();
        }
        return this.failure("ism.drm.recovery.k8s.migrate.pod.disable.failed", new String[]{this.getResourceNamespace(), this.getResourceName()});
    }
}

