/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.migrate.disable;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.disable.AbstractKubeRecoveryDisableResourceSubProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.disable.KubeRecoveryDisableDaemonSetSubProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.disable.KubeRecoveryDisableDeploymentSubProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.disable.KubeRecoveryDisablePodSubProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.disable.KubeRecoveryDisableReplicaSetSubProcessor;
import com.huawei.ism.drm.kube.recovery.process.migrate.disable.KubeRecoveryDisableStatefulSetSubProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeResource;
import com.huawei.ism.drm.kube.utils.KubeRecoveryUtils;
import com.huawei.ism.drm.kube.utils.KubeResourceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class KubeRecoveryDisableProductResourceProcessor
extends BaseKubeRecoveryProcessor {
    protected boolean execute(RecoveryProcessorContext context) {
        Map<String, Function<KubeResource, RecoveryProcessor>> factories = this.buildSubProcessorFactories();
        ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
        String kubeSn = protectGroup.getPoProviderSN();
        ArrayList<RecoveryProcessor> processors = new ArrayList<RecoveryProcessor>();
        IKubeHandler kubeHandler = KubeRecoveryDisableProductResourceProcessor.getKubeHandler();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            String detailName = protectObject.getProperty("resourceDetailName");
            List resources = kubeHandler.getDetailResourceList(kubeSn, detailName);
            processors.addAll(KubeRecoveryDisableProductResourceProcessor.createResourceDisableProcessors(factories, resources));
        }
        this.saveSubProcessors(processors);
        boolean invoke = this.invoke(context);
        if (Boolean.TRUE.equals(context.getAttribute("disable_resource_result"))) {
            KubeRecoveryUtils.invalidProtectGroup(this.getRecoveryPlan().getProtectGroup());
        }
        return invoke;
    }

    private Map<String, Function<KubeResource, RecoveryProcessor>> buildSubProcessorFactories() {
        HashMap<String, Function<KubeResource, RecoveryProcessor>> factories = new HashMap<String, Function<KubeResource, RecoveryProcessor>>();
        factories.put(Pod.class.getSimpleName(), this::createDisablePodProcessor);
        factories.put(Deployment.class.getSimpleName(), this::createModifyReplicaOfDeploymentProcessor);
        factories.put(ReplicaSet.class.getSimpleName(), this::createModifyReplicaOfReplicaSetProcessor);
        factories.put(StatefulSet.class.getSimpleName(), this::createModifyReplicaOfStatefulSetProcessor);
        factories.put(DaemonSet.class.getSimpleName(), this::createModifyNodeSelectorOfDaemonSetProcessor);
        return factories;
    }

    private static List<RecoveryProcessor> createResourceDisableProcessors(Map<String, Function<KubeResource, RecoveryProcessor>> factories, List<KubeResource> resources) {
        ArrayList<RecoveryProcessor> processors = new ArrayList<RecoveryProcessor>();
        KubeResourceUtil.sort(resources);
        for (KubeResource resource : resources) {
            Function<KubeResource, RecoveryProcessor> factory = factories.get(resource.getKind());
            if (factory == null) continue;
            processors.add(factory.apply(resource));
        }
        return processors;
    }

    private RecoveryProcessor createDisablePodProcessor(KubeResource resource) {
        return this.createSubProcessor(KubeRecoveryDisablePodSubProcessor::new, this.init(resource));
    }

    private RecoveryProcessor createModifyReplicaOfDeploymentProcessor(KubeResource resource) {
        return this.createSubProcessor(KubeRecoveryDisableDeploymentSubProcessor::new, this.init(resource));
    }

    private RecoveryProcessor createModifyReplicaOfReplicaSetProcessor(KubeResource resource) {
        return this.createSubProcessor(KubeRecoveryDisableReplicaSetSubProcessor::new, this.init(resource));
    }

    private RecoveryProcessor createModifyReplicaOfStatefulSetProcessor(KubeResource resource) {
        return this.createSubProcessor(KubeRecoveryDisableStatefulSetSubProcessor::new, this.init(resource));
    }

    private RecoveryProcessor createModifyNodeSelectorOfDaemonSetProcessor(KubeResource resource) {
        return this.createSubProcessor(KubeRecoveryDisableDaemonSetSubProcessor::new, this.init(resource));
    }

    private <T extends AbstractKubeRecoveryDisableResourceSubProcessor> Consumer<T> init(KubeResource resource) {
        return processor -> {
            processor.setResourceName(resource.getName());
            processor.setResourceKind(resource.getKind());
            processor.setResourceNamespace(resource.getNamespace());
        };
    }
}

