/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect.hypermetro;

import com.huawei.ism.drm.kube.model.KubeJobListenerExecuteParam;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryEventProcessor;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeEventKeywords;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeReProtectionJobOperation;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class KubeHyperMetroRoleReverseProcessor
extends BaseKubeRecoveryEventProcessor {
    private static final long serialVersionUID = -8122183672009420499L;
    private static final Log LOGGER = LogFactory.getInstance(KubeHyperMetroRoleReverseProcessor.class);
    private boolean isProduct;

    @Override
    public boolean isProduct() {
        return this.isProduct;
    }

    public void setProduct(boolean isProduct) {
        this.isProduct = isProduct;
    }

    @Override
    protected KubeJobType getJobSubType() {
        return KubeJobType.RE_PROTECTION_JOB;
    }

    @Override
    protected String getStartKeyword() {
        return KubeEventKeywords.HyperMetroVolumeReProtectionJob.REVERSE_ROLE_START.getValue();
    }

    @Override
    protected String getEndKeyword() {
        return KubeEventKeywords.HyperMetroVolumeReProtectionJob.REVERSE_ROLE_END.getValue();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start execute KubeHyperMetroRoleReverseProcessor. Listen re-protection job. DeviceSn: %s, jobType: %s, jobSubType: %s, jobName: %s", new Object[]{this.getDevSn(), this.getJobType().getValue(), this.getJobSubType().getValue(), this.getJobName()});
        if (this.checkOperationAlreadySucceed(KubeReProtectionJobOperation.REVERSE_HYPER_METRO_DOMAIN.getValue() + this.createProcNameSuffix()) && this.checkOperationAlreadySucceed(KubeReProtectionJobOperation.REVERSE_ROLE.getValue() + this.createProcNameSuffix())) {
            return this.success();
        }
        boolean isSwitchHmdSuccess = this.switchHyperMetroDomain(context);
        if (!isSwitchHmdSuccess) {
            return false;
        }
        boolean isExecuteSuccess = this.listenEvent();
        this.updateExecuteRecord(KubeReProtectionJobOperation.REVERSE_ROLE.getValue() + this.createProcNameSuffix(), isExecuteSuccess);
        return isExecuteSuccess;
    }

    private boolean switchHyperMetroDomain(RecoveryProcessorContext context) {
        String domainType = this.getHyperMetroDomainType(this.getRecoveryPlan());
        if (!StringUtils.equals((CharSequence)domainType, (CharSequence)KubeEnumDefine.DomainType.AP_TYPE.getValue())) {
            return this.success();
        }
        CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.createReProtectionJob(Arrays.asList(KubeReProtectionJobOperation.REVERSE_HYPER_METRO_DOMAIN.getValue(), KubeReProtectionJobOperation.REVERSE_ROLE.getValue()));
        KubeJobListenerExecuteParam param = new KubeJobListenerExecuteParam();
        param.setDevSn(this.getDevSn());
        param.setJobType(this.getJobSubType());
        param.setJobName(this.getJobName());
        param.setStartKeyword(KubeEventKeywords.HyperMetroVolumeReProtectionJob.REVERSE_DOMAIN_START.getValue());
        param.setEndKeyword(KubeEventKeywords.HyperMetroVolumeReProtectionJob.REVERSE_DOMAIN_END.getValue());
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("lastUpdateTimestamp", this.getLastUpdateTimeStamp());
        extendParams.put("stage", this.getStage());
        param.setExtend(extendParams);
        boolean isExecuteSuccess = this.listenEvent(param);
        this.updateExecuteRecord(KubeReProtectionJobOperation.REVERSE_HYPER_METRO_DOMAIN.getValue() + this.createProcNameSuffix(), isExecuteSuccess);
        return isExecuteSuccess;
    }

    @Override
    protected List<Object> hashData() {
        List<Object> data = super.hashData();
        data.add(this.isProduct);
        return data;
    }
}

