/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;

@ServiceBoundInfo(methodName="onBind", targetBeanName="siteResourceServiceProxy", properties="resType:ism.drm.deviceType.container.mainType")
public class KubeSiteResourceServiceImpl
implements ISiteResourceService {
    private static final Log LOGGER = LogFactory.getInstance(KubeSiteResourceServiceImpl.class);

    public void isResourceUsed(Long moId) {
        if (moId == null) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject ob = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)moId);
        if (ob == null) {
            LOGGER.error((Object)"Delete kube cluster error as mo is null");
            throw new LegoCheckedException(1073947394L);
        }
        DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId((Long)moId);
        if (VerifyUtil.isEmpty((Object)resource)) {
            LOGGER.info((Object)"The resource is null, return.");
            return;
        }
        this.isKubeUsed(resource.getDeviceSn());
    }

    private void isKubeUsed(String kubeSn) {
        String hql = "from ProtectGroup as pg where poProviderSN = ?";
        List pgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{kubeSn});
        if (!VerifyUtil.isEmpty((Collection)pgs)) {
            LOGGER.error((Object)"The kube resource: %s has been used by protectGroup, failed to delete.", new Object[]{kubeSn});
            throw new LegoCheckedException(1073947755L);
        }
        hql = "from Schedule where targetsn = ?";
        List schedules = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{kubeSn});
        if (!VerifyUtil.isEmpty((Collection)schedules)) {
            LOGGER.error((Object)"The kube resource: %s has been used by protectGroup, failed to delete.", new Object[]{kubeSn});
            throw new LegoCheckedException(1073947755L);
        }
        NetworkEntity kubeNe = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)kubeSn);
        if (kubeNe == null) {
            LOGGER.error((Object)"The kube cluster: %s is not existed.", new Object[]{kubeSn});
            return;
        }
        boolean isUsed = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedHostGroupByRp(kubeSn);
        if (isUsed) {
            LOGGER.error((Object)"The kube cluster: %s has been used by recoveryPlan.Failed to delete.");
            throw new LegoCheckedException(1073947755L);
        }
    }

    public void refreshResouce(Site site) {
        if (site == null) {
            LOGGER.error((Object)"The site is empty.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public int sum(String siteId, Long userId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            return 0;
        }
        List sns = this.getKubeResourceSnBySiteId(siteId);
        if (VerifyUtil.isEmpty(sns)) {
            return 0;
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (site.getSiteType() == 0) {
            sns = SiteResourceManagerUtil.filterDrResourceSN(sns, (Long)userId);
        }
        return sns.size();
    }

    private List<String> getKubeResourceSnBySiteId(String siteId) {
        try {
            List dbResults = CommonDAOLocator.getMoDao().find("select deviceSn from Kubernetes where siteId=?", new Object[]{siteId});
            if (VerifyUtil.isEmpty((Collection)dbResults)) {
                return Collections.emptyList();
            }
            return dbResults.stream().map(String::valueOf).collect(Collectors.toList());
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Failed to get sn: %s.", new Object[]{ex, siteId});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public <T extends ManagedObject> DrResource getDrResourceByMo(T mo) {
        if (!(mo instanceof KubernetesNE)) {
            return null;
        }
        Kubernetes kubernetes = new Kubernetes();
        KubernetesNE ne = (KubernetesNE)mo;
        kubernetes.setDeviceSn(ne.getSn());
        kubernetes.setIpAddress(ne.getLinkIp());
        kubernetes.setName(ne.getName());
        kubernetes.setStatus(String.valueOf(ne.getStatus()));
        kubernetes.setDbId(UUIDGenerator.getUUID());
        return kubernetes;
    }

    public DrResource getDrResourceBySn(String devSN) {
        List kubernetesList = CommonDAOLocator.getBaseDao().find("from Kubernetes where deviceSn=?", new Object[]{devSN});
        if (!VerifyUtil.isEmpty((Collection)kubernetesList)) {
            Optional<DrResource> opt = kubernetesList.stream().filter(obj -> obj instanceof DrResource).map(obj -> (DrResource)obj).findFirst();
            return opt.orElse(null);
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        if (VerifyUtil.isEmpty((Object)siteType)) {
            LOGGER.error((Object)"The input siteType is empty.");
            return Collections.emptyList();
        }
        List kubernetesList = CommonDAOLocator.getBaseDao().find("from Kubernetes where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        if (!VerifyUtil.isEmpty((Collection)kubernetesList)) {
            return kubernetesList.stream().filter(obj -> obj instanceof DrResource).map(obj -> (DrResource)obj).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            LOGGER.error((Object)"The input siteId is empty.");
            return Collections.emptyList();
        }
        List resources = CommonDAOLocator.getBaseDao().find("from Kubernetes where siteId=?", new Object[]{siteId});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            return resources.stream().filter(obj -> obj instanceof DrResource).map(obj -> (DrResource)obj).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

