/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.query.NativeQuery;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PropsUtil {
    private static final Log LOGGER = LogFactory.getInstance(PropsUtil.class);
    private static final String ID_PLACEHOLDER = "ID";
    private static final String PROPNAME_PLACEHOLDER = "PROPNAME";
    private static final String PROPVALUE_PLACEHOLDER = "PROPVALUE";

    public static Map<String, Map<String, String>> queryPropMaps(PropModel propModel, @Nullable Collection<String> ids) {
        if (VerifyUtil.isEmpty((Object)((Object)propModel))) {
            LOGGER.error((Object)"parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List resultList = HibernateUtil.call(session -> {
            String sqlString = VerifyUtil.isEmpty((Collection)ids) ? String.format(Locale.ENGLISH, "select %s, PROPNAME, PROPVALUE from %s", propModel.getIdColumn(), propModel.getTable()) : String.format(Locale.ENGLISH, "select %s, PROPNAME, PROPVALUE from %s where %s in (:ID)", propModel.getIdColumn(), propModel.getTable(), propModel.getIdColumn());
            NativeQuery query = session.createSQLQuery(sqlString);
            if (!VerifyUtil.isEmpty((Collection)ids)) {
                query.setParameterList(ID_PLACEHOLDER, ids);
            }
            return query.list();
        });
        HashMap<String, Map<String, String>> propMaps = new HashMap<String, Map<String, String>>();
        if (VerifyUtil.isEmpty((Collection)resultList)) {
            return propMaps;
        }
        for (Object result : resultList) {
            Object[] values;
            if (!(result instanceof Object[]) || (values = (Object[])result).length < 3) continue;
            String propId = CommUtil.convertToString((Object)values[0]);
            String propName = CommUtil.convertToString((Object)values[1]);
            String propValue = CommUtil.convertToString((Object)values[2]);
            propMaps.computeIfAbsent(propId, key -> new HashMap()).put(propName, propValue);
        }
        return propMaps;
    }

    public static Map<String, String> queryPropMapById(PropModel propModel, @NonNull String id) {
        if (VerifyUtil.isEmpty((Object)((Object)propModel)) || VerifyUtil.isEmpty((String)id)) {
            LOGGER.error((Object)"parameter is empty. propModel=%s, id=%s", new Object[]{propModel, id});
            throw new LegoCheckedException(1073947393L);
        }
        String sqlString = String.format(Locale.ENGLISH, "select PROPNAME, PROPVALUE from %s where %s = :ID", propModel.getTable(), propModel.getIdColumn());
        List resultList = HibernateUtil.call(session -> {
            NativeQuery query = session.createSQLQuery(sqlString);
            query.setParameter(ID_PLACEHOLDER, (Object)id);
            return query.list();
        });
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty((Collection)resultList)) {
            return propMap;
        }
        for (Object result : resultList) {
            Object[] values;
            if (!(result instanceof Object[]) || (values = (Object[])result).length < 2) continue;
            String propName = CommUtil.convertToString((Object)values[0]);
            String propValue = CommUtil.convertToString((Object)values[1]);
            propMap.put(propName, propValue);
        }
        return propMap;
    }

    public static void insertOrUpdateProp(PropModel propModel, String id, String name, String value) {
        if (VerifyUtil.isEmpty((Object)((Object)propModel)) || VerifyUtil.isEmpty((String)id) || VerifyUtil.isEmpty((String)name) || VerifyUtil.isEmpty((String)value)) {
            LOGGER.error((Object)"parameter is empty. propModel=%s,id=%s,name=%s", new Object[]{propModel, id, name});
            throw new LegoCheckedException(1073947393L);
        }
        HibernateUtil.execute(session -> {
            NativeQuery nativeQuery = session.createSQLQuery(String.format("select PROPVALUE from %s where %s =:ID and PROPNAME =:PROPNAME", propModel.getTable(), propModel.getIdColumn()));
            nativeQuery.setParameter(ID_PLACEHOLDER, (Object)id);
            nativeQuery.setParameter(PROPNAME_PLACEHOLDER, (Object)name);
            List valueList = nativeQuery.list();
            if (VerifyUtil.isEmpty((Collection)valueList)) {
                nativeQuery = session.createSQLQuery(String.format("INSERT INTO %s(%s,PROPNAME, PROPVALUE) VALUES (:ID,:PROPNAME,:PROPVALUE)", propModel.getTable(), propModel.getIdColumn()));
                nativeQuery.setParameter(ID_PLACEHOLDER, (Object)id);
                nativeQuery.setParameter(PROPNAME_PLACEHOLDER, (Object)name);
                nativeQuery.setParameter(PROPVALUE_PLACEHOLDER, (Object)value);
                nativeQuery.executeUpdate();
            } else {
                nativeQuery = session.createSQLQuery(String.format("UPDATE %s SET PROPVALUE = :PROPVALUE where %s = :ID and PROPNAME = :PROPNAME", propModel.getTable(), propModel.getIdColumn()));
                nativeQuery.setParameter(ID_PLACEHOLDER, (Object)id);
                nativeQuery.setParameter(PROPNAME_PLACEHOLDER, (Object)name);
                nativeQuery.setParameter(PROPVALUE_PLACEHOLDER, (Object)value);
                nativeQuery.executeUpdate();
            }
        });
    }

    public static void deleteProp(PropModel propModel, String id, String name) {
        if (VerifyUtil.isEmpty((Object)((Object)propModel)) || VerifyUtil.isEmpty((String)id) || VerifyUtil.isEmpty((String)name)) {
            LOGGER.error((Object)"parameter is empty. propModel=%s,id=%s,name=%s", new Object[]{propModel, id, name});
            throw new LegoCheckedException(1073947393L);
        }
        HibernateUtil.execute(session -> {
            NativeQuery nativeQuery = session.createSQLQuery(String.format("DELETE FROM %s WHERE %s = :ID and PROPNAME = :PROPNAME", propModel.getTable(), propModel.getIdColumn()));
            nativeQuery.setParameter(ID_PLACEHOLDER, (Object)id);
            nativeQuery.setParameter(PROPNAME_PLACEHOLDER, (Object)name);
            nativeQuery.executeUpdate();
        });
    }

    public static enum PropModel {
        RECOVERYPLAN("TI_RP_GLOBALSETTINGS", "PLANID"),
        PROTECTGROUP("TI_PROTECTGROUP_PROP", "PGID"),
        PROTECTGROUPREPLICA("TI_PROTECTGROUPREPLICA_PROP", "ID"),
        PROTECTOBJECT("TI_PO_PROP", "POID");

        private final String table;
        private final String idColumn;

        private PropModel(String table, String idColumn) {
            this.table = table;
            this.idColumn = idColumn;
        }

        public String getTable() {
            return this.table;
        }

        public String getIdColumn() {
            return this.idColumn;
        }
    }
}

