/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.service.ICertificateDockingHandler;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.List;

public abstract class CertificateDockingTask
extends AbstractBackTask
implements ICertificateDockingHandler {
    public static final String KEY_REGISTER_MAX_RETRIES = "cert.register.max.retries";
    public static final int MAX_WAIT_INTERVAL = 60000;
    private static final Log logger = LogFactory.getInstance(CertificateDockingTask.class);
    private static final int DEFAULT_MAX_RETRIES_THRESHOLD = 16;
    private static final int DEFAULT_RETRIES = 5;
    private List<CertificateSummary> summaries;
    private int maxRetries;

    public CertificateDockingTask(String taskName, String taskType, List<CertificateSummary> summaries) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)"eReplication", (String)taskName, (String)"System", (String)taskType, (String)"", (String[])new String[0]), true);
        this.summaries = summaries;
        this.maxRetries = this.getMaxRetries(KEY_REGISTER_MAX_RETRIES);
    }

    public List<CertificateSummary> getCertificateSummaries() {
        return this.summaries;
    }

    protected void doWork() {
        logger.info((Object)"max retry number: %s", new Object[]{String.valueOf(this.maxRetries)});
        int retries = 0;
        boolean isNeedRetry = false;
        do {
            long waitTime = Math.min(this.getWaitTimeExp(retries), 60000L);
            if (retries > 0) {
                CommUtil.pauseThread((long)waitTime);
            }
            try {
                isNeedRetry = !this.handle(this.summaries);
            }
            catch (Exception e) {
                isNeedRetry = true;
                if (retries >= 32) continue;
                logger.error((Object)"register failed, try again. error: ", (Throwable)e);
            }
        } while (isNeedRetry && retries++ < this.maxRetries);
        logger.info((Object)"repeat certificate register task %s times.", new Object[]{String.valueOf(retries)});
        if (isNeedRetry && retries > this.maxRetries) {
            logger.error((Object)"register certificate always failed.");
            throw new LegoCheckedException(-1L, "Docking certificate always failed.");
        }
    }

    protected int getMaxRetries(String property) {
        int retries = 5;
        String retriesStr = LegoBaseConfig.getInstance().getKeyValue(property, String.valueOf(16));
        try {
            retries = Integer.parseInt(retriesStr);
            retries = retries < 16 ? retries : 16;
        }
        catch (NumberFormatException e) {
            logger.error((Object)"retriesStr is %s, the register retries format error:%s.", new Object[]{retriesStr, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        logger.info((Object)"max register retries number: %s", new Object[]{String.valueOf(retries)});
        return retries;
    }

    private long getWaitTimeExp(int retryCount) {
        return (long)Math.pow(2.0, Math.max(retryCount, 3)) * 1000L;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

