/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.task;

import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.cert.ServerCertificateValidateJob;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateTaskData;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateTaskStatus;
import com.huawei.ism.drm.cert.sdk.service.ISystemCertificateService;
import com.huawei.ism.drm.cert.task.CertificateOperateTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class CertificateNotifyTask
extends CertificateOperateTask {
    public static final String TASK_NAME = "ism.drm.cert.notify";
    public static final String TASK_TYPE = "cert.notify";
    private static final Log logger = LogFactory.getInstance(CertificateNotifyTask.class);
    private String taskId;
    private int counter = 0;

    public CertificateNotifyTask(ISystemCertificateService systemCertificateService, String certName, String taskId) {
        super("notify", systemCertificateService, BackTaskUtil.buildBackTask((String)certName, (String)TASK_NAME, (String)"System", (String)TASK_TYPE, (String)"", (String[])new String[0]), taskId, true);
        this.taskId = taskId;
    }

    @Override
    protected String getAction() {
        return "update";
    }

    protected void doWork() {
        CertificateUpdateTaskStatus status = this.getSystemCertificateService().queryCertificateUpdateTaskStatus(this.taskId);
        if (status == null) {
            this.notifyCertificateUpdateFailure((Exception)((Object)this.failure("check task status failed for task " + this.taskId)), false);
            return;
        }
        CertificateUpdateTaskData data = status.getData();
        String result = status.getResultCode();
        if ("failed".equals(data.getUpdateStatus())) {
            JSONObject detail = JSONObject.fromObject((Object)data.getDetail());
            long code = NumberUtil.parseLong((Object)detail.getString("code"), (Long)-1L);
            logger.error((Object)"unknown error, no error cause for task %s, error code: %s", new Object[]{this.taskId, code});
            this.notifyCertificateUpdateFailure((Exception)((Object)new LegoCheckedException(code, new String[0], "Task: " + this.taskId + ", Error Code: " + code + ". In the upper right corner of the eReplication page, click 'Background Task' to view the cause of the certificate update failure.")), false);
        } else if ("running".equals(result)) {
            this.notifyCertificateUpdateFailure((Exception)((Object)this.failure("Some sub task(s) is running for task " + this.taskId)), false);
        } else {
            this.notifyCertificateUpdateSucceed(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCertificateUpdateStatus(String resultCode, String errorMsg, boolean quiet) {
        if (this.counter++ > 0) {
            logger.debug((Object)"already notify cert status, not need to notify");
            return;
        }
        try {
            super.notifyCertificateUpdateStatus(resultCode, errorMsg, quiet);
        }
        finally {
            new ServerCertificateValidateJob().validate(this.getSystemCertificateService(), (Object)this.getCertName());
        }
    }
}

