/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractRecoveryManager
extends BaseService {
    protected static final String URL_TEST = "/ws/recoveryplans/{planId}/action/test";
    protected static final String URL_TESTCLEANUP = "/ws/recoveryplans/{planId}/action/testCleanup";
    protected static final String URL_PLANEDMIGRATION = "/ws/recoveryplans/{planId}/action/plannedMigration";
    protected static final String URL_HOTMIGRATION = "/ws/recoveryplans/{planId}/action/hotMigration";
    protected static final String URL_REPROTECT = "/ws/recoveryplans/{planId}/action/reprotect";
    protected static final String URL_ACTION_CONTINUE = "/ws/recoveryplans/{planId}/action/{actionType}/continue";
    protected static final String SEPARATOR = ":";
    private static final Log logger = LogFactory.getInstance(AbstractRecoveryManager.class);
    protected IRecoveryPlanBaseService recoveryPlanService;

    public IRecoveryPlanBaseService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanBaseService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public void startPlanedMotion(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, URL_PLANEDMIGRATION);
    }

    protected abstract void migration(String var1, Map<String, String> var2, User var3, DrmEnumDefine.RecoveryPlanExecuteTypeE var4, String var5);

    public void startHotMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION, URL_HOTMIGRATION);
    }

    IRecoveryProcessBaseProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        return provider;
    }

    protected void dealGlobalSettings(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (globalSettings.containsKey("RECOVERY_EXTEND_ATTRIBUTES")) {
            globalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", "-1");
        }
        globalSettings.remove("REPLICA_ID");
    }

    protected abstract void checkRecoveryPlanExecuting(String var1);

    protected abstract void tryLockRecoveryPlan(String var1);

    protected abstract void unLockRecoveryPlan(String var1);

    protected void checkParameters(String recoveryPlanId, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkParameters(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || recoveryContext == null || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.");
        }
    }

    protected void setSuffixTypeToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("NameSuffixKey")) {
            logger.info((Object)"context is empty.");
            return;
        }
        String suffix = recoveryContext.get("NameSuffixKey");
        logger.info((Object)"name suffix key: %s.", new Object[]{suffix});
        initialContextData.put("NameSuffixKey", suffix);
    }

    protected void prepareSuffixType(String recoveryPlanId, Map<String, String> recoveryContext, String initSuffix) {
        logger.info((Object)"prepare initial suffix.");
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(recoveryPlanId, true, false);
        if (recoveryPlan == null) {
            logger.error((Object)"recovery plan is null, id: %s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        String suffix = initSuffix + "_" + recoveryPlan.getName();
        logger.info((Object)"name suffix in params: %s.", new Object[]{suffix});
        recoveryContext.put("NameSuffixKey", suffix);
    }

    protected RecoveryProcessDefinition getRecoveryProcessDef(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        IRecoveryProcessBaseProvider provider;
        RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(execType);
        if (rpDefinition == null || this.doUpgradeForAutoPlanMotion(recoveryPlan, execType, rpDefinition)) {
            rpDefinition = this.createRecoveryProcessDefinition(recoveryPlan, execType);
        }
        if ((provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan)) == null) {
            throw new LegoCheckedException(1073947393L);
        }
        provider.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, true);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        if (protectGroup == null) {
            logger.error((Object)"The protectGroup does not exist.PlanId:%s.", new Object[]{String.valueOf(recoveryPlan.getPlanId())});
            throw new LegoCheckedException(201L);
        }
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(recoveryPlan, execType);
        }
        return rpDefinition;
    }

    public RecoveryProcessDefinition createRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"recoveryPlanId is %s .", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, execType, protectGroup);
        HashSet<RecoveryProcessDefinition> recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        if (recoveryProcesses == null) {
            recoveryProcesses = new HashSet<RecoveryProcessDefinition>();
            recoveryPlan.setRecoveryProcesses(recoveryProcesses);
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessBaseService rpService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return rpDefinition;
    }

    protected void checkIfProtectObjectExisted(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList protectObjects = new ArrayList();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) continue;
            protectObjects.addAll(protectGroup.getPolist());
        }
        if (protectObjects.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void checkInstanceStatusAndHoldVm(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        MessageEvent event = new MessageEvent();
        HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE> messageMap = new HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE>();
        messageMap.put("message_event_excute_type", type);
        event.setMessageMap(messageMap);
        event.setMessageType(7);
        ArrayList<RecoveryPlan> objectList = new ArrayList<RecoveryPlan>();
        objectList.add(recoveryPlan);
        event.setObjectList(objectList);
        IRecoveryPlanObserverManager observerManager = (IRecoveryPlanObserverManager)ServiceLocator.getInstance().getService(IRecoveryPlanObserverManager.class);
        observerManager.notifyObserverList(event, "before");
    }

    public boolean doUpgradeForAutoPlanMotion(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, RecoveryProcessDefinition rpDefinition) {
        logger.info((Object)"doUpgradeForAutoPlanMotion: recoveryPlan %s, execType %s", new Object[]{recoveryPlan.getName(), execType.getValue()});
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (!Arrays.asList(34, 22, 21).contains(protectGroup.getTemplate().getType())) {
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != execType.getValue()) {
            return false;
        }
        Set set = rpDefinition.getRecoveryProcessors().stream().filter(processor -> processor.getProcName().contains("OpenStackReverseStorageRepDirectionProcessor")).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            logger.info((Object)"no need refactPlanMotionProcessDefinition: %s", new Object[]{recoveryPlan.getName()});
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"%s is PLANED_MOTION_FAILED, need refact definition.", new Object[]{recoveryPlan.getName()});
            this.refactPlanMotionProcessDefinition(recoveryPlan, rpDefinition, protectGroup);
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"recoveryPlan(%s), status(%s), need refact definition.", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanStatus()});
            recoveryPlan.getRecoveryProcesses().remove(rpDefinition);
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
            return true;
        }
        return false;
    }

    private void refactPlanMotionProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, ProtectGroup protectGroup) {
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (provider == null) {
            logger.error((Object)"Can not find suitable provider");
            throw new LegoCheckedException(2117645L);
        }
        RecoveryProcessDefinition reprotectedRpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT, protectGroup);
        List<RecoveryProcessor> reProcessors = RecoveryServiceUtil.sortRecoveryProcessors(reprotectedRpDefinition.getRecoveryProcessors());
        ArrayList<Class<? extends RecoveryProcessor>> procClsList = new ArrayList<Class<? extends RecoveryProcessor>>();
        for (int ix = 3; ix < reProcessors.size(); ++ix) {
            procClsList.add(reProcessors.get(ix).getClass());
        }
        this.refactRecoveryProcessors(recoveryPlan, rpDefinition, procClsList);
    }

    private void refactRecoveryProcessors(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, List<Class<? extends RecoveryProcessor>> procClsList) {
        RecoveryProcessor lastProcessor = RecoveryServiceUtil.getLastRecoveryProcessor(rpDefinition.getRecoveryProcessors());
        if (lastProcessor == null || VerifyUtil.isEmpty(procClsList)) {
            logger.error((Object)"refact processDefinition error. Can not find the last processor .");
            return;
        }
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        logger.info((Object)"recoveryPlan(%s), need delete definition %s.", new Object[]{recoveryPlan.getName(), rpDefinition.getName()});
        Set recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        recoveryProcesses.remove(rpDefinition);
        recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)"Can not find suitable provider");
            throw new LegoCheckedException(2117645L);
        }
        provider.insertRecoveryProcessors(rpDefinition, lastProcessor.getPreviousProcessor().getClass(), procClsList, true, false);
        provider.deleteRecoveryProcessors(rpDefinition, lastProcessor.getProcId(), false);
        for (RecoveryProcessor pro : rpDefinition.getRecoveryProcessors()) {
            pro.setProcessId(rpDefinition.getProcessId());
            pro.setPlanId(recoveryPlan.getPlanId());
            if (!procClsList.contains(pro.getClass())) continue;
            pro.setIsPreset(Boolean.valueOf(true));
            pro.setIsEditable(Boolean.valueOf(false));
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessBaseService rpService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
    }
}

