/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.service.impl.RecoveryResourceBaseServiceImpl;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateRecoveryPlanBackTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(RecoveryResourceBaseServiceImpl.class);
    private static final Map<Integer, List<String>> REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES = new HashMap<Integer, List<String>>();
    private Set<ProtectGroup> protectGroups;
    private String recoveryPlanName;
    private long userId;

    public CreateRecoveryPlanBackTask(long userId, String recoveryPlanName, Set<ProtectGroup> protectGroups) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)recoveryPlanName, (String)"ism.drm.recovery.createrecoveryplan.task.name", (String)"System", (String)"", null), true);
        this.userId = userId;
        this.recoveryPlanName = recoveryPlanName;
        this.protectGroups = protectGroups;
    }

    protected void doWork() {
        if (VerifyUtil.isEmpty(this.protectGroups)) {
            LOG.error((Object)"ProtectGroups is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.constructRecoveryPlanEntity(this.recoveryPlanName);
        recoveryPlan.setProtectGroups(this.protectGroups);
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        Iterator<ProtectGroup> iterator = this.protectGroups.iterator();
        if (!iterator.hasNext()) {
            LOG.error((Object)"ProtectGroup is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = iterator.next();
        ILicenseBaseControl licenseControl = (ILicenseBaseControl)ServiceLocator.getInstance().getService(ILicenseBaseControl.class);
        licenseControl.checkEnablePgCount(protectGroup);
        recoveryPlan.setPlanType(planService.getSuitablePlanType(protectGroup).getValue());
        planService.createRecoveryPlan(this.userId, recoveryPlan);
    }

    private RecoveryPlan constructRecoveryPlanEntity(String planName) {
        RecoveryPlan recoveryPlan = new RecoveryPlan();
        recoveryPlan.setName(planName);
        recoveryPlan.setRecoverySettings(new HashSet());
        Iterator<ProtectGroup> iterator = this.protectGroups.iterator();
        ProtectGroup firstGroup = iterator.next();
        int poType = firstGroup.getPoType();
        List<String> needHandleProps = REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.get(poType);
        if (VerifyUtil.isEmpty(needHandleProps)) {
            recoveryPlan.setGlobalSettings(new HashMap());
        } else {
            Map props = firstGroup.getProps();
            HashMap globalSettings = new HashMap();
            for (Map.Entry entry : props.entrySet()) {
                if (!needHandleProps.contains(entry.getKey())) continue;
                globalSettings.put(entry.getKey(), entry.getValue());
            }
            recoveryPlan.setGlobalSettings(globalSettings);
        }
        return recoveryPlan;
    }

    static {
        List<String> kubeRecoveryProps = Arrays.asList("postHook", "namespace", "restorePrefix", "preserveNodePort", "preserveClusterIpAddr");
        REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.put(21, Collections.unmodifiableList(kubeRecoveryProps));
        REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.put(20, Collections.unmodifiableList(kubeRecoveryProps));
    }
}

