/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.calculator;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.protection.calculator.sdk.service.IRecoveryTimeObjectiveCalculator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class RecoveryTimeObjectiveCalculator
implements IRecoveryTimeObjectiveCalculator {
    private static final Log logger = LogFactory.getInstance(RecoveryTimeObjectiveCalculator.class);

    public Map<String, Object> calculate(ProtectGroup protectGroup) {
        HashMap<String, Object> rtoResults = new HashMap<String, Object>();
        JSONArray rtoJsonArray = new JSONArray();
        rtoResults.put("RTO_ITEM_KEY", rtoJsonArray.toString());
        if (protectGroup == null) {
            return rtoResults;
        }
        List<RecoveryLog> recoveryLogs = this.queryRecoveryLogsByPg(protectGroup);
        Map<String, List<RecoveryLog>> siteIdAndLogsMap = this.filterRecoveryLogs(recoveryLogs);
        if (VerifyUtil.isEmpty(siteIdAndLogsMap)) {
            return rtoResults;
        }
        Set<Map.Entry<String, List<RecoveryLog>>> entrySet = siteIdAndLogsMap.entrySet();
        for (Map.Entry<String, List<RecoveryLog>> entry : entrySet) {
            List<RecoveryLog> logs = entry.getValue();
            long estimateRto = this.calcEstimateRTO(logs);
            JSONObject rtoJsonObject = new JSONObject();
            rtoJsonObject.put((Object)"siteId", (Object)entry.getKey());
            rtoJsonObject.put((Object)"estimateRTO", (Object)estimateRto);
            rtoJsonArray.add((Object)rtoJsonObject);
        }
        rtoResults.put("RTO_ITEM_KEY", rtoJsonArray.toString());
        return rtoResults;
    }

    public List<String> getTypes() {
        ArrayList<String> supportedTemplateTypes = new ArrayList<String>();
        supportedTemplateTypes.add(String.valueOf(6));
        supportedTemplateTypes.add(String.valueOf(5));
        supportedTemplateTypes.add(String.valueOf(4));
        supportedTemplateTypes.add(String.valueOf(3));
        supportedTemplateTypes.add(String.valueOf(0));
        supportedTemplateTypes.add(String.valueOf(1));
        supportedTemplateTypes.add(String.valueOf(2));
        supportedTemplateTypes.add(String.valueOf(19));
        supportedTemplateTypes.add(String.valueOf(18));
        supportedTemplateTypes.add(String.valueOf(20));
        supportedTemplateTypes.add(String.valueOf(24));
        supportedTemplateTypes.add(String.valueOf(23));
        supportedTemplateTypes.add(String.valueOf(28));
        supportedTemplateTypes.add(String.valueOf(21));
        supportedTemplateTypes.add(String.valueOf(22));
        supportedTemplateTypes.add(String.valueOf(34));
        supportedTemplateTypes.add(String.valueOf(37));
        supportedTemplateTypes.add(String.valueOf(30));
        supportedTemplateTypes.add(String.valueOf(31));
        supportedTemplateTypes.add(String.valueOf(32));
        supportedTemplateTypes.add(String.valueOf(35));
        supportedTemplateTypes.add(String.valueOf(36));
        supportedTemplateTypes.add(String.valueOf(33));
        supportedTemplateTypes.add(String.valueOf(39));
        supportedTemplateTypes.add(String.valueOf(26));
        supportedTemplateTypes.add(String.valueOf(27));
        supportedTemplateTypes.add(String.valueOf(58));
        supportedTemplateTypes.add(String.valueOf(59));
        supportedTemplateTypes.add(String.valueOf(40));
        supportedTemplateTypes.add(String.valueOf(41));
        supportedTemplateTypes.add(String.valueOf(42));
        supportedTemplateTypes.add(String.valueOf(43));
        supportedTemplateTypes.add(String.valueOf(51));
        supportedTemplateTypes.add(String.valueOf(52));
        return supportedTemplateTypes;
    }

    private long calcEstimateRTO(List<RecoveryLog> recoveryLogs) {
        long estimateRto = 0L;
        if (VerifyUtil.isEmpty(recoveryLogs)) {
            throw new LegoCheckedException("RecoveryLogs is null.");
        }
        for (RecoveryLog recoveryLog : recoveryLogs) {
            long startTime = NumberUtil.convertToLong((Object)recoveryLog.getStartTime());
            long endTime = NumberUtil.convertToLong((Object)recoveryLog.getEndTime());
            estimateRto += endTime - startTime;
        }
        return estimateRto / (long)recoveryLogs.size();
    }

    private Map<String, List<RecoveryLog>> filterRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        HashMap<String, List<RecoveryLog>> validRecoveryLogs = new HashMap<String, List<RecoveryLog>>();
        if (VerifyUtil.isEmpty(recoveryLogs)) {
            return validRecoveryLogs;
        }
        for (RecoveryLog recoveryLog : recoveryLogs) {
            ArrayList<RecoveryLog> logs;
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == recoveryLog.getLogType()) break;
            String siteId = recoveryLog.getRecoverySiteId();
            if (siteId == null || siteId.trim().isEmpty()) {
                siteId = recoveryLog.getProductionSiteId();
            }
            if (null == (logs = (ArrayList<RecoveryLog>)validRecoveryLogs.get(siteId))) {
                logs = new ArrayList<RecoveryLog>();
            }
            if (50 <= logs.size()) continue;
            logs.add(recoveryLog);
            validRecoveryLogs.put(siteId, logs);
        }
        return validRecoveryLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RecoveryLog> queryRecoveryLogsByPg(ProtectGroup protectGroup) {
        Session session;
        List<RecoveryLog> validRecoveryLogs;
        block6: {
            String planId;
            block5: {
                validRecoveryLogs = new ArrayList<RecoveryLog>();
                session = null;
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                planId = this.getPlanIdByProtectGroup(protectGroup, session);
                if (!VerifyUtil.isEmpty((String)planId)) break block5;
                ArrayList<RecoveryLog> arrayList = validRecoveryLogs;
                DBOperationUtil.closeSession(session);
                return arrayList;
            }
            try {
                StringBuffer queryLogsSql = new StringBuffer();
                queryLogsSql.append("select LOGID, LOGSTATUS, LOGTYPE, STARTTIME, ENDTIME, PRODUCTIONSITEID, ");
                queryLogsSql.append("RECOVERYSITEID from ti_recoverylog where PLANID=:planId ");
                queryLogsSql.append("and ENDTIME is not null and LOGSTATUS=0 ");
                queryLogsSql.append("and (LOGTYPE=:drillingType or LOGTYPE=:reprotectType) order by STARTTIME DESC");
                NativeQuery query = session.createSQLQuery(queryLogsSql.toString());
                query.setString("planId", planId);
                query.setInteger("drillingType", DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue());
                query.setInteger("reprotectType", DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue());
                List recoveryLogs = query.list();
                if (VerifyUtil.isEmpty((Collection)recoveryLogs)) break block6;
                validRecoveryLogs = this.constructRecoveryLogs(recoveryLogs);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"Querying log failed. PgId:%s,error :%s.", new Object[]{protectGroup.getUuid(), ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return validRecoveryLogs;
    }

    private List<RecoveryLog> constructRecoveryLogs(List<?> result) {
        ArrayList<RecoveryLog> recoveryLogs = new ArrayList<RecoveryLog>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 7) continue;
            RecoveryLog recoveryLog = new RecoveryLog();
            recoveryLog.setLogId(String.valueOf(values[0]));
            recoveryLog.setLogStatus(CommUtil.convertToInteger((Object)values[1]).intValue());
            recoveryLog.setLogType(CommUtil.convertToInteger((Object)values[2]).intValue());
            recoveryLog.setStartTime(String.valueOf(values[3]));
            recoveryLog.setEndTime(String.valueOf(values[4]));
            recoveryLog.setProductionSiteId(String.valueOf(values[5]));
            recoveryLog.setRecoverySiteId(String.valueOf(values[6]));
            recoveryLogs.add(recoveryLog);
        }
        return recoveryLogs;
    }

    private String getPlanIdByProtectGroup(ProtectGroup protectGroup, Session session) {
        String queryPlanSql = "select a.PLANID from ti_recoveryplan a, ti_drp_r_pg b where b.PGID=:pgId and a.PLANID=b.PLANID and a.PLANUSE != " + RecoveryPlanUse.INTERNAL_USE.getValue() + ";";
        NativeQuery query = session.createSQLQuery(queryPlanSql);
        query.setString("pgId", protectGroup.getUuid());
        List planIds = query.list();
        if (VerifyUtil.isEmpty((Collection)planIds)) {
            return null;
        }
        if (planIds.size() != 1) {
            logger.error((Object)"The planIds exceeds one: %s.", new Object[]{planIds});
            throw new LegoCheckedException(-1L);
        }
        String planId = String.valueOf(planIds.get(0));
        return planId;
    }
}

