/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.drm.protection.checker.sdk.service.IProtectionChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProtectionCheckerManager {
    private static ProtectionCheckerManager instance = new ProtectionCheckerManager();
    private Map<String, IProtectionChecker> protectionCheckers = new HashMap<String, IProtectionChecker>();

    private ProtectionCheckerManager() {
    }

    public static ProtectionCheckerManager getInstance() {
        return instance;
    }

    public void onBind(IProtectionChecker checker, Map<?, ?> properties) {
        this.protectionCheckers.put(checker.getName(), checker);
    }

    public void onUnbind(IProtectionChecker checker, Map<?, ?> properties) {
        this.protectionCheckers.remove(checker.getName());
    }

    public List<IProtectionChecker> getProtectionCheckers() {
        Set<Map.Entry<String, IProtectionChecker>> entrySet = this.protectionCheckers.entrySet();
        ArrayList<IProtectionChecker> checkers = new ArrayList<IProtectionChecker>();
        for (Map.Entry<String, IProtectionChecker> entry : entrySet) {
            IProtectionChecker checker = entry.getValue();
            if (this.isExistedChecker(checker, checkers)) continue;
            checkers.add(checker);
        }
        return checkers;
    }

    private boolean isExistedChecker(IProtectionChecker checker, List<IProtectionChecker> existedCheckers) {
        boolean isExistedChecker = false;
        for (IProtectionChecker temp : existedCheckers) {
            if (!temp.equals(checker)) continue;
            isExistedChecker = true;
            break;
        }
        return isExistedChecker;
    }
}

