/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.checker.manager.ProtectionCheckerManager;
import com.huawei.ism.drm.protection.checker.sdk.service.IProtectionChecker;
import com.huawei.ism.drm.protection.checker.task.FixedProtectionCheckerThreadPool;
import com.huawei.ism.drm.protection.checker.task.ProtectionCheckerCallable;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ProtectionCheckerConcurrentExecutor {
    private static final Log logger = LogFactory.getInstance(ProtectionCheckerConcurrentExecutor.class);
    private List<ProtectGroup> protectGroups = new ArrayList<ProtectGroup>();
    private List<IProtectionChecker> protectionCheckers = new ArrayList<IProtectionChecker>();
    private CountDownLatch completedSignal;

    private ProtectionCheckerConcurrentExecutor(int latchCount) {
        this.completedSignal = new CountDownLatch(latchCount);
    }

    public static ProtectionCheckerConcurrentExecutor createExecutor(List<ProtectGroup> protectGroups) {
        if (VerifyUtil.isEmpty(protectGroups)) {
            logger.error((Object)"There is no protect group.");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectionCheckerManager protectCheckerMgr = ProtectionCheckerManager.getInstance();
        List<IProtectionChecker> protectionCheckers = protectCheckerMgr.getProtectionCheckers();
        if (VerifyUtil.isEmpty(protectionCheckers)) {
            logger.error((Object)"There is no protection checkers.");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectionCheckerConcurrentExecutor executor = new ProtectionCheckerConcurrentExecutor(protectGroups.size());
        executor.protectGroups.addAll(protectGroups);
        executor.protectionCheckers.addAll(protectionCheckers);
        return executor;
    }

    public void process() {
        for (ProtectGroup protectGroup : this.protectGroups) {
            ProtectionCheckerCallable callable = new ProtectionCheckerCallable(protectGroup, this.protectionCheckers, this.completedSignal);
            FixedProtectionCheckerThreadPool.submit(callable);
        }
        this.waitAllProcessorComplete();
    }

    private void waitAllProcessorComplete() {
        try {
            this.completedSignal.await();
        }
        catch (InterruptedException e) {
            logger.error((Object)"WaitAllProcessorComplete failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

