/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.action.service.IProtectExecutionPreprocessor;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectExecutionPreprocessorManager;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BasePrepareAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(BasePrepareAction.class);

    @Override
    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)"BasePrepareAction begin to execute,pgId:%s", new Object[]{protectGroup.getUuid()});
        return this.prepare(context);
    }

    protected boolean prepare(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)"BasePrepareAction begin to execute:%s", new Object[]{pg.getName()});
        if (DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() != pg.getStatus()) {
            logger.error((Object)"pg'status is not Running.");
            this.setDetail("lego.err.1073948458");
            return false;
        }
        try {
            IProtectionRemoteService protectionRemoteService = (IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class);
            if (!protectionRemoteService.checkHyperVault(pg, context)) {
                logger.error((Object)"vstore pair not normal and the local vault is not the hyper ACTIVE ");
                this.setDetail("lego.err.1073948223");
                return false;
            }
            HashSet pos = new HashSet();
            pos.addAll(pg.getPolist());
            ProtectGroupReplica pgReplica = this.getWillOperateReplica(pg, context);
            context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
            if (!VerifyUtil.isEmpty((Object)pgReplica)) {
                HashSet poReplicas = new HashSet();
                poReplicas.addAll(pgReplica.getReplicas());
                context.addObject("PO_REPLICA_ENTITY", poReplicas);
            }
            context.addObject("PO_ENTITY", pos);
            logger.info((Object)"BasePrepareAction end to execute:%s", new Object[]{pg.getName(), 90160758786988L});
            ProtectionJobUtil.getInstance().checkHyperMetro(pg, context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        try {
            this.preprocess(context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        return true;
    }

    private ProtectGroupReplica getWillOperateReplica(ProtectGroup pg, ActionContext context) {
        if (context.getObject("PG_EXECUTE_LOCATION") == null) {
            return null;
        }
        return ExecuteReplicaManager.getInstance().calculateExecuteReplica(pg, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")));
    }

    private void preprocess(ActionContext context) {
        ProtectExecutionPreprocessorManager procMgr = ProtectExecutionPreprocessorManager.getInstance();
        Collection<IProtectExecutionPreprocessor> processors = procMgr.getProtectExecutionPreprocessors();
        for (IProtectExecutionPreprocessor processor : processors) {
            Map preProcResult = processor.process(context);
            if (VerifyUtil.isEmpty((Map)preProcResult)) continue;
            Set entrySet = preProcResult.entrySet();
            for (Map.Entry entry : entrySet) {
                context.addObject((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

