/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.job;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Locale;
import javax.persistence.PersistenceException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class DataBaseClearJob
implements StatefulJob {
    private static final Log LOGGER = LogFactory.getInstance(DataBaseClearJob.class);
    private static final Integer LOG_RESERVED_NUMBER = 1000;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.clearProtectGroupLog();
        this.clearRecoveryLog();
    }

    private void clearProtectGroupLog() {
        CommonDAOLocator.getBaseDao().getHibernateTemplate().execute(session -> {
            LOGGER.debug((Object)"Start to query the protect group whose logs exceeds the upper limit.");
            session.createNativeQuery("SELECT TMP.PGID FROM (SELECT PGID, count(*) AS COUNT FROM TI_PROTECTGROUPLOG GROUP BY PGID) AS TMP WHERE TMP.COUNT > :logReservedNumber").setParameter("logReservedNumber", (Object)LOG_RESERVED_NUMBER).list().forEach(result -> {
                LOGGER.debug((Object)"Start delete protect group log jod. pg id: %s", new Object[]{result});
                if (!(result instanceof String) || VerifyUtil.isEmpty((Object)result)) {
                    LOGGER.error((Object)"PG Id from database is invalid.");
                    return;
                }
                String pgId = (String)result;
                try {
                    int update = session.createNativeQuery("DELETE FROM TI_PROTECTGROUPLOG WHERE PGID = :pgId AND STARTTIME < (SELECT STARTTIME FROM TI_PROTECTGROUPLOG WHERE PGID = :pgId ORDER BY STARTTIME DESC LIMIT 1 OFFSET :offset)").setParameter("pgId", (Object)pgId).setParameter("offset", (Object)(LOG_RESERVED_NUMBER - 1)).executeUpdate();
                    LOGGER.info((Object)"Delete protect group log jod success! pg id: %s, effect number line: %s, ", new Object[]{pgId, update});
                }
                catch (PersistenceException e) {
                    LOGGER.error((Object)String.format(Locale.ROOT, "Delete protect group log jod failed! pg id: %s. error message: %s", pgId, ExceptionUtil.getErrorMessage((Throwable)e)));
                }
            });
            return null;
        });
    }

    private void clearRecoveryLog() {
        CommonDAOLocator.getBaseDao().getHibernateTemplate().execute(session -> {
            LOGGER.debug((Object)"Start to query the recovery plan whose logs exceeds the upper limit.");
            session.createNativeQuery("SELECT TMP.PLANID FROM (SELECT PLANID, count(*) AS COUNT FROM TI_RECOVERYLOG GROUP BY PLANID) AS TMP WHERE TMP.COUNT > :logReservedNumber").setParameter("logReservedNumber", (Object)LOG_RESERVED_NUMBER).list().forEach(result -> {
                if (!(result instanceof String) || VerifyUtil.isEmpty((Object)result)) {
                    LOGGER.error((Object)"Plan Id from database is invalid.");
                    return;
                }
                String planId = (String)result;
                try {
                    int update = session.createNativeQuery("DELETE FROM TI_RECOVERYLOG WHERE PLANID = :planId AND STARTTIME < (SELECT STARTTIME FROM TI_RECOVERYLOG WHERE PLANID = :planId ORDER BY STARTTIME DESC LIMIT 1 OFFSET :offset)").setParameter("planId", (Object)planId).setParameter("offset", (Object)(LOG_RESERVED_NUMBER - 1)).executeUpdate();
                    LOGGER.info((Object)"Delete recovery log jod success! plan id: %s, effect number line: %s", new Object[]{planId, update});
                }
                catch (PersistenceException e) {
                    LOGGER.error((Object)String.format(Locale.ROOT, "Delete recovery log jod failed! plan id: %s. error message: %s", planId, ExceptionUtil.getErrorMessage((Throwable)e)));
                }
            });
            return null;
        });
    }
}

