/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.base.service.IConfigSyncRateService;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.base.ServiceContext;
import java.util.List;
import java.util.Map;

public class ReplicationSpeedPolicyObserver
implements IObjectObserver {
    public void before(MessageEvent event) {
    }

    public void after(MessageEvent event) {
        int messageType = event.getMessageType();
        if (messageType != 13) {
            return;
        }
        Map message = event.getMessageMap();
        Object protectGroupObject = message.get(ProtectGroup.class.getSimpleName());
        if (!(protectGroupObject instanceof ProtectGroup)) {
            return;
        }
        Object scheduleObject = message.get(Schedule.class.getSimpleName());
        if (!(scheduleObject instanceof Schedule)) {
            return;
        }
        ProtectGroup protectGroup = (ProtectGroup)protectGroupObject;
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        Schedule schedule = (Schedule)scheduleObject;
        IConfigSyncRateService jobService = (IConfigSyncRateService)ServiceContext.getInstance().lookup(IConfigSyncRateService.class);
        jobService.deleteOldSyncRateTask(protectGroup.getUuid(), policyTemplate);
        policyTemplate.removeSchedule(schedule.getScheduleId());
        policyTemplate.addSchedule(schedule);
        List<ProtectGroupSyncRatePolicy> pgSyncRates = ProtectGroupUtil.convertToSyncRatePolicy(policyTemplate);
        jobService.createSyncRateTask(protectGroup, pgSyncRates);
        jobService.runAtOnce(protectGroup, pgSyncRates, true);
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

