/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.context;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.group.CreateProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.context.CreateProtectGroupContextData;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class CreateProtectGroupContext {
    private static final Log LOGGER = LogFactory.getInstance(CreateProtectGroupContext.class);
    private static final ThreadLocal<CreateProtectGroupContextData> CONTEXT = new ThreadLocal();

    public static void set(CreateProtectGroupContextData data) {
        CONTEXT.set(data);
    }

    public static CreateProtectGroupContextData get() {
        return CONTEXT.get();
    }

    public static void remove() {
        CONTEXT.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProgress(int progress) {
        CreateProtectGroupContextData contextData = CreateProtectGroupContext.get();
        if (contextData == null) {
            LOGGER.warn((Object)"Update create protect group progress failed, cause could not find context data");
            return;
        }
        CreateProtectGroupBackTask createProtectGroupBackTask = contextData.getBackTask();
        if (createProtectGroupBackTask == null) {
            LOGGER.warn((Object)"Update create protect group progress failed, cause could not find current back task from context data");
            return;
        }
        BackTask backTask = createProtectGroupBackTask.getBackTask();
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String sql = "UPDATE T_backtask SET task_progress=:newProgress WHERE task_id=:taskid";
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(sql);
            query.setInteger("newProgress", progress);
            query.setLong("taskid", backTask.getTaskId().longValue());
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOGGER.error((Object)"Update create protect group progress failed");
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }
}

