/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.refinement.ProtectGroupServiceLocator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BaseProtectGroupRefineService {
    private static final Log logger = LogFactory.getInstance(BaseProtectGroupRefineService.class);
    private static final BaseProtectGroupRefineService INSTANCE = new BaseProtectGroupRefineService();

    public static BaseProtectGroupRefineService getInstance() {
        return INSTANCE;
    }

    public void updateProtectObjectProperties(ProtectGroup protectGroup) {
        IProtectObjectBaseProvider poProvider = BaseProtectGroupRefineService.getProtectObjectProvider(protectGroup.getPoType());
        if (poProvider == null) {
            logger.error((Object)"get IProtectObjectBaseProvider failed! poType:%s.", new Object[]{String.valueOf(protectGroup.getPoType())});
            throw new LegoCheckedException(-1L);
        }
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            protectObject.setProtectGroup(protectGroup);
            poProvider.updateProtectObjectProps(protectObject, protectObject.getProps());
        }
        poProvider.checkProtectObjectsInProtectGroup(protectGroup);
        poProvider.buildProtectObjects(protectGroup);
        try {
            ArrayList<ProtectObject> protectObjectList = new ArrayList<ProtectObject>();
            protectObjectList.addAll(protectGroup.getPolist());
            ProtectGroupHelper.getInstance().deleteProtectObjectStorageInfo(protectObjectList);
        }
        catch (Exception e) {
            logger.error((Object)"delete temp po StorageInfo error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758787071L});
        }
    }

    public static IProtectObjectBaseProvider getProtectObjectProvider(int poType) {
        List<IProtectObjectBaseProvider> result = ProtectGroupServiceLocator.getInstance().getServices(IProtectObjectBaseProvider.class);
        for (IProtectObjectBaseProvider provider : result) {
            if (provider.getProviderByType() != poType) continue;
            return provider;
        }
        return null;
    }

    private List<IObjectObserver> getObserverList() {
        ArrayList<IObjectObserver> result = new ArrayList<IObjectObserver>();
        List<IObjectObserver> observers = ProtectGroupServiceLocator.getInstance().getServices(IObjectObserver.class);
        for (IObjectObserver observer : observers) {
            if (!ProtectGroup.class.getName().equals(observer.getObserverType())) continue;
            result.add(observer);
        }
        result.sort((observer1, observer2) -> observer2.getPriority() - observer1.getPriority());
        return result;
    }

    public void notifyObserver(MessageEvent event, Runnable runnable) {
        try {
            this.notifyObserverList(event, "before");
            runnable.run();
            this.notifyObserverList(event, "after");
        }
        catch (Exception ex) {
            logger.error((Object)"Execute observer failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            event.getMessageMap().put("observerError", ex);
            this.notifyObserverList(event, "onError");
            throw ex;
        }
        finally {
            this.notifyObserverList(event, "onFinal");
        }
    }

    public void notifyObserverList(MessageEvent event, String notifyType) {
        try {
            for (IObjectObserver observer : this.getObserverList()) {
                if (observer == null || !ProtectGroup.class.getName().equals(observer.getObserverType())) continue;
                observer.onMessage(event, notifyType);
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to notify observer.", (Throwable)le, 90160758786898L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to notify observer.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public void syncProtectGroupToRemoteSite(ProtectGroup protectGroup, String url) {
        Set replicas = protectGroup.getReplicaList();
        HashSet<String> recoverSiteIds = new HashSet<String>();
        for (ProtectGroupReplica replica : replicas) {
            recoverSiteIds.add(replica.getRecoverySite());
        }
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return;
        }
        for (String recoverySiteId : recoverSiteIds) {
            if (VerifyUtil.isEmpty((String)recoverySiteId)) continue;
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(recoverySiteId);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)"Recovery Site is not exsit");
                throw new LegoCheckedException(1073947440L);
            }
            if (1 != site.getSiteType()) continue;
            RestClient client = SiteUtil.initClient(site);
            try {
                ProtectGroup clonePg = (ProtectGroup)protectGroup.clone();
                IProtectObjectBaseProvider provider = this.getProtectObjectProvider(clonePg);
                provider.decryptPropreties(clonePg);
                client.postSerializableObj((Object)clonePg, url);
            }
            catch (LegoCheckedException le) {
                logger.error((Object)this.getErrorMsg(protectGroup, site), (Throwable)le);
                throw le;
            }
            catch (CloneNotSupportedException e) {
                logger.error((Object)"clone pg error. pgId: %s.", new Object[]{protectGroup.getUuid()});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)this.getErrorMsg(protectGroup, site), (long)1073947440L, (String[])new String[0], (Log)logger);
            }
        }
    }

    private IProtectObjectBaseProvider getProtectObjectProvider(ProtectGroup protectGroup) {
        IProtectObjectBaseProvider provider = ((IProtectObjectProviderBaseDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderBaseDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        return provider;
    }

    private String getErrorMsg(ProtectGroup protectGroup, Site site) {
        String errorMsg = "sync Protect Group,name: " + protectGroup.getName() + " to remote site,name: " + site.getName() + " ,id: " + site.getSiteId() + " error";
        return errorMsg;
    }
}

