/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.util;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.util.FrontI18Util;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.path.sdk.service.IProtectionPathService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.util.ExcelUtil;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractProtectGroupExcelOperator {
    protected static List<Integer> inSensitiveToStorageTemplateTypeList = Arrays.asList(11, 21, 22);
    protected static final String LINE_BREAK = "\n";
    private static final Log logger = FELogFactory.getInstance((String)"ui");
    private static final int FIVE_COL_WIDTH = 4500;
    private static final int SIX_COL_WIDTH = 22000;
    private static final int MAX_LENGTH = 30000;
    private static Map<Integer, String[]> templateTypePathMap = new HashMap<Integer, String[]>();
    protected BatchOperationResult result = new BatchOperationResult();
    protected Map<String, StorageResource> storageResources = new HashMap<String, StorageResource>();
    private Locale useLocale = Locale.CHINA;

    public SXSSFWorkbook createExportExcel(List<ProtectGroup> protectgroups, BatchOperationResult results, Locale locale) {
        logger.debug((Object)"to create Export Excel..");
        this.result = results;
        if (locale != null) {
            this.useLocale = locale;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        this.createHeader(sheet);
        this.createDataArea(sheet, protectgroups);
        sheet.setColumnWidth(0, 4500);
        sheet.setColumnWidth(1, 4500);
        sheet.setColumnWidth(2, 4500);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4500);
        sheet.setColumnWidth(5, 4500);
        sheet.setColumnWidth(6, 22000);
        return ExcelUtil.convertToSXSSFWorkbook((XSSFWorkbook)wb);
    }

    protected abstract void createDataArea(XSSFSheet var1, List<ProtectGroup> var2);

    private void createHeader(XSSFSheet sheet) {
        logger.debug((Object)"to create excel header..");
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        this.initialHeaderCellStyle(sheet, cs);
        XSSFRow row0 = sheet.createRow(0);
        XSSFRow row1 = sheet.createRow(1);
        this.generateRow0Header(sheet, cs, (Row)row0);
        this.generateRow1Header(sheet, cs, (Row)row1);
    }

    private void generateRow1Header(XSSFSheet sheet, XSSFCellStyle cs, Row row1) {
        Cell cell = row1.createCell(3);
        cell.setCellValue(this.getText("com.huawei.ism.drm.policy.name.label"));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(1, 1, 3, 3);
        this.setRangeBorder(sheet, cra);
        cell = row1.createCell(4);
        cell.setCellValue(this.getText("com.huawei.ism.drm.gropu.device.column"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(1, 1, 4, 4);
        this.setRangeBorder(sheet, cra);
        cell = row1.createCell(5);
        cell.setCellValue(this.getText("com.huawei.ism.drm.gropu.device.type.column"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(1, 1, 5, 5);
        this.setRangeBorder(sheet, cra);
    }

    private void generateRow0Header(XSSFSheet sheet, XSSFCellStyle cs, Row row0) {
        Cell cell = row0.createCell(0);
        cell.setCellValue(this.getText("ism.drm.drp.local.name.label"));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(0, 1, 0, 0);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(1);
        cell.setCellValue(this.getText("ism.drm.protect.group.aptype"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 1, 1);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(2);
        cell.setCellValue(this.getText("ism.drm.protect.group.template"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 2, 2);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(3);
        cell.setCellValue(this.getText("ism.drm.protect.element"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 0, 3, 5);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(6);
        cell.setCellValue(this.getText("ism.drm.protect.group.therecoverypath"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 6, 6);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
    }

    private void initialHeaderCellStyle(XSSFSheet sheet, XSSFCellStyle cs) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        ExcelUtil.setTextFormat((Sheet)sheet, (CellStyle)cs);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(IndexedColors.RED.getIndex());
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont((Font)font);
    }

    protected String getText(String string) {
        return FrontI18Util.getText(string, this.useLocale);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        logger.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    protected BatchOperation generatePgInExcelCell(XSSFSheet sheet, int rowIndex, int rowMergeIndex, XSSFCellStyle cs, ProtectGroup protectgroup) {
        XSSFRow mergeRow = sheet.createRow(rowIndex);
        Cell cell = mergeRow.createCell(0);
        cell.setCellValue(protectgroup.getName());
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(rowIndex, rowMergeIndex, 0, 0);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        cell = mergeRow.createCell(1);
        cell.setCellValue(this.getPoTypeLabel(protectgroup.getPoType()));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowMergeIndex, 1, 1);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        cell = mergeRow.createCell(2);
        cell.setCellValue(this.getTemplateName(protectgroup.getTemplate().getName()));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowMergeIndex, 2, 2);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        cell = mergeRow.createCell(6);
        BatchOperation batchOperation = new BatchOperation();
        cell.setCellValue(this.getDisasterRecoveryPath(protectgroup, batchOperation));
        cs.setAlignment(HorizontalAlignment.LEFT);
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowMergeIndex, 6, 6);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        return batchOperation;
    }

    protected void generatePoInExcelCell(XSSFSheet sheet, int rowIndex, XSSFCellStyle cs, List<List<String>> poRows) {
        int tmp = 0;
        for (List<String> rowdata : poRows) {
            XSSFRow row = sheet.getRow(rowIndex + tmp);
            if (null == row) {
                row = sheet.createRow(rowIndex + tmp);
            }
            Cell cell = row.createCell(3);
            cell.setCellValue(rowdata.get(0));
            cell.setCellStyle((CellStyle)cs);
            cell = row.createCell(4);
            cell.setCellValue(rowdata.get(2));
            cell.setCellStyle((CellStyle)cs);
            cell = row.createCell(5);
            cell.setCellValue(rowdata.get(1));
            cell.setCellStyle((CellStyle)cs);
            ++tmp;
        }
    }

    protected void initialDataAreaCellStyle(XSSFSheet sheet, XSSFCellStyle cs) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        short defaultDataFmt = sheet.getWorkbook().createDataFormat().getFormat("text");
        cs.setDataFormat(defaultDataFmt);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setWrapText(true);
    }

    private void mergedCells(XSSFSheet sheet, ProtectGroup protectgroup, CellRangeAddress cra) {
        if (protectgroup.getPoCount() > 1) {
            sheet.addMergedRegion(cra);
        }
    }

    protected abstract List<StorageResource> getStorageResources(String var1, List<String> var2);

    protected abstract Map<String, List<List<String>>> getInfoByPo(List<ProtectGroup> var1);

    private String getPoTypeLabel(int poType) {
        String typeLabel;
        logger.info((Object)"to getPoTypeLabel start.. poType:%s", new Object[]{String.valueOf(poType)});
        switch (poType) {
            case 11: {
                typeLabel = this.getText("ism.drm.app.type.storage.lun");
                break;
            }
            case 1: {
                typeLabel = this.getText("ism.drm.app.type.oracle");
                break;
            }
            case 2: {
                typeLabel = this.getText("ism.drm.app.type.sqlserver");
                break;
            }
            case 3: {
                typeLabel = this.getText("ism.drm.app.type.db2");
                break;
            }
            case 8: 
            case 13: {
                typeLabel = this.getText("protection.term.Exchange.label");
                break;
            }
            case 9: {
                typeLabel = this.getText("protection.term.localFS.label");
                break;
            }
            case 10: {
                typeLabel = this.getText("protection.term.VMwareVM.label");
                break;
            }
            case 12: {
                typeLabel = this.getText("protection.term.HWVM.label");
                break;
            }
            case 14: {
                typeLabel = this.getText("protection_term_nasFS_label");
                break;
            }
            case 15: {
                typeLabel = this.getText("ism.drm.app.type.cache");
                break;
            }
            case 16: {
                typeLabel = this.getText("ism.drm.app.type.saphana");
                break;
            }
            default: {
                typeLabel = "--";
            }
        }
        return typeLabel;
    }

    private String getTemplateName(String templatetypename) {
        return this.getText(templatetypename);
    }

    private String getDisasterRecoveryPath(ProtectGroup protectgroup, BatchOperation batchOperation) {
        StringBuffer sb = new StringBuffer();
        try {
            int templatetype = protectgroup.getTemplate().getType();
            String siteRelation = this.getText("ism.drm.protect.group.siterapport");
            String rdPath = this.getText("ism.drm.protect.group.recoverypath");
            String siteRelationDesc = "";
            String rdPathDesc = "";
            ArrayList<String> descList = new ArrayList<String>();
            this.siteRelation(templatetype, descList);
            IProtectionPathService protectionPathService = (IProtectionPathService)ServiceLocator.getInstance().getService(IProtectionPathService.class);
            ProtectionPathData ppd = protectionPathService.getPath(protectgroup, this.storageResources, batchOperation);
            if (templatetype == 3 || templatetype == 5) {
                int actualTemplateType = ppd.getTemplateType();
                this.setDRRingDesc(descList, protectgroup, actualTemplateType);
            }
            if (descList.size() > 1) {
                siteRelationDesc = (String)descList.get(0);
                rdPathDesc = (String)descList.get(1);
            }
            this.setBatchOperation(batchOperation, ppd);
            List pps = ppd.getPathList();
            if (pps.size() >= 2) {
                ((ProtectionPath)pps.get(0)).setName(siteRelation);
                ((ProtectionPath)pps.get(0)).setDecription(siteRelationDesc);
                ((ProtectionPath)pps.get(1)).setName(rdPath);
                ((ProtectionPath)pps.get(1)).setDecription(rdPathDesc);
                for (ProtectionPath pp : pps) {
                    sb.append(pp.getName());
                    sb.append(pp.getDecription());
                    sb.append((String)pp.getPathDetails().get(0));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"get disaster recovery path failed ,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        String path = sb.toString();
        if (path.length() > 30000) {
            path = (String)path.subSequence(0, 30000) + "..." + LINE_BREAK;
            String alarm = this.getText("ism.drm.protect.group.pathalarm");
            path = path + alarm;
        }
        return path;
    }

    private void setBatchOperation(BatchOperation batchOperation, ProtectionPathData ppd) {
        if (ppd.getOperation() != null) {
            batchOperation.setDetailParam(ppd.getOperation().getDetailParam());
            batchOperation.setErrorCode(ppd.getOperation().getErrorCode());
            batchOperation.setExtTargetId(ppd.getOperation().getExtTargetId());
            batchOperation.setOptDetail(ppd.getOperation().getOptDetail());
            batchOperation.setTargetId(ppd.getOperation().getTargetId());
            batchOperation.setTargetName(ppd.getOperation().getTargetName());
            batchOperation.setTargetNameParam(ppd.getOperation().getTargetNameParam());
        }
    }

    private void setDRRingDesc(List<String> descList, ProtectGroup protectgroup, int actualTemplateType) {
        String[] siteRelationAndPathArray = templateTypePathMap.get(actualTemplateType);
        if (siteRelationAndPathArray == null || siteRelationAndPathArray.length < 2) {
            descList.add("--");
            descList.add("--");
            return;
        }
        Set proReplicas = protectgroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)proReplicas)) {
            logger.info((Object)"ProtectGroupReplica is empty or null, protectgroup name:%s", new Object[]{protectgroup.getName()});
            return;
        }
        for (ProtectGroupReplica proReplica : proReplicas) {
            if (DrmEnumDefine.ProtectLocation.C_C.getValue() != proReplica.getProtectLocation()) continue;
            String siteRelationDesc = "";
            StringBuilder rdPathDescBuilder = new StringBuilder();
            this.getRdPathDesc(siteRelationAndPathArray, rdPathDescBuilder);
            descList.clear();
            descList.add(siteRelationDesc);
            descList.add(rdPathDescBuilder.toString());
            break;
        }
    }

    private void siteRelation(int templatetype, List<String> descList) {
        logger.info((Object)"to siteRelation start.. templatetype:%s, descList:%s", new Object[]{templatetype, descList});
        String[] siteRelationAndPathArray = templateTypePathMap.get(templatetype);
        if (siteRelationAndPathArray == null || siteRelationAndPathArray.length < 2) {
            descList.add("--");
            descList.add("--");
            return;
        }
        String tempText = this.getText(siteRelationAndPathArray[0]);
        String siteRelationDesc = 26 == templatetype || 27 == templatetype ? "" : tempText;
        StringBuilder rdPathDescBuilder = new StringBuilder();
        this.getRdPathDesc(siteRelationAndPathArray, rdPathDescBuilder);
        if (34 == templatetype || 37 == templatetype) {
            siteRelationDesc = "";
            rdPathDescBuilder = new StringBuilder();
        }
        descList.add(siteRelationDesc);
        descList.add(rdPathDescBuilder.toString());
    }

    private void getRdPathDesc(String[] siteRelationAndPathArray, StringBuilder rdPathDescBuilder) {
        for (int i = 1; i < siteRelationAndPathArray.length; ++i) {
            String key = siteRelationAndPathArray[i];
            if (!LINE_BREAK.equals(key)) {
                rdPathDescBuilder.append(this.getText(key));
                continue;
            }
            rdPathDescBuilder.append(key);
        }
    }

    static {
        String siterelationdesc = "ism.drm.protect.group.prositetorecoverysite";
        String[] cascadeAsyncAsyncArray = new String[]{"ism.drm.protect.group.prositetoonetotwo", "ism.drm.protect.group.proluntoonetotwo", LINE_BREAK};
        templateTypePathMap.put(4, cascadeAsyncAsyncArray);
        templateTypePathMap.put(3, cascadeAsyncAsyncArray);
        templateTypePathMap.put(35, cascadeAsyncAsyncArray);
        String[] concurrentSyncAsyncArray = new String[]{"ism.drm.protect.group.prositetoonerecover", "ism.drm.protect.group.proluntoonerecover", LINE_BREAK};
        templateTypePathMap.put(6, concurrentSyncAsyncArray);
        templateTypePathMap.put(5, concurrentSyncAsyncArray);
        templateTypePathMap.put(36, concurrentSyncAsyncArray);
        String[] hyperMetroAsyncRingArray = new String[]{"ism.drm.protect.group.ringnullsitering", "ism.drm.protect.group.proarrayhypermetroasync", LINE_BREAK};
        templateTypePathMap.put(26, hyperMetroAsyncRingArray);
        templateTypePathMap.put(27, hyperMetroAsyncRingArray);
        String[] arrayReplicaAsync = new String[]{siterelationdesc, "ism.drm.protect.group.producttorecoverylun", LINE_BREAK};
        templateTypePathMap.put(1, arrayReplicaAsync);
        templateTypePathMap.put(0, arrayReplicaAsync);
        templateTypePathMap.put(33, arrayReplicaAsync);
        templateTypePathMap.put(11, new String[]{siterelationdesc, "ism.drm.protect.group.provrgtorecoveryvrg", LINE_BREAK});
        String[] arraySnapshot = new String[]{"ism.drm.protect.group.theproductsite", "ism.drm.protect.group.productlun", LINE_BREAK};
        templateTypePathMap.put(2, arraySnapshot);
        templateTypePathMap.put(14, arraySnapshot);
        String[] arrayHyperMetro = new String[]{"ism.drm.protect.group.prositearrayhypermetro", "ism.drm.protect.group.proarrayhypermetro", LINE_BREAK};
        templateTypePathMap.put(15, arrayHyperMetro);
        templateTypePathMap.put(19, arrayHyperMetro);
        templateTypePathMap.put(53, arrayHyperMetro);
        String[] arrayHyperVault = new String[]{"ism.drm.protect.group.prositearrayhypervault", "ism.drm.protect.group.proarrayhypervault", LINE_BREAK};
        templateTypePathMap.put(17, arrayHyperVault);
        templateTypePathMap.put(30, arrayHyperVault);
        String[] arrayHyperMetroVault = new String[]{"ism.drm.protect.group.prositearrayhypermetrovault", "ism.drm.protect.group.proarrayhypermetrovault", LINE_BREAK};
        templateTypePathMap.put(28, arrayHyperMetroVault);
        templateTypePathMap.put(31, arrayHyperMetroVault);
        templateTypePathMap.put(32, arrayHyperMetroVault);
        String[] arrayHyperMetroAsync = new String[]{"ism.drm.protect.group.prositearrayhypermetroasync", "ism.drm.protect.group.proarrayhypermetroasync", LINE_BREAK};
        templateTypePathMap.put(18, arrayHyperMetroAsync);
        templateTypePathMap.put(23, arrayHyperMetroAsync);
        String[] arrayAsyncHyperMetro = new String[]{"ism.drm.protect.group.prositearrayasynchypermetro", "ism.drm.protect.group.proarrayasynchypermetro", LINE_BREAK};
        templateTypePathMap.put(20, arrayAsyncHyperMetro);
        templateTypePathMap.put(24, arrayAsyncHyperMetro);
        String[] openStackHyperMetroAsyncRingArray = new String[]{"ism.drm.protect.group.proarrayasynchypermetro", "ism.drm.protect.group.proarrayhypermetroasync", LINE_BREAK};
        templateTypePathMap.put(34, openStackHyperMetroAsyncRingArray);
        templateTypePathMap.put(37, openStackHyperMetroAsyncRingArray);
        String[] arrayHyperClone = new String[]{"ism.drm.protect.group.theproductsite", "ism.drm.protect.group.producttorecoverylun", LINE_BREAK};
        templateTypePathMap.put(16, arrayHyperClone);
        String[] osArrayReplica = new String[]{siterelationdesc, "ism.drm.protect.group.producttorecoveryprojandzone", LINE_BREAK};
        templateTypePathMap.put(22, osArrayReplica);
        templateTypePathMap.put(21, osArrayReplica);
    }
}

