/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.process.IProtectGroupLockingCustomPreProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryPreProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class ProtectGroupLockingPreProcessor
implements IRecoveryPreProcessor {
    private static final Log logger = LogFactory.getInstance(ProtectGroupLockingPreProcessor.class);
    private Map<String, IProtectGroupLockingCustomPreProcessor> customPreProcessors = new HashMap<String, IProtectGroupLockingCustomPreProcessor>();

    public Map<String, Object> process(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (plan == null || execType == null) {
            logger.error((Object)"plan= %s, execType= %s", new Object[]{plan, execType});
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupLockingCustomPreProcessor processor = this.customPreProcessors.get(execType.name());
        if (processor == null) {
            logger.info((Object)"processor is null , planId=%s, execType=%s", new Object[]{plan.getUuid(), execType});
            return null;
        }
        Map processResult = processor.process(plan);
        if (processResult == null) {
            return null;
        }
        logger.info((Object)"%s, processResult=%s", new Object[]{processor, processResult});
        Object lockValue = processResult.get("LockProtectGroup");
        if (lockValue != null && !((Boolean)lockValue).booleanValue()) {
            logger.error((Object)"lock ProtectGroup failed, rpId=%s.", new Object[]{plan.getUuid()});
            throw new LegoCheckedException(102401L);
        }
        return processResult;
    }

    public void clean(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, Map<String, Object> preProcessResults) {
        logger.debug((Object)"preprocess.");
    }

    public void onBind(IProtectGroupLockingCustomPreProcessor preProcessor, Map<?, ?> properties) {
        this.customPreProcessors.put(preProcessor.getType(), preProcessor);
    }

    public void onUnbind(IProtectGroupLockingCustomPreProcessor preProcessor, Map<?, ?> properties) {
        this.customPreProcessors.remove(preProcessor.getType());
    }
}

