/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class RecoveryProcessorMgr {
    private static RecoveryProcessorMgr recoveryProcMgr = new RecoveryProcessorMgr();
    private Map<String, IRecoveryProcessBaseProvider> processProviders = new HashMap<String, IRecoveryProcessBaseProvider>();
    private Map<Integer, Class<? extends RecoveryProcessor>> syncProcessors = new HashMap<Integer, Class<? extends RecoveryProcessor>>();
    private IRecoveryProcessBaseHandler recoveryProcessHandler;

    private RecoveryProcessorMgr() {
    }

    public static RecoveryProcessorMgr getInstance() {
        return recoveryProcMgr;
    }

    public void onBind(IRecoveryProcessBaseProvider provider, Map<String, Object> properties) {
        ClassLoader globalClassLoader = this.getClass().getClassLoader();
        DrmObjectSerializableUtil.setGlobalClassLoader(globalClassLoader);
        for (String appType : provider.getAppType()) {
            this.processProviders.put(appType, provider);
        }
        Map regSyncProcessors = provider.registerSyncProcessor();
        if (regSyncProcessors == null || regSyncProcessors.isEmpty()) {
            return;
        }
        Set entrySet = regSyncProcessors.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer repType = (Integer)entry.getKey();
            if (this.syncProcessors.get(repType) != null) continue;
            this.syncProcessors.put(repType, (Class<? extends RecoveryProcessor>)entry.getValue());
        }
    }

    public void onUnbind(IRecoveryProcessBaseProvider provider, Map<String, Object> properties) {
        for (String appType : provider.getAppType()) {
            this.processProviders.remove(appType);
        }
        Map regSyncProcessors = provider.registerSyncProcessor();
        if (regSyncProcessors == null || regSyncProcessors.isEmpty()) {
            return;
        }
        for (Integer repType : regSyncProcessors.keySet()) {
            this.syncProcessors.remove(repType);
        }
    }

    public void setRecoveryProcessHandler(IRecoveryProcessBaseHandler recoveryProcessHandler) {
        this.recoveryProcessHandler = recoveryProcessHandler;
    }

    public IRecoveryProcessBaseHandler getRecoveryProcessHandler() {
        return this.recoveryProcessHandler;
    }

    public IRecoveryProcessBaseProvider getRecoveryProcessProvider(String appType) {
        return this.processProviders.get(appType);
    }

    public Class<? extends RecoveryProcessor> getSyncProcessor(int repType) {
        return this.syncProcessors.get(repType);
    }
}

