/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectBaseService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public abstract class ReprotectBaseRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5396809361839075163L;
    private static final Log logger = LogFactory.getInstance(ReprotectBaseRecoveryProcessor.class);
    private static final String SRC_LUN_ID = "srcLunId";
    private static final String IS_PRIMARY = "isPrimary";
    private static final String LOCAL_RES_TYPE = "localResType";

    public ReprotectBaseRecoveryProcessor() {
    }

    public ReprotectBaseRecoveryProcessor(RecoveryProcessor parentProcess) {
        this();
        if (null == parentProcess) {
            return;
        }
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected String generateResultKey() {
        return this.getName() + "_" + this.getPlanId();
    }

    protected String getRecoveryArrayByPg(ProtectGroup pg, String disasterSiteId) {
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            return replica.getRecoveryArray();
        }
        return null;
    }

    protected String getProductArrayByPg(ProtectGroup pg, String disasterSiteId) {
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            return replica.getProductArray();
        }
        return null;
    }

    protected List<String> getLunIds(ProtectGroup pg, String disasterSiteId) {
        ArrayList<String> lunIds = new ArrayList<String>();
        ProtectGroupReplica pgReplica = null;
        String recoveryArray = "";
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            recoveryArray = pgReplica.getRecoveryArray();
            break;
        }
        if (null == pgReplica) {
            return lunIds;
        }
        for (ProtectGroupReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                if (!recoveryArray.equals(storageInfo.getStorageProviderSN())) continue;
                lunIds.add(storageInfo.getStorageId());
            }
        }
        return lunIds;
    }

    protected boolean saveProcessors(Set<RecoveryProcessor> subProcessors) {
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        boolean result = recoveryProcessService.updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected List<ReplicationPair> getReplicationPairListBySrcLun(String arraySn, String srcLunId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", arraySn);
        props.put(SRC_LUN_ID, srcLunId);
        props.put(IS_PRIMARY, true);
        List pairs = CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            logger.warn((Object)("pairs is null or empty for lun:" + srcLunId + ", DevSN:" + arraySn), 90160758786816L);
            return Collections.emptyList();
        }
        return pairs;
    }

    protected boolean isReversed(Set<String> oldProductSiteIdSet, String oldProductDevSn, String oldDisasterDevSn, String oldTgtLunId, int policyType) {
        List<ReplicationPair> pairs = this.getReplicationPairListBySrcLun(oldDisasterDevSn, oldTgtLunId);
        if (VerifyUtil.isEmpty(pairs)) {
            return false;
        }
        IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (ReplicationPair replicationPair : pairs) {
            List targetLuns = moDao.getAllSubMo(replicationPair.getMoId().longValue(), ReplicationTargetLun.class);
            if (VerifyUtil.isEmpty((Collection)targetLuns)) {
                logger.error((Object)("There is no target luns. PairId:" + replicationPair.getReplicationId()), 90160758784001L);
                throw new LegoCheckedException(1073948461L);
            }
            for (ReplicationTargetLun targetLun : targetLuns) {
                if (!targetLun.getTgtDevSN().equals(oldProductDevSn)) continue;
                Integer pairStatus = targetLun.getPairStatus();
                if (this.isPairStatusUnNormal(pairStatus)) {
                    logger.error((Object)("pair status is not normal. Status:" + pairStatus + ",PairId:" + replicationPair.getReplicationId()), 90160758784001L);
                    throw new LegoCheckedException(1073948462L);
                }
                Site newDisasterSite = recoveryService.getStorageRegisteredSite(targetLun.getTgtDevSN());
                if (null == newDisasterSite || 18 != policyType && 31 != policyType && !oldProductSiteIdSet.contains(newDisasterSite.getSiteId())) continue;
                return true;
            }
        }
        return false;
    }

    protected ReplicationRelation findReversedStorageRelation(String oldProductDevSn, String oldDiasterDevSn, String oldTgtLunId) {
        List<ReplicationPair> pairs = this.getReplicationPairListBySrcLun(oldDiasterDevSn, oldTgtLunId);
        if (VerifyUtil.isEmpty(pairs)) {
            logger.info((Object)"pairs is null.");
            return null;
        }
        IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (ReplicationPair replicationPair : pairs) {
            List targetLuns = moDao.getAllSubMo(replicationPair.getMoId().longValue(), ReplicationTargetLun.class);
            if (VerifyUtil.isEmpty((Collection)targetLuns)) {
                logger.info((Object)"targetLuns is null.");
                continue;
            }
            for (ReplicationTargetLun targetLun : targetLuns) {
                logger.info((Object)"getTgtDevSN:%s, oldProductDevSn:%s", new Object[]{targetLun.getTgtDevSN(), oldProductDevSn});
                if (!targetLun.getTgtDevSN().equals(oldProductDevSn)) continue;
                boolean isGroup = this.isValidHexNumber(replicationPair.getConsistentGroupId());
                String replicationId = isGroup ? replicationPair.getConsistentGroupId() : replicationPair.getReplicationId();
                return recoveryService.queryReplication(replicationPair.getSrcDevSN(), targetLun.getTgtDevSN(), replicationId, isGroup);
            }
        }
        return null;
    }

    protected void syncPgInfo(String siteId, ProtectGroup pg) {
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("find no site,and siteId is:" + siteId), 90160758787071L);
            return;
        }
        if (1 == site.getSiteType()) {
            try {
                IReprotectBaseService pgService = (IReprotectBaseService)ServiceLocator.getInstance().getService(IReprotectBaseService.class);
                pgService.syncProtectGroupToRemoteSite(pg, "/ws/protectgroups/action/syncProtectGroupInfo");
            }
            catch (LegoCheckedException e) {
                String errorMsg = "sync Protect Group to remote site error";
                logger.error((Object)errorMsg, (Throwable)e, 90160758787071L);
                throw new LegoCheckedException(1073947440L, (Throwable)e);
            }
            logger.debug((Object)"sync Protect Group to remote site done.", 90160758786816L);
        }
    }

    private boolean isValidHexNumber(String id) {
        if (null == id) {
            return false;
        }
        String validate = "(?i)[0-9a-f]+";
        return id.matches(validate);
    }

    private boolean isPairStatusUnNormal(Integer pairStatus) {
        ArrayList<Integer> unNormalStatus = new ArrayList<Integer>();
        unNormalStatus.add(6);
        unNormalStatus.add(4);
        unNormalStatus.add(XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue());
        unNormalStatus.add(XveEuumDefineParent.RUNNING_STATUS_E.INTERRUPTED.getValue());
        return unNormalStatus.contains(pairStatus);
    }

    protected List<String> getLunIds(ProtectGroup pg, String disasterSiteId, Map<String, Integer> resourceTypeMap) {
        ArrayList<String> lunIds = new ArrayList<String>();
        ProtectGroupReplica pgReplica = null;
        String recoveryArray = "";
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            recoveryArray = pgReplica.getRecoveryArray();
            break;
        }
        if (null == pgReplica) {
            return lunIds;
        }
        for (ProtectGroupReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                if (!recoveryArray.equals(storageInfo.getStorageProviderSN())) continue;
                Integer localResType = 11;
                String wwn = storageInfo.getProtectObjectStorageWwn();
                if (VerifyUtil.isEmpty((String)wwn) || wwn.contains("/")) {
                    localResType = 40;
                }
                resourceTypeMap.put(storageInfo.getStorageId(), localResType);
                lunIds.add(storageInfo.getStorageId());
            }
        }
        return lunIds;
    }

    protected boolean isReversed(Set<String> oldProductSiteIdSet, RelicaStorageInfo storageInfo, int policyType, Integer localResType) {
        String oldProductDevSn = storageInfo.getSrcStorageProviderSN();
        String oldDisasterDevSn = storageInfo.getStorageProviderSN();
        List<ReplicationPair> pairs = this.getReplicationPairs(oldProductSiteIdSet, storageInfo, policyType, localResType, oldDisasterDevSn);
        if (CollectionUtils.isEmpty(pairs)) {
            return false;
        }
        IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (ReplicationPair replicationPair : pairs) {
            List targetLuns = moDao.getAllSubMo(replicationPair.getMoId().longValue(), ReplicationTargetLun.class);
            if (VerifyUtil.isEmpty((Collection)targetLuns)) {
                logger.error((Object)"There is no target luns. PairId: %s", new Object[]{replicationPair.getReplicationId()});
                throw new LegoCheckedException(1073948461L);
            }
            for (ReplicationTargetLun targetLun : targetLuns) {
                if (!targetLun.getTgtDevSN().equals(oldProductDevSn)) continue;
                Integer pairStatus = targetLun.getPairStatus();
                if (this.isPairStatusUnNormal(pairStatus)) {
                    logger.error((Object)"pair status is not normal. Status: %s ,PairId: %s", new Object[]{pairStatus, replicationPair.getReplicationId()});
                    throw new LegoCheckedException(1073948462L);
                }
                Site newDisasterSite = recoveryService.getStorageRegisteredSite(targetLun.getTgtDevSN());
                if (newDisasterSite == null || policyType != 18 && policyType != 31 && !oldProductSiteIdSet.contains(newDisasterSite.getSiteId())) continue;
                return true;
            }
        }
        return false;
    }

    private List<ReplicationPair> getReplicationPairs(Set<String> oldProductSiteIdSet, RelicaStorageInfo storageInfo, int policyType, Integer localResType, String oldDisasterDevSn) {
        List<ReplicationPair> pairs = PolicyTemplateType.AIR_GAP_NETWORKING.contains(policyType) ? this.getAirGapPairs(oldProductSiteIdSet, storageInfo, localResType) : this.getReplicationPairListBySrcLun(oldDisasterDevSn, storageInfo.getStorageId(), localResType, true);
        return pairs;
    }

    private List<ReplicationPair> getAirGapPairs(Set<String> oldProductSiteIdSet, RelicaStorageInfo storageInfo, Integer localResType) {
        Optional opt = oldProductSiteIdSet.stream().findFirst();
        if (!opt.isPresent()) {
            logger.error((Object)"Not has old product site id.");
            return Collections.emptyList();
        }
        String oldProductSiteId = (String)opt.get();
        String oldDisasterDevSn = storageInfo.getStorageProviderSN();
        try {
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteByDeviceSn(oldDisasterDevSn);
            if (oldProductSiteId.equals(site.getSiteId()) && site.getIsAirGapSite().booleanValue()) {
                return this.getReplicationPairListBySrcLun(oldDisasterDevSn, storageInfo.getSrcStorageId(), localResType, false);
            }
        }
        catch (LegoCheckedException e) {
            logger.info((Object)"oldDisasterDevSn: %s is not air gap site.", new Object[]{oldDisasterDevSn});
        }
        return this.getReplicationPairListBySrcLun(storageInfo.getSrcStorageProviderSN(), storageInfo.getSrcStorageId(), localResType, true);
    }

    protected List<ReplicationPair> getReplicationPairListBySrcLun(String arraySn, String srcLunId, Integer localResType, boolean isPrimary) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", arraySn);
        props.put(SRC_LUN_ID, srcLunId);
        props.put(IS_PRIMARY, isPrimary);
        props.put(LOCAL_RES_TYPE, localResType);
        List pairs = CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            logger.warn((Object)("pairs is null or empty for lun:" + srcLunId + ", DevSN:" + arraySn + "localResType=" + localResType), 90160758786816L);
            return Collections.emptyList();
        }
        return pairs;
    }

    protected ReplicationRelation findReversedStorageRelation(String oldProductDevSn, String oldDiasterDevSn, String oldTgtLunId, Integer localResType, boolean isPrimary) {
        String arraySn = isPrimary ? oldDiasterDevSn : oldProductDevSn;
        List<ReplicationPair> pairs = this.getReplicationPairListBySrcLun(arraySn, oldTgtLunId, localResType, isPrimary);
        if (VerifyUtil.isEmpty(pairs)) {
            logger.info((Object)"pairs is null.");
            return null;
        }
        IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (ReplicationPair replicationPair : pairs) {
            List targetLuns = moDao.getAllSubMo(replicationPair.getMoId().longValue(), ReplicationTargetLun.class);
            if (VerifyUtil.isEmpty((Collection)targetLuns)) {
                logger.info((Object)"targetLuns is null.");
                continue;
            }
            for (ReplicationTargetLun targetLun : targetLuns) {
                logger.info((Object)"getTgtDevSN:%s, oldProductDevSn:%s", new Object[]{targetLun.getTgtDevSN(), oldProductDevSn});
                if (!targetLun.getTgtDevSN().equals(oldProductDevSn)) continue;
                boolean isGroup = this.isValidHexNumber(replicationPair.getConsistentGroupId());
                String replicationId = isGroup ? replicationPair.getConsistentGroupId() : replicationPair.getReplicationId();
                return recoveryService.queryReplication(replicationPair.getSrcDevSN(), targetLun.getTgtDevSN(), replicationId, isGroup);
            }
        }
        return null;
    }
}

