/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.drm.recovery.process.IRefactorConfigurationBaseProvider;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public final class RefactorConfigurationProviderMgr {
    private static RefactorConfigurationProviderMgr refactorConfigProviderMgr = new RefactorConfigurationProviderMgr();
    private Map<String, IRefactorConfigurationBaseProvider> refactorConfigurationProviders = new ConcurrentHashMap<String, IRefactorConfigurationBaseProvider>();

    private RefactorConfigurationProviderMgr() {
    }

    public static RefactorConfigurationProviderMgr getInstance() {
        return refactorConfigProviderMgr;
    }

    public IRefactorConfigurationBaseProvider getRefactorConfigurationProvider(String appType) {
        return this.refactorConfigurationProviders.get(appType);
    }

    public void onBind(IRefactorConfigurationBaseProvider provider, Map<?, ?> properties) {
        if (!CollectionUtils.isEmpty((Collection)provider.getAppType())) {
            for (String appType : provider.getAppType()) {
                this.refactorConfigurationProviders.put(appType, provider);
            }
        }
    }

    public void onUnbind(IRefactorConfigurationBaseProvider provider, Map<?, ?> properties) {
        for (String appType : provider.getAppType()) {
            this.refactorConfigurationProviders.remove(appType);
        }
    }
}

