/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.template;

import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.common.sdk.model.ProcessTask;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefTemplate;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class RecoveryProcessDefTemplateMgr {
    private static Set<String> ultraVREnableProcesses = new HashSet<String>();
    private static final Log logger = LogFactory.getInstance(RecoveryProcessDefTemplateMgr.class);
    private static RecoveryProcessDefTemplateMgr instance = new RecoveryProcessDefTemplateMgr();
    private Map<String, RecoveryProcessDefTemplate> recoveryProcessDefTemplates = new ConcurrentHashMap<String, RecoveryProcessDefTemplate>();
    private Map<String, Set<RecoveryProcessor>> recoveryProcessCache = new ConcurrentHashMap<String, Set<RecoveryProcessor>>();

    private RecoveryProcessDefTemplateMgr() {
    }

    public static RecoveryProcessDefTemplateMgr getInstance() {
        return instance;
    }

    public void registerRecoveryProcessDefTemplates(Set<RecoveryProcessDefTemplate> templates) {
        if (templates == null || templates.isEmpty()) {
            logger.debug((Object)"Templates is null or empty,not register RecoveryProcessDefTemplates.");
            return;
        }
        boolean isUltraVR = BusinessUtil.isUltraVR();
        for (RecoveryProcessDefTemplate template : templates) {
            List processTasks = template.getProcessTasks();
            for (ProcessTask processTask : processTasks) {
                if (!isUltraVR || !ultraVREnableProcesses.contains(processTask.getTaskClass())) continue;
                processTask.setIsEnabled(Boolean.valueOf(true));
            }
            this.recoveryProcessDefTemplates.put(template.getTemplateKey(), template);
        }
    }

    public Set<RecoveryProcessor> createRecoveryProcessors(DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, DrmEnumDefine.RecoveryTargetType recoveryTargetType, int templateType) {
        String templateKey = RecoveryProcessDefTemplate.generateTemplateKey((DrmEnumDefine.AppType)appType, (DrmEnumDefine.RecoveryPlanExecuteTypeE)execType, (int)templateType, (DrmEnumDefine.RecoveryTargetType)recoveryTargetType);
        Set<RecoveryProcessor> recoveryProcessors = this.recoveryProcessCache.get(templateKey);
        if (recoveryProcessors != null && !recoveryProcessors.isEmpty()) {
            return this.cloneRecoveryProcessors(recoveryProcessors);
        }
        RecoveryProcessDefTemplate template = this.recoveryProcessDefTemplates.get(templateKey);
        if (template == null) {
            return new HashSet<RecoveryProcessor>();
        }
        List processTasks = template.getProcessTasks();
        String templateName = template.getName();
        recoveryProcessors = this.createRecoveryProcessors(processTasks, execType, appType, templateType, templateName);
        this.recoveryProcessCache.put(templateKey, recoveryProcessors);
        return this.cloneRecoveryProcessors(recoveryProcessors);
    }

    public Set<RecoveryProcessor> createRecoveryProcessors(DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, int templateType) {
        return this.createRecoveryProcessors(appType, execType, null, templateType);
    }

    private Set<RecoveryProcessor> createRecoveryProcessors(List<ProcessTask> processTasks, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, DrmEnumDefine.AppType appType, int templateType, String templateName) {
        HashSet<RecoveryProcessor> recoveryProcessors = new HashSet<RecoveryProcessor>();
        RecoveryProcessor preRecoveryProcessor = null;
        for (ProcessTask processTask : processTasks) {
            RecoveryProcessor processor = this.createRecoveryProcessor(templateName, processTask);
            Map attributes = processTask.getAttributes();
            String procName = (String)attributes.get("procname");
            if (VerifyUtil.isEmpty((String)procName)) {
                procName = processor.getName();
            }
            processor.setProcName(procName);
            processor.getProps().putAll(attributes);
            processor.setProcType(execType.getValue());
            processor.setIsEnabled(processTask.getIsEnabled());
            processor.setIsEditable(processTask.getIsEditable());
            processor.setIsPreset(Boolean.valueOf(true));
            processor.setPreviousProcessor(preRecoveryProcessor);
            if (preRecoveryProcessor != null) {
                preRecoveryProcessor.setNextProcessor(processor);
            }
            recoveryProcessors.add(processor);
            preRecoveryProcessor = processor;
            if (VerifyUtil.isEmpty((Collection)processTask.getChildProcessTasks())) continue;
            Set<RecoveryProcessor> childProcessors = this.createRecoveryProcessors(processTask.getChildProcessTasks(), execType, appType, templateType, templateName);
            for (RecoveryProcessor childProcessor : childProcessors) {
                childProcessor.setParentProc(processor);
            }
            processor.setChildProc(childProcessors);
        }
        return recoveryProcessors;
    }

    private Set<RecoveryProcessor> cloneRecoveryProcessors(Set<RecoveryProcessor> processors) {
        HashSet<RecoveryProcessor> recoveryProcessors = new HashSet<RecoveryProcessor>();
        if (processors == null || processors.isEmpty()) {
            return recoveryProcessors;
        }
        RecoveryProcessor firstProcessor = this.getFirstRecoveryProcessor(processors);
        if (firstProcessor == null) {
            logger.error((Object)"Does not find the first processor.");
            throw new LegoCheckedException(1073947394L);
        }
        try {
            RecoveryProcessor newPreProcessor = null;
            do {
                RecoveryProcessor newProcessor = (RecoveryProcessor)firstProcessor.clone();
                if (!VerifyUtil.isEmpty((Collection)firstProcessor.getChildProc())) {
                    Set<RecoveryProcessor> newChildProc = this.cloneRecoveryProcessors(firstProcessor.getChildProc());
                    newChildProc.forEach(child -> child.setParentProc(newProcessor));
                    newProcessor.setChildProc(newChildProc);
                }
                newProcessor.setPreviousProcessor(newPreProcessor);
                recoveryProcessors.add(newProcessor);
                if (newPreProcessor != null) {
                    newPreProcessor.setNextProcessor(newProcessor);
                }
                newPreProcessor = newProcessor;
            } while ((firstProcessor = firstProcessor.getNextProcessor()) != null);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Cloning RecoveryProcessors failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            recoveryProcessors.clear();
        }
        return recoveryProcessors;
    }

    private RecoveryProcessor getFirstRecoveryProcessor(Set<RecoveryProcessor> processors) {
        RecoveryProcessor firstProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (null != processor.getPreviousProcessor()) continue;
            firstProcessor = processor;
            break;
        }
        return firstProcessor;
    }

    private RecoveryProcessor createRecoveryProcessor(String processName, ProcessTask processTask) {
        RecoveryProcessor processor = null;
        try {
            ClassLoader clsLoader = DrmObjectSerializableUtil.getGlobalClassLoader();
            processor = (RecoveryProcessor)Class.forName(processTask.getTaskClass(), true, clsLoader).newInstance();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Creating recovery processor failed. Name:" + processName + ", Class:" + processTask.getTaskClass()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return processor;
    }

    public String getVersion(DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, DrmEnumDefine.RecoveryTargetType recoveryTargetType, int templateType) {
        String templateKey = RecoveryProcessDefTemplate.generateTemplateKey((DrmEnumDefine.AppType)appType, (DrmEnumDefine.RecoveryPlanExecuteTypeE)execType, (int)templateType, (DrmEnumDefine.RecoveryTargetType)recoveryTargetType);
        RecoveryProcessDefTemplate template = this.recoveryProcessDefTemplates.get(templateKey);
        if (template == null) {
            logger.error((Object)"recoveryProcessDefTemplate is null.");
            return null;
        }
        Map processKeys = template.getProcessKeys();
        return (String)processKeys.get("version");
    }

    static {
        ultraVREnableProcesses.add("com.huawei.ism.drm.galax.recovery.process.ConfigureVmRecoveryProcessor");
    }
}

