/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.morphological.sdk.service.IMorphologicalInfoService;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;

public class RecoveryMorphologicalInfoUtil {
    private static final Log LOGGER = LogFactory.getInstance(RecoveryMorphologicalInfoUtil.class);
    private static final String BCM_MORPHOLOGICAL_INFO_KEY = "BCM_MORPHOLOGICAL";

    public static void buildAndAddToContextParams(RecoveryProcessorContext context, int procType) {
        if (procType != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() && procType != DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            LOGGER.info((Object)"Not match the planed migration or fault recovery.");
            return;
        }
        try {
            if (context.getProtectGroup().getPoType() != 11) {
                return;
            }
            RecoveryProcessBaseUtil.addContextParam(context, BCM_MORPHOLOGICAL_INFO_KEY, RecoveryMorphologicalInfoUtil.buildMorphologicalInfo(context));
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Failed to build morphological info. error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to build morphological info. error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1677929530L);
        }
    }

    private static String buildMorphologicalInfo(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks", Collection.class);
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.error((Object)"RecoveryTasks is empty.");
            throw new LegoCheckedException(1677929530L);
        }
        IMorphologicalInfoService morphologicalInfoService = (IMorphologicalInfoService)ServiceLocator.getInstance().getService(IMorphologicalInfoService.class);
        return morphologicalInfoService.getMorphologicalInfo(context).getMorphologicalInfo();
    }
}

