/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.checker.manager.RecoveryProcessCheckerManager;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RecoveryProcessBaseUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessBaseUtil.class);
    private static final String ALL_RELATED_REPLICATION_PAIRS = "all-related-replication-pairs";
    private static final String STANDBY = "standby";

    public static String generateLunAndHostMapKey(RemoteStorageReplica remoteStorageReplica) {
        if (VerifyUtil.isEmpty((Object)remoteStorageReplica)) {
            logger.debug((Object)"The param is null.");
            return "";
        }
        String replicationId = remoteStorageReplica.getReplicationPairId();
        if (!VerifyUtil.isEmpty((String)remoteStorageReplica.getConsistentGroupId()) && !remoteStorageReplica.getConsistentGroupId().equals("--")) {
            replicationId = remoteStorageReplica.getConsistentGroupId();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(replicationId);
        builder.append(":");
        builder.append(remoteStorageReplica.getSrcStorageProviderSN());
        builder.append(":");
        builder.append(remoteStorageReplica.getSrcStorageId());
        builder.append(":");
        builder.append(remoteStorageReplica.getStorageProviderSN());
        builder.append(":");
        builder.append(remoteStorageReplica.getStorageId());
        return builder.toString();
    }

    public static String generateLunAndHostMapKey(String replicationId, String srcProviderSn, String srcStorageId, String providerSn, String storageId) {
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcProviderSn) || VerifyUtil.isEmpty((String)srcStorageId)) {
            logger.debug((Object)"The param replicationId or srcProviderSn or srcStorageId is null.");
            return "";
        }
        if (VerifyUtil.isEmpty((String)providerSn) || VerifyUtil.isEmpty((String)storageId)) {
            logger.debug((Object)"The param providerSn or storageId is null.");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(replicationId);
        builder.append(":");
        builder.append(srcProviderSn);
        builder.append(":");
        builder.append(srcStorageId);
        builder.append(":");
        builder.append(providerSn);
        builder.append(":");
        builder.append(storageId);
        return builder.toString();
    }

    public static String getSrcLunIdFromLunAndHostMapKey(String lunAndHostMapKey) {
        if (VerifyUtil.isEmpty((String)lunAndHostMapKey)) {
            logger.debug((Object)"The param lunAndHostMapKey is empty.");
            return "";
        }
        String[] strArray = lunAndHostMapKey.split(":");
        if (strArray.length < 3) {
            return "";
        }
        return strArray[2];
    }

    public static String getLunIdFromLunAndHostMapKey(String lunAndHostMapKey) {
        if (VerifyUtil.isEmpty((String)lunAndHostMapKey)) {
            logger.debug((Object)"The param lunAndHostMapKey is null.");
            return "";
        }
        String[] strArray = lunAndHostMapKey.split(":");
        if (strArray.length < 5) {
            return "";
        }
        return strArray[4];
    }

    public static String getHostOrGroupIds(List<String> hostOrGroupIds) {
        if (VerifyUtil.isEmpty(hostOrGroupIds)) {
            logger.debug((Object)"The param hostOrGroupIds is null.");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String hostMoId : hostOrGroupIds) {
            builder.append(hostMoId);
            if (++index >= hostOrGroupIds.size()) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static List<String> getHostOrGroupIds(String hostOrGroupIds) {
        ArrayList<String> hostOrGroupIdList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)hostOrGroupIds)) {
            logger.debug((Object)"The param hostOrGroupIds is null.");
            return hostOrGroupIdList;
        }
        String[] strArray = hostOrGroupIds.split(":");
        hostOrGroupIdList.addAll(Arrays.asList(strArray));
        return hostOrGroupIdList;
    }

    public static List<Long> getHostMoIds(String hostMoIds) {
        String[] strArray;
        ArrayList<Long> hostMoIdList = new ArrayList<Long>();
        if (VerifyUtil.isEmpty((String)hostMoIds)) {
            logger.debug((Object)"The param hostMoIds is null");
            return hostMoIdList;
        }
        for (String str : strArray = hostMoIds.split(":")) {
            hostMoIdList.add(NumberUtil.convertToLong((Object)str));
        }
        return hostMoIdList;
    }

    public static String getPoIds(List<String> poIds) {
        if (VerifyUtil.isEmpty(poIds)) {
            logger.debug((Object)"The param poIds is empty");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String poId : poIds) {
            builder.append(poId);
            if (++index >= poIds.size()) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static List<String> getPoIds(String poIds) {
        ArrayList<String> poIdList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)poIds)) {
            logger.debug((Object)"The param poIds is empty.");
            return poIdList;
        }
        String[] strArray = poIds.split(":");
        poIdList.addAll(Arrays.asList(strArray));
        return poIdList;
    }

    public static String[] getProtectGroupIds(Set<ProtectGroup> pgs) {
        if (VerifyUtil.isEmpty(pgs)) {
            logger.debug((Object)"The param pgs is empty.");
            return new String[0];
        }
        String[] results = new String[pgs.size()];
        int index = 0;
        for (ProtectGroup pg : pgs) {
            results[index++] = pg.getUuid();
        }
        return results;
    }

    public static boolean isConsistentGroup(RemoteStorageReplica remoteStorageReplica) {
        String consistentGroupId = remoteStorageReplica.getConsistentGroupId();
        boolean isConsistentGroup = false;
        if (consistentGroupId != null && 0 < consistentGroupId.length() && !"--".equals(consistentGroupId)) {
            isConsistentGroup = true;
        }
        return isConsistentGroup;
    }

    public static boolean isVstorePair(RemoteStorageReplica remoteStorageReplica) {
        String vstorePairId = remoteStorageReplica.getVstorePairId();
        return !VerifyUtil.isEmpty((String)vstorePairId) && !vstorePairId.startsWith("--");
    }

    public static RecoveryProcessor getValidPreviousProcessor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessor preProcessor;
        if (recoveryProcessor == null) {
            logger.debug((Object)"The param recoveryProcessor is null.");
            return null;
        }
        for (preProcessor = recoveryProcessor.getPreviousProcessor(); preProcessor != null && !preProcessor.getIsEnabled().booleanValue(); preProcessor = preProcessor.getPreviousProcessor()) {
        }
        return preProcessor;
    }

    public static RecoveryProcessor getValidNextProcessor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessor nextProcessor;
        if (recoveryProcessor == null) {
            logger.debug((Object)"The param recoveryProcessor is null.");
            return null;
        }
        for (nextProcessor = recoveryProcessor.getNextProcessor(); nextProcessor != null && !nextProcessor.getIsEnabled().booleanValue(); nextProcessor = nextProcessor.getNextProcessor()) {
        }
        return nextProcessor;
    }

    public static String constructParamsString(String[] params) {
        JSONArray jsonArray = new JSONArray();
        if (params == null) {
            logger.debug((Object)"the param is null");
            return "";
        }
        jsonArray.addAll(Arrays.asList(params));
        return jsonArray.toString();
    }

    public static void addContextParam(RecoveryProcessorContext context, String key, String value) {
        if (context == null) {
            logger.error((Object)"Save context param failed, context is null, key: %s,value:%s.", new Object[]{key, value});
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (contextParams == null) {
            contextParams = new JSONObject();
        }
        String valueStr = "";
        if (contextParams.size() != 0 && contextParams.containsKey((Object)key) && !VerifyUtil.isEmpty((String)(valueStr = (String)contextParams.get(key)))) {
            valueStr = valueStr + ",";
        }
        contextParams.put((Object)key, (Object)(valueStr + value));
        context.setAttribute("ContextParams", (Object)contextParams.toString());
        logger.info((Object)"Saved key: %s, value: %s to context param.", new Object[]{key, value});
    }

    public static void removeContextParamByKey(RecoveryProcessorContext context, String key) {
        if (context == null) {
            logger.error((Object)"Delete context param failed, context is null, key: %s.", new Object[]{key});
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (contextParams != null) {
            contextParams.remove((Object)key);
            context.setAttribute("ContextParams", (Object)contextParams.toString());
        }
        logger.info((Object)"Deleted key: %s from context param.", new Object[]{key});
    }

    public static String getContextParamByKey(RecoveryProcessorContext context, String key) {
        if (context == null) {
            logger.error((Object)"delete context param failed, context is null, key: %s.", new Object[]{key});
            return null;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        return (String)contextParams.get(key);
    }

    public static List<ProtectGroupReplica> getAllReplicaById(RecoveryPlan recoveryPlan, String replicaId) {
        ArrayList<ProtectGroupReplica> pgReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            for (ProtectGroupReplica pgReplica : protectGroup.getReplicaList()) {
                if (!replicaId.equals(pgReplica.getId())) continue;
                if (DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue() != pgReplica.getStatus()) {
                    logger.error((Object)"Invalid ProtectGroupReplica status.");
                    return new ArrayList<ProtectGroupReplica>();
                }
                pgReplicas.add(pgReplica);
            }
        }
        return pgReplicas;
    }

    public static Map<String, Object> convertSettingType(Map<String, String> globalSettings) {
        if (VerifyUtil.isEmpty(globalSettings)) {
            logger.debug((Object)"The param globalSettings is null.");
            return null;
        }
        HashMap<String, Object> convertedSettings = new HashMap<String, Object>();
        Set<Map.Entry<String, String>> settingsEntrySet = globalSettings.entrySet();
        for (Map.Entry<String, String> entry : settingsEntrySet) {
            convertedSettings.put(entry.getKey(), entry.getValue());
        }
        return convertedSettings;
    }

    public static boolean changeProtectGroupStatus(String[] pgIds, DrmEnumDefine.ProtectGroupStatus pgStatus) {
        boolean result = false;
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        try {
            pgService.updateProtectGroupStatus(pgStatus, pgIds);
            result = true;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Setting protect groups status failed. Ids:%s,error is %s.", new Object[]{StringUtil.arrayToString((Object[])pgIds), ExceptionUtil.getErrorMessage((Throwable)le)});
        }
        logger.info((Object)"Set protect groups status. Result:%sPg:%s,pgStatus:%s", new Object[]{result, StringUtil.arrayToString((Object[])pgIds), pgStatus.getStatus()});
        return result;
    }

    public static void presetCheck(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryProcessCheckerManager rpCheckerMgr = RecoveryProcessCheckerManager.getInstance();
        List<IRecoveryProcessChecker> recoveryProcessCheckers = rpCheckerMgr.getRecoveryProcessCheckers();
        if (VerifyUtil.isEmpty(recoveryProcessCheckers)) {
            logger.error((Object)"There is no recovery process checkers.");
            throw new LegoCheckedException(1073947394L);
        }
        recoveryProcessCheckers.sort((o1, o2) -> o2.priority() - o1.priority());
        for (IRecoveryProcessChecker checker : recoveryProcessCheckers) {
            checker.check(context, procType);
        }
    }

    public static String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        logger.debug((Object)"enter getDisterSiteId");
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        ProtectGroupReplica rep = recoveryProcessService.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (rep != null) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    public static ProtectGroupReplica getProtectGroupReplicaByReplicaId(ProtectGroup protectGroup, String replicaId) {
        if (protectGroup == null || VerifyUtil.isEmpty((String)replicaId)) {
            return null;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        if (pgReplicas == null) {
            return null;
        }
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (!pgReplica.getId().equals(replicaId)) continue;
            return pgReplica;
        }
        return null;
    }

    public static Set<ProtectObject> getRecoveryProtectObjects(ProtectGroup protectGroup, ProtectGroupReplica pgReplica, DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)pgReplica)) {
            return new HashSet<ProtectObject>();
        }
        HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE> remoteExecuteTypeSet = new HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE>();
        remoteExecuteTypeSet.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
        remoteExecuteTypeSet.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
        remoteExecuteTypeSet.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
        remoteExecuteTypeSet.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
        remoteExecuteTypeSet.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION);
        remoteExecuteTypeSet.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT);
        HashSet<ProtectObject> result = new HashSet<ProtectObject>();
        ExecuteReplicaManager mgr = ExecuteReplicaManager.getInstance();
        if (mgr.getRealTimeReplicaPolicyType().contains(protectGroup.getTemplate().getType())) {
            if (rpExecuteType != null && remoteExecuteTypeSet.contains(rpExecuteType)) {
                result.addAll(protectGroup.getPolist());
            } else {
                Set<ProtectObjectReplica> poReplicas = RecoveryProcessBaseUtil.getProtectObjectReplicas(pgReplica);
                for (ProtectObjectReplica poReplica : poReplicas) {
                    result.add(poReplica.getProtectObject());
                }
            }
        } else {
            result.addAll(protectGroup.getPolist());
        }
        return result;
    }

    private static Set<ProtectObjectReplica> getProtectObjectReplicas(ProtectGroupReplica pgReplica) {
        Set<ProtectObjectReplica> poReplicas;
        block3: {
            poReplicas = new HashSet();
            try {
                Iterator iterator;
                poReplicas = pgReplica.getReplicas();
                if (poReplicas != null && !(iterator = poReplicas.iterator()).hasNext()) {
                    throw new LegoCheckedException(1073947394L);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Getting po replicas from pg replica failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                IReplicaBaseService replicaService = (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
                ProtectGroupReplica newPgReplica = replicaService.queryProtectGroupReplicaById(pgReplica.getId());
                if (newPgReplica == null) break block3;
                poReplicas = newPgReplica.getReplicas();
            }
        }
        return poReplicas;
    }

    public static Collection<RecoveryTask> filterRecoveryTask(RecoveryProcessorContext context, String recoveryTasksKey) {
        RecoveryProcessBaseUtil.checkContext(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        RecoveryProcessBaseUtil.checkRecoveryPlan(recoveryPlan);
        Iterator<ProtectGroup> iterator = recoveryPlan.getProtectGroups().iterator();
        RecoveryProcessBaseUtil.checkProtectGroup(iterator);
        Collection candidates = (Collection)context.getAttribute(recoveryTasksKey);
        boolean ring = candidates.stream().anyMatch(task -> Objects.nonNull(task.getParams()) && task.getParams().containsKey(STANDBY));
        if (ring) {
            return RecoveryProcessBaseUtil.getNormalReplicationTask(candidates);
        }
        return candidates;
    }

    private static Collection<RecoveryTask> getNormalReplicationTask(Collection<RecoveryTask> candidates) {
        ArrayList<RecoveryTask> recoverTasks = new ArrayList<RecoveryTask>();
        if (VerifyUtil.isEmpty(candidates)) {
            return recoverTasks;
        }
        for (RecoveryTask recoveryTask : candidates) {
            Map params = recoveryTask.getParams();
            if (params == null) {
                recoverTasks.add(recoveryTask);
                continue;
            }
            Object allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS);
            if (!Collection.class.isInstance(allRelatedReplicationPairs)) {
                return recoverTasks;
            }
            Collection collection = (Collection)Collection.class.cast(allRelatedReplicationPairs);
            RecoveryProcessBaseUtil.checkPairStatusConsistentByRingId(collection);
            if (((Boolean)params.get(STANDBY)).booleanValue()) continue;
            recoverTasks.add(recoveryTask);
        }
        return recoverTasks;
    }

    private static void checkPairStatusConsistentByRingId(Collection<?> collection) {
    }

    private static void checkProtectGroup(Iterator<ProtectGroup> iterator) {
        if (!iterator.hasNext()) {
            logger.error((Object)"iterator is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The recoveryPlan is null");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkContext(RecoveryProcessorContext context) {
        if (context == null) {
            logger.error((Object)"The context is null");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        ProtectObjectStorageInfo storageInfo;
        logger.debug((Object)"enter isProtectGroupUseNasFileSystem ");
        boolean isNas = false;
        if (pg.getTemplate().getType() == 1 && pg.getTemplate().getSubType() == 2) {
            isNas = true;
        }
        if (!(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue() != pg.getTemplate().getType() && PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO.getValue() != pg.getTemplate().getType() || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)(storageInfo = pg.getAnyProtectObjectStorageInfo())) || DrmEnumDefine.ResourceTypeE.NAS.getValue() != storageInfo.getResourceType().intValue())) {
            isNas = true;
        }
        if (14 == pg.getTemplate().getType() || 17 == pg.getTemplate().getType() || 28 == pg.getTemplate().getType()) {
            isNas = true;
        }
        return isNas;
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Site remoteSite, Collection<RecoveryTask> recoveryTasks) {
        RecoveryPlan plan = context.getRecoveryPlan();
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<Integer> hyperMetreTypeSet = new HashSet<Integer>(Arrays.asList(18, 23, 31, 36, 35));
        PolicyTemplate template = ((ProtectGroup)iterator.next()).getTemplate();
        if (template != null && hyperMetreTypeSet.contains(template.getType())) {
            if (context.getProtectGroup() == null) {
                logger.error((Object)"The protectgroup in context is empty!");
                throw new LegoCheckedException(1073947394L);
            }
            return RecoveryProcessBaseUtil.checkHyperMetroSrcLunUnMapping(remoteSite, context.getProtectGroup().getPolist());
        }
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (RecoveryTask rt : recoveryTasks) {
            Map lunAndHostMap = rt.getLunAndHostMap();
            Map resourceAndTypeMap = rt.getResourceAndTypeMap();
            String srcDevId = rt.getSrcDeviceId();
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(srcDevId);
            if (srcLunIds == null) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(srcDevId, srcLunIds);
            }
            for (String key : lunAndHostMap.keySet()) {
                if (DrmEnumDefine.AppType.NAS_FILESYSTEM.getValue() == ((Integer)resourceAndTypeMap.get(key)).intValue()) continue;
                String srcLunId = RecoveryProcessBaseUtil.getSrcLunIdFromLunAndHostMapKey(key);
                srcLunIds.add(srcLunId);
            }
        }
        return RecoveryProcessBaseUtil.isSrcLunsUnMapping(remoteSite, devAndLunMap);
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Collection<RecoveryTask> recoveryTasks) {
        if (recoveryTasks == null) {
            throw new LegoCheckedException(-1L);
        }
        Map<String, Set<String>> devLunMap = RecoveryProcessBaseUtil.getReplicaSourceMap(context);
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(devLunMap)) {
            return RecoveryProcessBaseUtil.isReplicaSourceUnMapping(devLunMap);
        }
        HashSet<String> devSns = new HashSet<String>();
        HashSet<String> srcLunIds = new HashSet<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            devSns.add(recoveryTask.getSrcDeviceId());
            Set srcStorageIds = recoveryTask.getSrcStorageIds();
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)srcStorageIds)) {
                logger.debug((Object)"the param is null");
                continue;
            }
            Iterator iterator = srcStorageIds.iterator();
            if (!iterator.hasNext()) continue;
            String srcLunId = (String)iterator.next();
            srcLunIds.add(srcLunId);
        }
        if (devSns.isEmpty() || devSns.size() > 1) {
            logger.error((Object)"Error: the source device amount:%s", new Object[]{String.valueOf(devSns.size())});
            throw new LegoCheckedException(-1L);
        }
        String srcDevSn = (String)CommonUtil.getFirstElement(devSns);
        ArrayList<String> lunIds = new ArrayList<String>(srcLunIds);
        return RecoveryProcessBaseUtil.isSrcLunUnMapping(srcDevSn, lunIds);
    }

    private static boolean isReplicaSourceUnMapping(Map<String, Set<String>> devLunMap) {
        for (Map.Entry<String, Set<String>> entry : devLunMap.entrySet()) {
            ArrayList<String> lunIds;
            String srcDevSn = entry.getKey();
            if (RecoveryProcessBaseUtil.isSrcLunUnMapping(srcDevSn, lunIds = new ArrayList<String>((Collection)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Set<String>> getReplicaSourceMap(RecoveryProcessorContext context) {
        HashMap<String, Set<String>> devLunMap = new HashMap<String, Set<String>>();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)context)) {
            return devLunMap;
        }
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            return devLunMap;
        }
        Set replicas = protectGroupReplica.getReplicas();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)replicas)) {
            return devLunMap;
        }
        HashSet<String> lunWwnSet = new HashSet<String>();
        RecoveryProcessBaseUtil.extracted(devLunMap, replicas, lunWwnSet);
        for (Map.Entry entry : devLunMap.entrySet()) {
            if (((Set)entry.getValue()).size() == lunWwnSet.size()) continue;
            logger.error((Object)"storageInfos.size=%s not equal lunIdSet.size=%s.", new Object[]{String.valueOf(lunWwnSet.size()), entry.getValue()});
            return new HashMap<String, Set<String>>();
        }
        return devLunMap;
    }

    private static void extracted(Map<String, Set<String>> devLunMap, Set<ProtectObjectReplica> replicas, Set<String> lunWwnSet) {
        for (ProtectObjectReplica replica : replicas) {
            Set storageInfos = replica.getStorageInfos();
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            for (RelicaStorageInfo storageInfo : storageInfos) {
                String lunWwn = storageInfo.getProtectObjectStorageWwn();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)lunWwn)) {
                    logger.warn((Object)"empty lunWwn,SrcStorageId=%s.", new Object[]{storageInfo.getSrcStorageId()});
                    continue;
                }
                lunWwnSet.add(lunWwn);
                List resources = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageResourceByWwn(new String[]{lunWwn});
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)resources)) {
                    logger.error((Object)"resources null,lunWwn=%s.", new Object[]{lunWwn});
                    continue;
                }
                for (StorageResource resource : resources) {
                    String devSn = resource.getDevSn();
                    String lunId = resource.getResourceId();
                    Set<String> lunIdSet = devLunMap.get(devSn);
                    if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunIdSet)) {
                        lunIdSet = new HashSet<String>();
                        devLunMap.put(devSn, lunIdSet);
                    }
                    lunIdSet.add(lunId);
                }
            }
        }
    }

    private static boolean isSrcLunsUnMapping(Site remoteSite, Map<String, Set<String>> devAndLunMap) {
        boolean isSrcLunUnMap = false;
        for (Map.Entry<String, Set<String>> entry : devAndLunMap.entrySet()) {
            ArrayList<String> srcLunIds;
            String devId = entry.getKey();
            isSrcLunUnMap = RecoveryProcessBaseUtil.isSrcLunUnMapping(remoteSite, devId, srcLunIds = new ArrayList<String>((Collection)entry.getValue()));
            if (isSrcLunUnMap) continue;
            return false;
        }
        return isSrcLunUnMap;
    }

    private static boolean isSrcLunUnMapping(String srcDeviceId, List<String> lunIds) {
        try {
            List luns = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).queryLunByDevSnAndLunIds(srcDeviceId, lunIds);
            return RecoveryProcessBaseUtil.isLunUnMapping(lunIds, luns);
        }
        catch (Exception e) {
            logger.error((Object)"query SrcLunUnMapping Local error,srcDeviceId:%s,lunIds:%s,error is %s.", new Object[]{srcDeviceId, lunIds, ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }

    public static boolean isSrcLunUnMapping(Site remoteSite, String srcDeviceId, List<String> srcLunIds) {
        if (remoteSite == null || srcDeviceId == null || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(srcLunIds)) {
            logger.error((Object)"Invalid parameters. srcDeviceId: %s,srcLunIds:%s.", new Object[]{srcDeviceId, srcLunIds});
            throw new LegoCheckedException(1073947393L);
        }
        if (remoteSite.getSiteType() == 0) {
            return RecoveryProcessBaseUtil.isSrcLunUnMapping(srcDeviceId, srcLunIds);
        }
        try {
            Object[] lunIdArray = new String[srcLunIds.size()];
            srcLunIds.toArray(lunIdArray);
            String lunIds = StringUtil.arrayToStrWithSplit((Object[])lunIdArray, (String)";");
            RestClient client = SiteUtil.initClient(remoteSite);
            HashMap<String, Object> srcUriVariabels = new HashMap<String, Object>();
            srcUriVariabels.put("devSn", srcDeviceId);
            srcUriVariabels.put("lunIds", lunIds);
            srcUriVariabels.put("isFromDevice", true);
            List luns = client.getForObjects("/ws/storages/{devSn}/luns/action/getBatchByLunIds?lunIds={lunIds}&isFromDevice={isFromDevice}", srcUriVariabels, Lun.class);
            return RecoveryProcessBaseUtil.isLunUnMapping(srcLunIds, luns);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("query SrcLunUnMapping Remote error:" + srcDeviceId + "-" + srcLunIds), (long)1073948695L, (String[])new String[0], (Log)logger);
            return false;
        }
    }

    private static boolean isLunUnMapping(List<String> lunIds, List<Lun> luns) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(luns)) {
            logger.error((Object)"LUNs quered is empty, return isLunUnMapping is false.");
            return false;
        }
        if (luns.size() != lunIds.size()) {
            logger.error((Object)"LUNs quered is not equals to the lunID amount, return isLunUnMapping is false.");
            return false;
        }
        for (Lun lun : luns) {
            boolean isMapped = lun.getMapped();
            if (!isMapped) continue;
            logger.error((Object)"The lun is mapped, and ID: %s,name:%s.", new Object[]{lun.getLunId(), lun.getName()});
            return false;
        }
        return true;
    }

    private static boolean checkHyperMetroSrcLunUnMapping(Site productionSite, Set<ProtectObject> protectObjects) {
        Set<String> lunWwnSet = RecoveryProcessBaseUtil.getAllWwn(protectObjects);
        ArrayList<String> wwnList = new ArrayList<String>(lunWwnSet);
        List<Lun> lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(productionSite.getServerUuid(), wwnList, Lun.class);
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (Lun lun : lunList) {
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(lun.getDevSn());
            if (srcLunIds == null) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(lun.getDevSn(), srcLunIds);
            }
            srcLunIds.add(lun.getLunId());
        }
        return RecoveryProcessBaseUtil.isSrcLunsUnMapping(productionSite, devAndLunMap);
    }

    public static Set<String> getAllWwn(Set<ProtectObject> protectObjects) {
        HashSet<String> allWwn = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)"PolicyTemplate check protectObject storageInfo is empty, po uuid is:%s,name is %s.", new Object[]{po.getUuid(), po.getName()});
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String lunWwn = Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()).equals(posi.getResourceType()) ? posi.getResourceId() : posi.getLunWWN();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)lunWwn)) {
                    logger.error((Object)"lunWWN is empty, po uuid is:%s,name is %s.", new Object[]{po.getUuid(), po.getName()});
                    throw new LegoCheckedException(1073948453L);
                }
                allWwn.add(lunWwn);
            }
        }
        return allWwn;
    }
}

