/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.sdk.service.IScopeManager;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ScopeManagerUtil {
    private static IScopeManager scopeManager;

    private ScopeManagerUtil(IScopeManager manager) {
        ScopeManagerUtil.setScopeManagerField(manager);
    }

    public static <T extends ManagedObject> List<T> filterManagedObjectByScope(List<String> sns, Long userId, Class<T> clazz) {
        QueryCondition condition = new QueryCondition("sn", (Object)sns.toArray());
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        List entities = CommonDAOLocator.getMoDao().findMoBy(clazz, conditions);
        if (VerifyUtil.isEmpty((Collection)entities)) {
            return new ArrayList(0);
        }
        List filterEntities = scopeManager.filterScopedMo(userId.longValue(), entities);
        if (VerifyUtil.isEmpty((Collection)filterEntities)) {
            return new ArrayList(0);
        }
        return filterEntities;
    }

    public static <T extends ManagedObject> List<String> filterSNByScope(List<String> sns, Long userId, Class<T> clazz) {
        QueryCondition condition = new QueryCondition("sn", (Object)sns.toArray());
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        List entities = CommonDAOLocator.getMoDao().findMoBy(clazz, conditions);
        if (VerifyUtil.isEmpty((Collection)entities)) {
            return new ArrayList<String>(0);
        }
        List filterEntities = scopeManager.filterScopedMo(userId.longValue(), entities);
        if (VerifyUtil.isEmpty((Collection)filterEntities)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> filterSns = new ArrayList<String>(filterEntities.size());
        for (ManagedObject obj : filterEntities) {
            if (!(obj instanceof NetworkEntity)) continue;
            NetworkEntity entity = (NetworkEntity)obj;
            filterSns.add(entity.getSn());
        }
        return filterSns;
    }

    public static <T extends ManagedObject> List<T> filterScopedMo(long userId, List<T> moList) {
        return scopeManager.filterScopedMo(userId, moList);
    }

    public static Long[] getUserGrandObjectMoId(long userId, String mainType, String subType) {
        return scopeManager.getUserGrandObjectMoId(userId, mainType, subType);
    }

    public static boolean checkUserGrantedMOObject(Long userId, long moId) {
        return scopeManager.checkUserGrandObject(userId.longValue(), moId);
    }

    private static void setScopeManagerField(IScopeManager scopeManagerField) {
        scopeManager = scopeManagerField;
    }
}

