/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import java.util.HashSet;
import java.util.Set;

public class StorageManagerUtil {
    public static final String STORAGE_V6_VERSION = "V600R000C00";
    private static final Log logger = LogFactory.getInstance(StorageManagerUtil.class);
    private static final Long TV1_SNAPSHOT_NUM_EXCEED_LUN = 50337538L;
    private static final Long XVE_SNAPSHOT_NUM_EXCEED_LUN = 1077937859L;
    private static Set<Long> exceedLimitCodeList = new HashSet<Long>();

    public static final boolean isExceedLimit(long errorCode) {
        logger.info((Object)("errorCode=" + errorCode));
        return exceedLimitCodeList.contains(errorCode);
    }

    public static int versionCompare(String productVersion1, String productionVersion2) {
        return ORBUtility.compareVersion((String)StorageManagerUtil.convertVersion(productVersion1), (String)StorageManagerUtil.convertVersion(productionVersion2));
    }

    private static String convertVersion(String version) {
        return version.replace("R", ".").replace("C", ".");
    }

    static {
        exceedLimitCodeList.add(TV1_SNAPSHOT_NUM_EXCEED_LUN);
        exceedLimitCodeList.add(XVE_SNAPSHOT_NUM_EXCEED_LUN);
    }
}

