/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationBaseManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class StorageReplicationManagerProxy
extends BaseStorageManagerProxy
implements IStorageReplicationBaseManager {
    private static final Log logger = LogFactory.getInstance(StorageReplicationManagerProxy.class);
    private static StorageReplicationManagerProxy instance = new StorageReplicationManagerProxy();
    private Map<String, IStorageReplicationBaseManager> mgrs = new ConcurrentHashMap<String, IStorageReplicationBaseManager>();

    private StorageReplicationManagerProxy() {
    }

    public static StorageReplicationManagerProxy getInstance() {
        return instance;
    }

    public IStorageReplicationBaseManager getStorageReplicationAdapter(String devSn) {
        String storageType = this.getStorageType(devSn);
        IStorageReplicationBaseManager storageReplicationManager = this.mgrs.get(storageType);
        if (storageReplicationManager == null) {
            logger.error((Object)"IStorageReplicationManager is null, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        return storageReplicationManager;
    }

    public Optional<IStorageReplicationBaseManager> getOptionalStorageReplicationAdapter(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.getStorageReplicationAdapter(devSn));
        }
        catch (LegoCheckedException exception) {
            if (exception.getErrorCode() == 2117645L) {
                return Optional.empty();
            }
            throw exception;
        }
    }

    public IStorageReplicationBaseManager getStorageReplicationManager(String storageType) {
        IStorageReplicationBaseManager storageReplicationManager = this.mgrs.get(storageType);
        if (storageReplicationManager == null) {
            logger.error((Object)"IStorageReplicationManager is null, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)storageType)});
            throw new LegoCheckedException(1073947395L);
        }
        return storageReplicationManager;
    }

    public void onBind(IStorageReplicationBaseManager sra, Map<?, ?> properties) {
        if (sra.getStorageType() != null) {
            this.mgrs.put(sra.getStorageType(), sra);
        }
    }

    public void onUnbind(IStorageReplicationBaseManager sra, Map<?, ?> properties) {
        this.mgrs.remove(sra.getStorageType());
    }

    public OperationResult syncOnce(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.syncOnce(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult splitReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.splitReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult switchReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.switchReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult forceSwitchReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getStorageReplicationAdapter(targetArrayId);
        return sra.forceSwitchReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.querySyncStatus(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult setSecondaryLunReadWrite(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.setSecondaryLunReadWrite(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult reverseReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationBaseManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.reverseReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult setLunWriteProtection(String commandDevSn, String replicationId, boolean isConsistentGroup, int secResAccess) {
        IStorageReplicationBaseManager sra = this.getStorageReplicationAdapter(commandDevSn);
        return sra.setLunWriteProtection(commandDevSn, replicationId, isConsistentGroup, secResAccess);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String lunId) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryReplications(deviceSn, lunId);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryReplications(deviceSn, resources);
    }

    public String getStorageType() {
        return null;
    }

    public List<String> supportedDeviceList() {
        return null;
    }

    private IStorageReplicationBaseManager getReplicationManagerInternal(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        boolean isSourceEmpty = VerifyUtil.isEmpty((String)sourceArrayId);
        boolean isTargetEmpty = VerifyUtil.isEmpty((String)targetArrayId);
        if (isSourceEmpty && isTargetEmpty) {
            logger.error((Object)"Both ends of pair are empty, replicationId: %s", new Object[]{replicationId});
            throw new LegoCheckedException(1073947393L, new String[]{replicationId});
        }
        IStorageReplicationBaseManager sourceManager = this.getOptionalStorageReplicationAdapter(sourceArrayId).orElse(null);
        IStorageReplicationBaseManager targetManager = this.getOptionalStorageReplicationAdapter(targetArrayId).orElse(null);
        if (isSourceEmpty != isTargetEmpty) {
            return sourceManager != null ? sourceManager : targetManager;
        }
        if (sourceManager == targetManager) {
            return sourceManager;
        }
        ReplicationRelation relation = this.getReplicationInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sourceArrayId.equals(relation.getDevSn()) ? sourceManager : targetManager;
    }

    private ReplicationRelation getReplicationInternal(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (relation == null) {
            logger.error((Object)"Replication does not exist. SrcDevId:%s, TgtDevId:%s, replicationId:%s, isConsistentGroup:%s.", new Object[]{sourceArrayId, targetArrayId, replicationId, isConsistentGroup});
            if (isConsistentGroup) {
                throw new LegoCheckedException(1073948767L, new String[]{replicationId});
            }
            throw new LegoCheckedException(1073948677L, new String[]{replicationId});
        }
        return relation;
    }

    public void changeRate(String sn, String id, boolean isCg, DmEnumDefine.SpeedLevelE rate) {
        this.getStorageReplicationAdapter(sn).changeRate(sn, id, isCg, rate);
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        IStorageReplicationBaseManager adapter = this.getStorageReplicationAdapter(sn);
        adapter.modify(sn, id, isCg, params);
    }

    public void refresh(String sn, List<String> ids, boolean isCg) {
        IStorageReplicationBaseManager adapter = this.getStorageReplicationAdapter(sn);
        adapter.refresh(sn, ids, isCg);
    }

    public ReplicationPair createReplicationPair(ReplicationPair pair) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(pair.getSrcDevSN());
        return manager.createReplicationPair(pair);
    }

    public ReplicationGroup addReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        return manager.addReplicationPair(group, pairList);
    }

    public void deleteReplicationPair(ReplicationPair pair) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(pair.getSrcDevSN());
        manager.deleteReplicationPair(pair);
    }

    public ReplicationGroup createReplicationGroup(ReplicationGroup group) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        return manager.createReplicationGroup(group);
    }

    public void deleteReplicationGroup(ReplicationGroup group) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        manager.deleteReplicationGroup(group);
    }

    public void removeReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        manager.removeReplicationPair(group, pairList);
    }

    public ReplicationGroup getReplicationGroup(String devSn, String groupId) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(devSn);
        return manager.getReplicationGroup(devSn, groupId);
    }

    public List<ReplicationPair> getReplicationPair(String devSn, Map<String, String> filter) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(devSn);
        return manager.getReplicationPair(devSn, filter);
    }

    public ReplicationPair getReplicationPair(String devSn, String pairId) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(devSn);
        return manager.getReplicationPair(devSn, pairId);
    }

    public List<ReplicationPair> getAllReplicationPairs(String deviceSn, String vstoreId) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.getAllReplicationPairs(deviceSn, vstoreId);
    }

    public List<ReplicationGroup> getAllReplicationGroups(String deviceSn) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.getAllReplicationGroups(deviceSn);
    }

    public List<ReplicationPair> queryReplicationPairByCgId(String devSn, String cgId) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(devSn);
        return manager.queryReplicationPairByCgId(devSn, cgId);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String lunId, Integer resourceType) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryReplications(deviceSn, lunId, resourceType);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources, Integer resourceType) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryReplications(deviceSn, resources, resourceType);
    }

    public ReplicationRelation queryRealtimeReplication(String deviceSn, String replicationId, boolean isGroup) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryRealtimeReplication(deviceSn, replicationId, isGroup);
    }

    public List<ReplicationGroup> batchQueryReplicationGroup(String devSn, String criteria) {
        IStorageReplicationBaseManager manager = this.getStorageReplicationAdapter(devSn);
        return manager.batchQueryReplicationGroup(devSn, criteria);
    }
}

