/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSystemManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class StorageSystemManagerProxy
extends BaseStorageManagerProxy {
    private static final Log LOGGER = LogFactory.getInstance(StorageSystemManagerProxy.class);
    private static StorageSystemManagerProxy storageSystemManager = new StorageSystemManagerProxy();
    private Map<String, IStorageSystemManager> storageSystemManagers = new HashMap<String, IStorageSystemManager>();

    public static StorageSystemManagerProxy getInstance() {
        return storageSystemManager;
    }

    public void onBind(IStorageSystemManager handler, Map<String, Object> properties) {
        this.storageSystemManagers.put(handler.getStorageType(), handler);
    }

    public void onUnbind(IStorageSystemManager handler, Map<String, Object> properties) {
        this.storageSystemManagers.remove(handler.getStorageType());
    }

    public IStorageSystemManager getStorageLunMgrByDevId(String deviceId) {
        String deviceType = this.getStorageType(deviceId);
        IStorageSystemManager systemManager = this.storageSystemManagers.get(deviceType);
        if (systemManager == null) {
            LOGGER.error((Object)"IStorageSystemManager of deviceId:%s is null.", new Object[]{deviceId});
            throw new LegoCheckedException(-1L);
        }
        return systemManager;
    }
}

