/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.router;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceBaseService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreBaseInfo;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class StorageResourceServiceRouter
extends IsmDrmBaseService {
    private static final Log logger = LogFactory.getInstance(StorageResourceServiceRouter.class);
    private static StorageResourceServiceRouter instance = new StorageResourceServiceRouter();

    private StorageResourceServiceRouter() {
    }

    public static StorageResourceServiceRouter getInstance() {
        return instance;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByIds(String devSn, List<String> resourceIds, Class<T> clazz) {
        logger.debug((Object)("sn=" + devSn + ", resourceIds=" + resourceIds + ", clazz=" + clazz));
        Site site = this.getSiteByDevSn(devSn);
        if (site.getSiteType() == 0) {
            IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            return srService.getStorageResources(devSn, resourceIds, clazz);
        }
        if (site.getSiteType() == 1) {
            return this.getRemoteStorageResources(devSn, resourceIds, site, clazz);
        }
        throw new LegoCheckedException(1073947393L);
    }

    private <T extends StorageResource> List<T> getRemoteStorageResources(String devSn, List<String> resourceIds, Site site, Class<T> clazz) {
        RestClient client = SiteUtil.initClient(site);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String ids = StringUtil.arrayToStrWithSplit((Object[])resourceIds.toArray(new String[resourceIds.size()]), (String)";");
        params.put("devSn", devSn);
        params.put("ids", ids);
        params.put("isFromDevice", false);
        String url = "/ws/storages/{devSn}/storageResource?ids={ids}&isFromDevice={isFromDevice}";
        List resources = client.getForObjects(url, params, clazz);
        return resources;
    }

    private Site getSiteByDevSn(String devSn) {
        ServiceLocator locator = ServiceLocator.getInstance();
        DrResource drResource = ((IResourceService)locator.getService(IResourceService.class)).getDrResourceBySn(devSn, "ism.deviceType.storage.mainType");
        if (drResource == null) {
            logger.error((Object)"DrResource not exist, sn=%s.", new Object[]{devSn});
            throw new LegoCheckedException(1073947394L);
        }
        Site site = ((ISiteBaseService)locator.getService(ISiteBaseService.class)).getSiteById(drResource.getSiteId());
        if (site == null) {
            logger.error((Object)("Site not exist, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(1073947394L);
        }
        return site;
    }

    public List<HyperMetroPair> getHyperMetroPairsByCg(String devSn, String cgId, boolean isRealTime) {
        logger.debug((Object)"Enter getHyperMetroPairsByCg, sn=%s, cgId=%s, isRealTime=%s.", new Object[]{devSn, cgId, isRealTime});
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        Site site = this.getSiteByDevSn(devSn);
        if (site.getSiteType() != 0) {
            logger.error((Object)"current not supported.");
            throw new LegoUnsupportedOperationException("");
        }
        IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
        List list = srService.getHyperMetroPairByConsistentGroup(devSn, cgId, isRealTime);
        logger.debug((Object)"Exit getHyperMetroPairsByCg");
        return list;
    }

    public List<HyperMetroPair> getHyperMetroPairsByFileSystemIds(String serverUuid, String devSn, List<String> fileSystemIds, Boolean isPrimary, boolean isRealTime) {
        logger.debug((Object)"Enter getHyperMetroPairsByFileSystemIds, serverUuid=%s, fileSystemIds=%s, isPrimary=%s, isRealTime=%s.", new Object[]{serverUuid, fileSystemIds, isPrimary, isRealTime});
        if (VerifyUtil.isEmpty(fileSystemIds)) {
            logger.error((Object)"fileSystemIds list is empty.");
            return null;
        }
        ManagementServer server = null;
        if (!VerifyUtil.isEmpty((String)serverUuid)) {
            server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(serverUuid);
        }
        List list = null;
        if (server == null || 0 == server.getServerType()) {
            IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            list = srService.getHyperMetroPairByFileSystems(devSn, fileSystemIds, isPrimary, Boolean.valueOf(isRealTime));
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fileIds", StringUtil.arrayToStrWithSplit((Object[])fileSystemIds.toArray(), (String)";"));
            int roleType = null == isPrimary ? 2 : (isPrimary != false ? 0 : 1);
            params.put("roleType", roleType);
            params.put("devSn", devSn);
            params.put("isRealTime", isRealTime);
            RestClient client = SiteUtil.initClientByServerUuid(serverUuid);
            list = client.getForObjects("/ws/storages/nasHyperMetroPair?fileIds={fileIds}&roleType={roleType}&devSn={devSn}&isRealTime={isRealTime}", params, HyperMetroPair.class);
        }
        logger.debug((Object)"Exit getHyperMetroPairsByWwns");
        return list;
    }

    public List<HyperMetroPair> getHyperMetroPairsByWwns(String serverUuid, List<String> wwns, Boolean isPrimary, boolean isRealTime) {
        return this.getHyperMetroPairsByWwns(serverUuid, wwns, isPrimary, "", isRealTime);
    }

    public List<HyperMetroPair> getHyperMetroPairsByWwns(String serverUuid, List<String> wwns, Boolean isPrimary, String devSn, boolean isRealTime) {
        List list;
        logger.debug((Object)"Enter getHyperMetroPairsByWwns, serverUuid=%s, wwns=%s, isPrimary=%s, isRealTime=%s.", new Object[]{serverUuid, wwns, isPrimary, isRealTime});
        if (VerifyUtil.isEmpty(wwns)) {
            logger.error((Object)"wwn list is empty.");
            return null;
        }
        ManagementServer server = null;
        if (!VerifyUtil.isEmpty((String)serverUuid)) {
            server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(serverUuid);
        }
        if (server == null || 0 == server.getServerType()) {
            IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            list = srService.getHyperMetroPairByWwn(wwns, isPrimary, devSn, isRealTime);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("wwns", StringUtil.arrayToStrWithSplit((Object[])wwns.toArray(), (String)";"));
            int roleType = null == isPrimary ? 2 : (isPrimary != false ? 0 : 1);
            params.put("roleType", roleType);
            params.put("devSn", devSn);
            params.put("isRealTime", isRealTime);
            RestClient client = SiteUtil.initClientByServerUuid(serverUuid);
            list = client.getForObjects("/ws/storages/hyperMetroPair?wwns={wwns}&roleType={roleType}&devSn={devSn}&isRealTime={isRealTime}", params, HyperMetroPair.class);
        }
        logger.debug((Object)"Exit getHyperMetroPairsByWwns");
        return list;
    }

    public HyperMetroConsistentGroup getHyperMetroConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        HyperMetroConsistentGroup group;
        logger.debug((Object)("Enter getHyperMetroConsistentGroup, sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        Site site = this.getSiteByDevSn(devSn);
        if (site.getSiteType() == 0) {
            IStorageResourceBaseService srSvc = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            group = srSvc.getHyperMetroConsistentGroup(devSn, cgId, isRealTime);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("devSn", devSn);
            params.put("cgId", cgId);
            params.put("isRealTime", isRealTime);
            RestClient client = SiteUtil.initClient(site);
            String url = "/ws/storages/{devSn}/hyperMetroConsistentGroup/{cgId}?isRealTime={isRealTime}";
            group = (HyperMetroConsistentGroup)client.getForObject(url, params, HyperMetroConsistentGroup.class);
        }
        logger.debug((Object)"Exit getHyperMetroConsistentGroup");
        return group;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByWwns(String serverUuid, List<String> wwns, Class<T> clazz) {
        List list;
        logger.debug((Object)"Enter getStorageResourcesByWwns, serverUuid=%s, wwns=%s, clazz=%s.", new Object[]{serverUuid, wwns, clazz});
        if (clazz == null) {
            logger.error((Object)"clazz is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(wwns)) {
            logger.info((Object)"wwns is empty.");
            return new ArrayList();
        }
        ManagementServer server = null;
        if (!VerifyUtil.isEmpty((String)serverUuid)) {
            server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(serverUuid);
        }
        if (server == null || server.getServerType() == 0) {
            list = CommonDAOLocator.getMoDao().getMoList(clazz, "wwn", (Object)wwns.toArray());
        } else {
            String wwnStr = StringUtil.arrayToStrWithSplit((Object[])wwns.toArray(), (String)";");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("wwn", wwnStr);
            RestClient client = SiteUtil.initClientByServerUuid(serverUuid);
            list = client.getForObjects("/ws/storages/action/getStorageResourceByWwn?wwn={wwn}", params, clazz);
        }
        logger.debug((Object)"Exit getStorageResourcesByWwns");
        return list;
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairByVstoreId(String devSn, String vstoreId) {
        logger.debug((Object)"Enter getVstoreHyperMetroPairByVstoreId, sn=%s, vstoreId=%s.", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        return this.getVstoreHyperMetroPairById(devSn, vstoreId, true);
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairByVstorePairId(String devSn, String vstorePairId) {
        logger.debug((Object)"Enter getVstoreHyperMetroPairByVstorePairId, sn=%s, vstorePairId=%s.", new Object[]{devSn, vstorePairId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstorePairId});
        return this.getVstoreHyperMetroPairById(devSn, vstorePairId, false);
    }

    private VstoreHyperMetroPair getVstoreHyperMetroPairById(String devSn, String id, Boolean isAssociate) {
        logger.debug((Object)"Enter getVstoreHyperMetroPairByVstoreId, sn=%s, id=%s.", new Object[]{devSn, id});
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        Site site = this.getSiteBySn(devSn);
        ManagementServer server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(site.getServerUuid());
        IStorageResourceBaseService srSvc = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
        if (server == null || 0 == server.getServerType()) {
            return srSvc.getVstoreHyperMetroPairById(devSn, id, isAssociate);
        }
        return srSvc.getVstoreHyperMetroPairByIdFromRemote(site, devSn, id, isAssociate);
    }

    public List<HyperMetroPair> getHyperMetroPairsByVstore(String devSn, String vstoreId) {
        List list;
        logger.debug((Object)"Enter getHyperMetroPairsByVstore, sn=%s, vstoreId=%s.", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        Site site = this.getSiteBySn(devSn);
        ManagementServer server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(site.getServerUuid());
        if (server == null || 0 == server.getServerType()) {
            IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            list = srService.getHyperMetroPairByVstore(devSn, vstoreId);
        } else {
            RestClient client = SiteUtil.initClient(site);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("vstoreId", vstoreId);
            params.put("devSn", devSn);
            list = client.getForObjects("/ws/storages/nasHyperMetroPair?vstoreId={vstoreId}&devSn={devSn}", params, HyperMetroPair.class);
        }
        return list;
    }

    public List<NasFileSystem> getFileSystemByVstore(String devSn, String vstoreId) {
        logger.debug((Object)"Enter getFileSystemByVstore, sn=%s, vstoreId=%s.", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        Site site = this.getSiteBySn(devSn);
        ManagementServer server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(site.getServerUuid());
        if (server == null || 0 == server.getServerType()) {
            IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            return srService.getFileSystemsByVstore(devSn, vstoreId);
        }
        RestClient client = SiteUtil.initClient(site);
        String url = "/ws/storages/{devSn}/filesystem/realtime/{vstoreId}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("devSn", devSn);
        params.put("vstoreId", vstoreId);
        return client.getForObjects(url, params, NasFileSystem.class);
    }

    public List<VstoreHyperMetroPair> getVstoreHyperPair(String serverUuid, VstoreHyperMetroPair vstoreHyperMetroPair) {
        logger.debug((Object)"Enter getVstoreHyperPair, serverUuid=%s.", new Object[]{serverUuid});
        VerifyUtil.checkObject((Object)vstoreHyperMetroPair);
        IStorageResourceBaseService srService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
        return srService.getVstoreHyperPair(serverUuid, vstoreHyperMetroPair.getVstorePairId(), vstoreHyperMetroPair.getLocalVstoreId(), vstoreHyperMetroPair.getRemoteVstoreId());
    }

    public void switchVstoreHyperMetroPair(String devSn, String vstorePairId) {
        logger.debug((Object)"Enter getVstoreHyperMetroPairByVstoreId, sn=%s, vstorePairId=%s.", new Object[]{devSn, vstorePairId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstorePairId});
        Site site = this.getSiteBySn(devSn);
        ManagementServer server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(site.getServerUuid());
        if (server == null || 0 == server.getServerType()) {
            IStorageResourceBaseService srSvc = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
            srSvc.swapVstoreHyperMetroPair(devSn, vstorePairId);
        } else {
            String url = "/ws/storages/{devSn}/vstore_hypermetro_pair/swap/{vstorePairId}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("devSn", devSn);
            params.put("vstorePairId", vstorePairId);
            RestClient client = SiteUtil.initClient(site);
            client.post(url, null, params);
        }
    }

    private Site getSiteBySn(String devSn) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn, "ism.deviceType.storage.mainType");
        if (drResource == null) {
            logger.error((Object)"DrResource is null, sn=%s.", new Object[]{devSn});
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(drResource.getSiteId());
        if (site == null) {
            logger.error((Object)"Site is null, siteId=%s.", new Object[]{drResource.getSiteId()});
            throw new LegoCheckedException(1073947393L);
        }
        return site;
    }

    public List<StorageResource> getNasHyperMetroStoreageList(String devSn, String vstorePairId, List<HyperMetroPair> pairList) {
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)"pairList can not be null!");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> localResourceIds = new HashSet<String>();
        HashSet<String> remoteResourceIds = new HashSet<String>();
        for (HyperMetroPair pair : pairList) {
            remoteResourceIds.add(pair.getRemoteObjId());
            localResourceIds.add(pair.getLocalObjId());
        }
        List<NasFileSystem> localList = this.getStorageResourcesByIds(devSn, new ArrayList<String>(localResourceIds), NasFileSystem.class);
        VstoreHyperMetroPair vstoreHyperMetroPair = this.getVstoreHyperMetroPairByVstorePairId(devSn, vstorePairId);
        Site site = this.getSiteByDevSn(devSn);
        List<VstoreHyperMetroPair> vstoreHyperMetroPairs = this.getVstoreHyperPair(site.getServerUuid(), vstoreHyperMetroPair);
        String remoteDevSn = null;
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit) || devSn.equals(((HvsUnit)managedObject).getDevSn())) continue;
            remoteDevSn = ((HvsUnit)managedObject).getDevSn();
            break;
        }
        if (remoteDevSn == null) {
            logger.error((Object)"can not find remoteDevsn!");
            throw new LegoCheckedException(1073947393L);
        }
        List<NasFileSystem> remoteList = this.getStorageResourcesByIds(remoteDevSn, new ArrayList<String>(remoteResourceIds), NasFileSystem.class);
        ArrayList<StorageResource> result = new ArrayList<StorageResource>();
        result.addAll(localList);
        result.addAll(remoteList);
        return result;
    }

    public VstoreBaseInfo getVstoreById(String devSn, String vstoreId) {
        logger.debug((Object)"Enter getFileSystemByVstore, sn=%s, vstoreId=%s.", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        Site site = this.getSiteBySn(devSn);
        ManagementServer server = ((IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class)).getServer(site.getServerUuid());
        if (server == null || 0 == server.getServerType()) {
            String hql = "from VstoreInfo as vi where vi.vstoreId = ? and vi.devSn = ?";
            List viList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{vstoreId, devSn});
            if (!VerifyUtil.isEmpty((Collection)viList) && viList.size() == 1) {
                return (VstoreBaseInfo)viList.iterator().next();
            }
        } else {
            RestClient client = SiteUtil.initClient(site);
            String url = "/ws/storages/{devSn}/vstore/{vstoreId}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("devSn", devSn);
            params.put("vstoreId", vstoreId);
            return (VstoreBaseInfo)client.getForObject(url, params, VstoreBaseInfo.class);
        }
        return null;
    }
}

