/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.database.CmdUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class GuassDBdumpImpl {
    private static final Log logger = LogFactory.getInstance(GuassDBdumpImpl.class);
    private static final String BACKUP_SCRIPT = "/opt/BCManager/Runtime/bin/backup_config.sh";
    private static final String DUMP_FILE = "/home/ICUser/FCDConfigData.zip";
    private static final String AUTO_BACKUP_PATH_KEY = "autoBackup.path.key";
    protected static final String SALT_FILE = "zip1.tmp";
    protected static final String IV_FILE = "zip2.tmp";
    protected static String exportPath = "";
    protected String destZipFile = "SQLData.zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSaltAndIV(byte[] salt, byte[] iv) {
        String output1 = exportPath + SALT_FILE;
        String output2 = exportPath + IV_FILE;
        FileOutputStream out1 = null;
        FileOutputStream out2 = null;
        try {
            out1 = new FileOutputStream(new File(output1), false);
            ((OutputStream)out1).write(salt);
            out1.flush();
            out2 = new FileOutputStream(new File(output2), false);
            ((OutputStream)out2).write(iv);
            out2.flush();
            this.closeOutStream(out1, out2);
        }
        catch (IOException e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"writeSaltAndIV failed:", (long)0x300001L, (String[])new String[0], (Log)logger);
                this.closeOutStream(out1, out2);
            }
            catch (Throwable throwable) {
                this.closeOutStream(out1, out2);
                throw throwable;
            }
        }
    }

    private void closeOutStream(OutputStream stream1, OutputStream stream2) {
        try {
            if (stream1 != null) {
                stream1.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close error:", 90160758787071L);
        }
        try {
            if (stream2 != null) {
                stream2.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close error:", 90160758787071L);
        }
    }

    public File backup(String encryptPwd, boolean isDataAnonymous) {
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new LegoCheckedException(-1L, "The system property os.name does not exist.");
        }
        return this.backupLinux(encryptPwd, isDataAnonymous);
    }

    public void executeAutoBackup(String pwd, String autoBackupFileName) {
        if (VerifyUtil.isEmpty((String)autoBackupFileName) || !autoBackupFileName.endsWith(".zip")) {
            String errorMsg = String.format(Locale.ROOT, "The format of the automatic backup file name is incorrect, file name: %s.", autoBackupFileName);
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        String autoBackupPath = LegoBaseConfig.getInstance().getKeyValue(AUTO_BACKUP_PATH_KEY, "/home/ICUser/");
        exportPath = autoBackupPath;
        this.destZipFile = autoBackupFileName;
        this.backupLinux(pwd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File backupLinux(String encryptPwd, boolean isDataAnonymous) {
        logger.info((Object)"Linux GAUSS Backup is started. LogCode: %s", new Object[]{String.valueOf(90160758786816L)});
        File targetFile = null;
        File dumpFile = null;
        try {
            String param = "/opt/BCManager/Runtime/bin/backup_config.sh " + isDataAnonymous;
            CmdUtil.runShell(param, new String[]{encryptPwd});
            dumpFile = new File(DUMP_FILE);
            if (!dumpFile.exists() || dumpFile.length() == 0L) {
                throw new LegoCheckedException("Export data failed, source file not found.");
            }
            targetFile = new File(exportPath + this.destZipFile);
            Files.copy(dumpFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!targetFile.exists()) {
                throw new LegoCheckedException("Export data failed, dest file not found.");
            }
            this.deleteTmpFile(dumpFile);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"backupLinux error:", (long)0x300001L, (String[])new String[0], (Log)logger);
            File file = null;
            return file;
        }
        finally {
            this.deleteTmpFile(dumpFile);
        }
        return targetFile;
    }

    private void deleteTmpFile(File delFile) {
        if (delFile == null) {
            return;
        }
        if (delFile.exists() && !delFile.delete()) {
            logger.error((Object)String.format(Locale.ROOT, "Failed to delete temp file: %s", delFile.getName()), 90160758787071L);
        }
    }

    public void writeIVFile(byte[] iv) {
        String ivOutFile = exportPath + IV_FILE;
        try (FileOutputStream ivs = new FileOutputStream(ivOutFile, false);){
            ivs.write(iv);
        }
        catch (IOException e) {
            logger.error((Object)("write IV failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{""});
            ExceptionUtil.rethrowException((Throwable)e, (String)"writeSaltAndIV failed:", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
    }

    static {
        String userDir = System.getProperties().getProperty("user.dir");
        if (userDir == null) {
            throw new LegoCheckedException(1073947393L);
        }
        File legoRuntimeDir = new File(FilenameUtils.normalize((String)userDir));
        try {
            exportPath = legoRuntimeDir.getParentFile().getCanonicalPath() + File.separator + "tmp" + File.separator;
        }
        catch (IOException e) {
            logger.error((Object)"Init path error!", 90160758787071L);
        }
    }
}

