/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.topo.model.po.SnapNode;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractTopoBaseBuilder {
    protected static final double SNAP_LINK_SPLIT_PERCENT = 0.4;
    protected static final String LINK_LAYER_ID = "linkLayer";
    private static Log logger = LogFactory.getInstance(AbstractTopoBaseBuilder.class);
    private static final double GROUP_LOCAL_OUTLINE_CORLOR = 1.447446E7;
    private static final double GROUP_LOCAL_OUTLINE_WIDTH = 1.0;
    private static final double GROUP_LOCAL_FILL_COLOR = 1.6579836E7;
    private static final double PROTECT_OBJ_INNER_TOP_GAP = 11.0;
    private static final double PROTECT_OBJ_INNER_LEFT_GAP = 11.0;
    private static final double PROTECT_OBJ_INNER_SONS_GAP = 11.0;

    protected ITopoResourceManager getTopoResourceManager() {
        return TopoBaseContext.getTopoResourceManager();
    }

    protected String getScheduleTooltips(TopoBaseContext context, ProtectGroup protectGroup, int protectLocation) {
        String scheduleInfo = "";
        String ptId = protectGroup.getTemplate().getUuid();
        PolicyTemplate pt = context.getPolicyTemplateManager().getPtByUuid(ptId);
        if (!VerifyUtil.isEmpty((Object)pt)) {
            Set schedules = context.getPolicyTemplateManager().getPtByUuid(protectGroup.getTemplate().getUuid()).getSchedules();
            Schedule result = TopoServiceUtil.getSchedule(protectLocation, schedules, protectGroup);
            scheduleInfo = TooltipUtil.getScheduleInfo(result);
        } else {
            logger.error((Object)("getPtByUuid failed, PtUUID: " + ptId), 1073947393L);
        }
        return scheduleInfo;
    }

    protected void buildSnapReplicaTopo(TopoBaseContext context, Node siteNode, String scheduleInfo, Node protectGroupNode, List<ProtectGroupReplica> protectGroupReplicaList) {
        if (VerifyUtil.isEmpty(protectGroupReplicaList)) {
            logger.debug((Object)"protectGroupReplicaList is null");
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox box = context.getElementBox();
        Collections.sort(protectGroupReplicaList, new CommonComparator("timeStamp", false));
        for (ProtectGroupReplica protectGroupReplica : protectGroupReplicaList) {
            String snapID;
            Node snapNode;
            if (!protectGroupReplica.isStorageSnapshotReplica()) continue;
            String snapStyleNodeId = siteNode.getID() + "-" + protectGroup.getPoType() + "-snapStyle";
            Node snapStyleNode = TopoServiceUtil.findNodeByIdInBox(box, snapStyleNodeId);
            if (snapStyleNode == null) {
                snapStyleNode = this.createPoInstanceStyleNode(snapStyleNodeId);
                context.addChild((IData)siteNode, (IData)snapStyleNode);
                this.setSnapNodeOffset(context, snapStyleNode, protectGroupReplicaList);
            }
            if ((snapNode = (Node)box.getElementByID((Object)(snapID = protectGroupReplica.getId() + "-snap"))) == null) {
                snapNode = (Node)new SnapNode(protectGroupReplica, this.getTopoResourceManager()).getLocalView();
                context.addChild((IData)snapStyleNode, (IData)snapNode);
            }
            if (TopoServiceUtil.isExistLinkBetweenNodes(protectGroupNode, snapNode)) continue;
            Link link = this.buildBaseSnapLink(protectGroupNode, snapNode, true);
            link.setToolTip(scheduleInfo);
            this.setLinkOffset(link);
            context.addChild((IData)context.getRootNode(), (IData)link);
        }
    }

    protected void setLinkOffset(Link link) {
    }

    protected void setSnapNodeOffset(TopoBaseContext context, Node node, List<ProtectGroupReplica> protectGroupReplicaList) {
    }

    protected Link buildBaseSnapLink(Node protectGroupNode, Node snapNode, boolean isNeedArrow) {
        Link link = new Link(protectGroupNode, snapNode);
        protectGroupNode.setLayerID((Object)LINK_LAYER_ID);
        snapNode.setLayerID((Object)LINK_LAYER_ID);
        link.setLayerID((Object)LINK_LAYER_ID);
        link.setStyle("link.width", 1.0);
        link.setStyle("arrow.to", isNeedArrow);
        if (isNeedArrow) {
            link.setStyle("arrow.to.width", 7.0);
            link.setStyle("arrow.to.height", 6.0);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            link.setStyle("arrow.to.color", (Object)"0x1dcfef");
        }
        link.setStyle("link.from.at.edge", false);
        link.setStyle("link.to.at.edge", false);
        link.setStyle("label.bold", false);
        link.setStyle("label.font", (Object)TopoBaseContext.getTopoResourceManager().getText("ism.drm.topo.label.font"));
        link.setStyle("link.type", (Object)"orthogonal.horizontal");
        link.setStyle("link.corner", (Object)"none");
        link.setStyle("link.extend", 0);
        link.setStyle("link.split.by.percent", true);
        link.setStyle("link.split.percent", 0.4);
        link.setClient("linkType", (Object)"snapLink");
        link.setStyle("link.color", (Object)"0x1dcfef");
        link.setStyle("select.alpha", 1.0);
        link.setStyle("select.style", (Object)"none");
        logger.debug((Object)("link is:" + link.getLayerID()));
        return link;
    }

    protected Node createPoInstanceStyleNode(String instanceStyleNodeID) {
        logger.debug((Object)("instanceStyleNodeID is: " + instanceStyleNodeID));
        Node group = new Node((Object)instanceStyleNodeID);
        group.setStyle("vector.roundrect.radius", 7);
        group.setClient("layout", (Object)"topbottom");
        group.setClient("TopoModel", (Object)"StyleGroup");
        group.setClient("leftGap", 11.0);
        group.setClient("topGap", 11.0);
        group.setClient("sonsGap", 11.0);
        group.setStyle("content.type", (Object)"vector");
        group.setStyle("vector.shape", (Object)"roundrect");
        group.setStyle("vector.fill.color", 1.6579836E7);
        group.setStyle("vector.outline.width", 1.0);
        group.setStyle("vector.outline.color", 1.447446E7);
        group.setStyle("select.alpha", 1.0);
        group.setStyle("select.style", (Object)"none");
        return group;
    }
}

