/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBaseBuilder;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBaseBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.HashSet;
import java.util.List;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-11")
public class GeneralGlobalTopoBuilder
extends AbstractGlobalTopoBaseBuilder {
    private static final Log LOGGER = LogFactory.getInstance(GeneralGlobalTopoBuilder.class);
    private boolean whole = true;

    public boolean isWhole() {
        return this.whole;
    }

    public void setWhole(boolean whole) {
        this.whole = whole;
    }

    @Override
    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        int poType = protectGroup.getPoType();
        if (this.checkPoType(poType)) {
            ITopoBaseBuilder hostBuilder = context.getTopoBuilderManager().getTopoBuilder("Global-Topology-Host");
            hostBuilder.buildTopo(context);
        } else if (poType == 10) {
            ITopoBaseBuilder vsBuilder = context.getTopoBuilderManager().getTopoBuilder("Global-Topology-vSphere");
            vsBuilder.buildTopo(context);
        } else if (poType == 11) {
            ProtectObjectStorageInfo poStorageInfo = context.getTopoBaseService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
            this.createStorage(context, protectGroup, poStorageInfo, layout);
        }
        int tempType = protectGroup.getTemplate().getType();
        if (PolicyTemplateType.isNasAirGapNetworking((int)tempType)) {
            ProtectObjectStorageInfo poStorageInfo = context.getTopoBaseService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
            this.createStorage(context, protectGroup, poStorageInfo, layout);
        }
        if (tempType == 17) {
            this.createHyperVaultTopo(context, layout);
            return;
        }
        if (tempType != 2 && tempType != 14) {
            this.createStorageArray(context, layout);
        }
    }

    private boolean checkPoType(int poType) {
        return 0 < poType && poType <= 9 || poType == 13 || poType == 16;
    }

    private void createHyperVaultTopo(TopoBaseContext context, ElementBox layout) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List replicas = context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
        String productArraySN = "";
        String recoverArraySN = "";
        Node productArrayNode = null;
        Node recoveryArrayNode = null;
        for (ProtectGroupReplica replica : replicas) {
            if (replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_A.getValue()) continue;
            productArraySN = replica.getProductArray();
            productArrayNode = this.getOrCreateProductSiteNode(context, replica, layout);
            break;
        }
        for (ProtectGroupReplica replica : replicas) {
            if (replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue() && replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.B_B.getValue()) continue;
            recoverArraySN = replica.getProductArray();
            recoveryArrayNode = this.getOrCreateProductSiteNode(context, replica, layout);
            break;
        }
        if (null == productArrayNode || null == recoveryArrayNode) {
            LOGGER.error((Object)("some is null: " + productArrayNode + "," + recoveryArrayNode), 1L);
            return;
        }
        Link link = TopoServiceUtil.getExistLinkBetweenNodes(productArrayNode, recoveryArrayNode);
        if (link == null) {
            this.createStorageLink(context, productArraySN, productArrayNode, recoverArraySN, recoveryArrayNode);
        } else {
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    private void createStorageArray(TopoBaseContext context, ElementBox layout) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ProtectGroupReplica> replicas = this.queryReductionProtectGroupReplicaByGroup(context);
        protectGroup.setReplicaList(new HashSet<ProtectGroupReplica>(replicas));
        for (ProtectGroupReplica replica : replicas) {
            Node recoverSiteNode;
            String productArraySN = replica.getProductArray();
            String recoverArraySN = replica.getRecoveryArray();
            Node productArrayNode = this.getOrCreateProductSiteNode(context, replica, layout);
            if (productArrayNode == null || productArraySN.equals(recoverArraySN) || (recoverSiteNode = this.getOrCreateRecoverSiteNode(context, replica, layout)) == null) continue;
            Link link = TopoServiceUtil.getExistLinkBetweenNodes(productArrayNode, recoverSiteNode);
            if (link == null) {
                this.createStorageLink(context, productArraySN, productArrayNode, recoverArraySN, recoverSiteNode);
                continue;
            }
            if (protectGroup.getTemplate().getType() == 38) continue;
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    protected List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(TopoBaseContext context) {
        return GeneralGlobalTopoBuilder.queryProtectGroupReplicas(context);
    }

    public static List<ProtectGroupReplica> queryProtectGroupReplicas(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
    }

    private void createStorageLink(TopoBaseContext context, String productArraySN, Node productArrayNode, String recoverArraySN, Node recoverArrayNode) {
        if (productArraySN.equals(recoverArraySN)) {
            return;
        }
        ElementBox topoBox = context.getElementBox();
        ProtectGroup protectGroup = context.getProtectGroup();
        String sLinkID = "storagelink-" + protectGroup.getUuid() + ":" + productArraySN + "->" + recoverArraySN;
        Link link = new Link((Object)sLinkID, productArrayNode, recoverArrayNode);
        link.setClient("linkToXOffset", 10.0);
        link.setClient("devSN", (Object)productArraySN);
        link.setClient("trgSN", (Object)recoverArraySN);
        if (protectGroup.getTemplate().getType() != 38) {
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
        link.setStyle("link.width", 1.0);
        link.setStyle("arrow.to", true);
        link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
        link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
        link.setStyle("arrow.to.shape", (Object)"arrow.delta");
        StringBuilder storageLinkTips = new StringBuilder();
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.status"));
        storageLinkTips.append(" ");
        int linkStatus = this.getStorageLinkStatus(context, productArraySN, recoverArraySN);
        if (linkStatus == 3 || linkStatus == 4) {
            link.setStyle("link.color", (Object)"0x1dcfef");
            link.setStyle("arrow.to.color", (Object)"0x1dcfef");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.unknown"));
        } else if (linkStatus == 2 || linkStatus == 1) {
            link.setStyle("link.color", (Object)"0xfc4133");
            link.setStyle("arrow.to.color", (Object)"0xfc4133");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.allbreak"));
        } else {
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.normal"));
        }
        link.setToolTip(storageLinkTips.toString());
        link.setStyle("select.alpha", 1.0);
        link.setStyle("select.style", (Object)"none");
        TopoServiceUtil.addElementToBox(topoBox, (IData)link);
    }

    protected List<ProtectGroupReplica> queryReductionProtectGroupReplicaByGroup(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return context.getReplicaService().queryReductionProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
    }
}

