/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.model.po;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.topo.model.IMultiView;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.topology.IElement;
import com.huawei.topology.Node;

public class SnapNode
implements IMultiView {
    private static final int TIMELENTH = 19;
    private ITopoResourceManager resourceManager;
    private Node node = null;
    private String label = "";
    private String image = "/theme/recoverydirector/images/topo/Snap.png";
    private String inactiveimage = "/theme/recoverydirector/images/topo/Snap_inactive.png";
    private String invalidimage = "/theme/recoverydirector/images/topo/Snap_invalid.png";
    private ProtectGroupReplica replica = null;

    public SnapNode(ProtectGroupReplica replica, ITopoResourceManager resourceManager) {
        this.replica = replica;
        this.resourceManager = resourceManager;
        this.init();
    }

    public void init() {
        this.node = new Node((Object)(this.replica.getId() + "snap"));
        String strTimeStamp = this.replica.getUtcTimeStamp();
        if (VerifyUtil.isEmpty((String)strTimeStamp)) {
            this.node.setName("          --          ");
        } else {
            this.node.setName(strTimeStamp);
            if (strTimeStamp.length() > 19) {
                this.node.setName(strTimeStamp.substring(0, 19) + "...");
            }
        }
        this.node.setImage(this.image);
        if (this.replica.getStatus() == 0) {
            this.node.setImage(this.inactiveimage);
        } else if (3 == this.replica.getStatus()) {
            this.node.setImage(this.invalidimage);
        }
        this.node.setToolTip(this.createsnapToolTip(this.replica));
        this.node.setStyle("label.bold", false);
        this.node.setStyle("label.font", (Object)this.resourceManager.getText("ism.drm.topo.label.font"));
        this.node.setClient("imageWidth", 48.0);
        this.node.setClient("imageHeight", 48.0);
        this.node.setStyle("label.color", 35020);
        this.node.setStyle("select.alpha", 1.0);
        this.node.setStyle("select.style", (Object)"none");
    }

    public Node getNode() {
        return this.node;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public IElement getLocalView() {
        return this.node;
    }

    @Override
    public IElement getRemoteView() {
        return this.node;
    }

    public void setReplica(ProtectGroupReplica replica) {
        this.replica = replica;
    }

    public ProtectGroupReplica getReplica() {
        return this.replica;
    }

    public String createsnapToolTip(ProtectGroupReplica replicaData) {
        StringBuilder tooltipBuilder = new StringBuilder();
        if (replicaData.getStatus() == 0) {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.snap.status") + " " + this.resourceManager.getText("ism.drm.topo.instance.app.snapstatus.inactive") + "\n");
        } else if (replicaData.getStatus() == 3) {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.snap.status") + " " + this.resourceManager.getText("ism.drm.topo.instance.app.snapstatus.invalid") + "\n");
        } else {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.snap.status") + " " + this.resourceManager.getText("ism.drm.topo.instance.app.snapstatus.normal") + "\n");
        }
        if (!TopoServiceUtil.isNullStr(replicaData.getUtcTimeStamp())) {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.snap.time") + " " + replicaData.getUtcTimeStamp() + "\n");
        } else {
            tooltipBuilder.append(this.resourceManager.getText("ism.drm.topo.snap.time") + " " + "--" + "\n");
        }
        return tooltipBuilder.toString();
    }
}

