/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.poll;

import com.huawei.ism.drm.topo.sdk.poll.ITopoPoller;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class TopoPollTask
implements Runnable {
    private static final Log logger = LogFactory.getInstance(TopoPollTask.class);
    private static final long SLEEP_INTERVAL_TIME = 30000L;
    private static final long DEFAULT_CONN_CHECK_INTERVAL = 120000L;
    private static final int DEFAULT_CONN_CHECK_NUM = 4;
    private String sourceSN;
    private String ipAddress;
    private String port;
    private String sourceType;
    private ITopoPoller topoPoller;
    private boolean cycle = true;
    private int sleepNum = 4;
    private long connCheckIntervalTime = 120000L;

    @Override
    public void run() {
        while (this.cycle) {
            try {
                this.topoPoller.pollResource(this.sourceSN);
            }
            catch (Throwable e) {
                logger.error((Object)("topoPoller pollResource error. SN: " + this.sourceSN + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            try {
                for (int i = 0; i < this.sleepNum && this.cycle; ++i) {
                    CommUtil.pauseThread((long)30000L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("topoPoller sleep error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }

    public long getConnCheckIntervalTime() {
        return this.connCheckIntervalTime;
    }

    public void setConnCheckIntervalTime(long connCheckIntervalTime) {
        try {
            this.connCheckIntervalTime = connCheckIntervalTime;
            this.sleepNum = (int)(connCheckIntervalTime / 30000L);
        }
        catch (Exception e) {
            this.connCheckIntervalTime = 120000L;
            this.sleepNum = 4;
            logger.error((Object)("setConnCheckIntervalTime error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    public String getSourceSN() {
        if (this.topoPoller != null) {
            return this.topoPoller.getResourceSN();
        }
        return this.sourceSN;
    }

    public void setSourceSN(String sourceSN) {
        this.sourceSN = sourceSN;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public ITopoPoller getTopoPoller() {
        return this.topoPoller;
    }

    public void setTopoPoller(ITopoPoller topoPoller) {
        this.topoPoller = topoPoller;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}

