/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.common.sdk.model;

import com.huawei.ism.drm.common.sdk.model.DRMObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MessageEvent {
    public static final int REMOVE_MESSAGE = 4;
    public static final int ADD_MESSAGE = 3;
    public static final int DELETE_MESSAGE = 2;
    public static final int UPDATE_MESSAGE = 1;
    public static final int CREATE_MESSAGE = 0;
    public static final int CREATE_OR_ADD_MESSAGE = 5;
    public static final int RECOVERY_PLAN_EXCUTE = 6;
    public static final int RECOVERY_PLAN_VALIDATE = 7;
    public static final int DISABLE_MESSAGE = 8;
    public static final int ENABLE_MESSAGE = 9;
    public static final int LOCK_MESSAGE = 10;
    public static final int UNLOCK_MESSAGE = 11;
    public static final int ADD_SCHEDULE = 12;
    public static final int UPDATE_SCHEDULE = 13;
    public static final int UPGRADE_MESSAGE = 21;
    public static final int DOWNGRADE_MESSAGE = 22;
    public static final int UPGRADE_FAILED_MESSAGE = 23;
    public static final int CREATE_FAILED_MESSAGE = 24;
    public static final int ADD_FAILED_MESSAGE = 25;
    private int messageType;
    private List<? extends DRMObject> objectList;
    private Map<String, Object> messageMap = new HashMap<String, Object>();

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public List<? extends DRMObject> getObjectList() {
        return this.objectList;
    }

    public <T extends DRMObject> List<T> getObjectList(Class<T> clazz) {
        if (clazz == null || this.getObjectList() == null) {
            return null;
        }
        return this.getObjectList().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public void setObjectList(List<? extends DRMObject> objectList) {
        this.objectList = objectList;
    }

    public Map<String, Object> getMessageMap() {
        return this.messageMap;
    }

    public void setMessageMap(Map<String, Object> messageMap) {
        this.messageMap = messageMap;
    }

    public static MessageEvent createMessageEvent(int messageType, Object ... messageObjects) {
        MessageEvent event = new MessageEvent();
        HashMap<String, Object> message = new HashMap<String, Object>();
        for (Object object : messageObjects) {
            message.put(object.getClass().getSimpleName(), object);
        }
        event.setMessageType(messageType);
        event.setMessageMap(message);
        return event;
    }
}

