/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.detect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.detect.ResourceDetectedEvent;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;

public class ResourceEventIterator<R extends DrResource, D>
implements Iterator<ResourceDetectedEvent<R, D>> {
    private final IntFunction<List<ResourceDetectedEvent<R, D>>> loader;
    private final AtomicInteger page = new AtomicInteger();
    private final AtomicInteger cursor = new AtomicInteger();
    private final AtomicReference<List<ResourceDetectedEvent<R, D>>> reference = new AtomicReference(Collections.emptyList());

    public ResourceEventIterator() {
        this(index -> null);
    }

    public ResourceEventIterator(IntFunction<List<ResourceDetectedEvent<R, D>>> loader) {
        this.loader = Objects.requireNonNull(loader);
    }

    @Override
    public boolean hasNext() {
        List<ResourceDetectedEvent<R, D>> items = this.reference.get();
        if (items == null) {
            return false;
        }
        if (this.cursor.get() < items.size()) {
            return true;
        }
        List<ResourceDetectedEvent<R, D>> results = this.loader.apply(this.page.getAndIncrement());
        this.cursor.set(0);
        if (VerifyUtil.isEmpty(results)) {
            this.reference.set(null);
            return false;
        }
        this.reference.set(results);
        return true;
    }

    @Override
    public ResourceDetectedEvent<R, D> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<ResourceDetectedEvent<R, D>> items = this.reference.get();
        return items.get(this.cursor.getAndIncrement());
    }
}

