/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.meter;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.meter.model.MeterStatisticInfo;
import com.huawei.ism.drm.meter.service.statistic.MeterStatisticStrategy;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LargeLunMeterStatisticStrategyImpl
extends MeterStatisticStrategy {
    private static final Log LOGGER = LogFactory.getInstance(LargeLunMeterStatisticStrategyImpl.class);
    private static final Set<Integer> LARGE_LUN_TEMPLATE_TYPES = ImmutableSet.of((Object)0, (Object)1, (Object)15, (Object)18, (Object)26);

    @Override
    public boolean isMatchStrategy(ProtectGroup protectGroup) {
        return protectGroup.getPoType() == 12 && LARGE_LUN_TEMPLATE_TYPES.contains(protectGroup.getTemplate().getType());
    }

    @Override
    public void statisticVol(ProtectGroup protectGroup, MeterStatisticInfo meterStatisticInfo) {
        IStorageBaseService storageService = (IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class);
        IStorageResourceBaseService resourceService = (IStorageResourceBaseService)ServiceLocator.getInstance().getService(IStorageResourceBaseService.class);
        if (protectGroup.getTemplate().getType() == 15) {
            Set lunWWNs = protectGroup.getPolist().stream().flatMap(protectObject -> protectObject.getUsedStorageResourceSet().stream()).map(ProtectObjectStorageInfo::getLunWWN).collect(Collectors.toSet());
            LOGGER.info((Object)"The hyperMetro lunWWNs num of ProtectGroup:%s is: %s", new Object[]{protectGroup.getUuid(), lunWWNs.size()});
            for (String string : lunWWNs) {
                List<HyperMetroPair> hyperMetroPair = resourceService.getHyperMetroPairByWwn(Collections.singletonList(string), true);
                if (VerifyUtil.isEmpty(hyperMetroPair)) {
                    LOGGER.warn((Object)"The hyperMetro lunWWN:%s not find.", new Object[]{string});
                    continue;
                }
                hyperMetroPair.forEach(pair -> this.statisticVol(storageService, pair.getDevSn(), pair.getLocalObjId(), meterStatisticInfo));
            }
        }
        Collection<RemoteStorageReplica> storageInfos = protectGroup.getReplicaList().stream().flatMap(replica -> replica.getReplicas().stream()).flatMap(poReplica -> poReplica.getStorageInfos().stream()).map(RemoteStorageReplica.class::cast).collect(Collectors.toMap(RelicaStorageInfo::getStorageId, p -> p, (p, q) -> p)).values();
        LOGGER.info((Object)"The replica pair nums of ProtectGroup:%s is: %s", new Object[]{protectGroup.getUuid(), storageInfos.size()});
        for (RelicaStorageInfo relicaStorageInfo : storageInfos) {
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)RemoteStorageReplica.class.cast(relicaStorageInfo);
            String providerSN = remoteStorageReplica.getSrcStorageProviderSN();
            String lunId = remoteStorageReplica.getSrcStorageId();
            this.statisticVol(storageService, providerSN, lunId, meterStatisticInfo);
        }
    }

    private void statisticVol(IStorageBaseService storageService, String devSn, String lunId, MeterStatisticInfo meterStatisticInfo) {
        Lun lun = storageService.getLunBySnAndLunId(devSn, lunId);
        long volProtectCapacity = UnitConvert.convert((long)lun.getTotalCapacity().longValue(), (IUnitType)CapabilityUnitType.valueOf((String)lun.getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.MB);
        LOGGER.info((Object)"The volProtectCapacity of lun:%s is:%s", new Object[]{lunId, volProtectCapacity});
        meterStatisticInfo.addVolProtectCapacity(volProtectCapacity);
    }
}

