/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.meter;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.meter.model.MeterStatisticInfo;
import com.huawei.ism.drm.meter.service.statistic.MeterStatisticStrategy;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Set;

public class SmallLunMeterStatisticStrategyImpl
extends MeterStatisticStrategy {
    private static final Log LOGGER = LogFactory.getInstance(SmallLunMeterStatisticStrategyImpl.class);
    private static final Set<Integer> SMALL_LUN_TEMPLATE_TYPES = ImmutableSet.of((Object)51, (Object)52, (Object)53, (Object)33, (Object)39, (Object)38, (Object[])new Integer[0]);

    @Override
    public boolean isMatchStrategy(ProtectGroup protectGroup) {
        return protectGroup.getPoType() == 12 && SMALL_LUN_TEMPLATE_TYPES.contains(protectGroup.getTemplate().getType());
    }

    @Override
    public void statisticVol(ProtectGroup protectGroup, MeterStatisticInfo meterStatisticInfo) {
        IProtectGroupBaseService protectGroupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        List<DiskInfo> diskInfos = protectGroupService.queryDiskInfo(protectGroup);
        LOGGER.info((Object)"The disk num of ProtectGroup:%s is: %s", new Object[]{protectGroup.getUuid(), diskInfos.size()});
        diskInfos.stream().filter(this::filterUnprotectedDisk).forEach(diskInfo -> meterStatisticInfo.addVolProtectCapacity(diskInfo.getCapacity()));
    }

    private boolean filterUnprotectedDisk(DiskInfo diskInfo) {
        return !DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskInfo.getStatus()) && !DiskProtectStatusEnum.RELEASING.getStatus().equals(diskInfo.getStatus());
    }
}

