/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.group.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.PropertyAccessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProtectGroup
extends DRMObject
implements Cloneable,
PropertyAccessor {
    private static final long serialVersionUID = 4898523540734102152L;
    private static final int FIRST = 0;
    private String pgId;
    private int poType;
    private String poProviderSN;
    private int status = DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus();
    private Set<ProtectObject> polist = new HashSet<ProtectObject>();
    private Set<ProtectGroupReplica> replicaList = new HashSet<ProtectGroupReplica>();
    private String productSiteId;
    private String productSiteName;
    private Map<String, String> props = null;
    private Long lastExecTime;
    private Integer lastExecResult;
    private String lastExecErrorDetail;
    private String lastExecParam;
    @Deprecated
    private int pgReplicaIndex = 0;
    private PolicyTemplate template;
    private boolean primary;
    private Set<ProtectGroupLog> pgHistoryLogs = new HashSet<ProtectGroupLog>();
    private Long lockTime;
    private ProtectGroupReplica latestRepica;
    private String objectType = ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue();

    public ProtectGroup() {
    }

    public ProtectGroup(String pgId, String poProviderSN, String productSiteId, String productSiteName, PolicyTemplate template, Boolean primary) {
        super.setUuid(pgId);
        this.pgId = pgId;
        this.poProviderSN = poProviderSN;
        this.productSiteId = productSiteId;
        this.productSiteName = productSiteName;
        this.template = template;
        this.setPrimary(primary);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public int getPoCount() {
        if (this.polist != null) {
            return this.polist.size();
        }
        return 0;
    }

    private String getPgId() {
        return this.pgId;
    }

    private void setPgId(String pgId) {
        this.pgId = pgId;
        super.setUuid(pgId);
    }

    @Override
    public void setUuid(String uuid) {
        this.pgId = uuid;
        super.setUuid(uuid);
    }

    public int getPoType() {
        return this.poType;
    }

    public void setPoType(int poType) {
        this.poType = poType;
    }

    public String getPoProviderSN() {
        return this.poProviderSN;
    }

    public void setPoProviderSN(String poProviderSN) {
        this.poProviderSN = poProviderSN;
    }

    public Set<ProtectObject> getPolist() {
        return this.polist;
    }

    public void setPolist(Set<ProtectObject> polist) {
        this.polist = polist;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isInvalid() {
        return DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == this.status;
    }

    public boolean isLocked() {
        return DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus() == this.status;
    }

    public boolean isDisabled() {
        return DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus() == this.status;
    }

    public boolean isRunning() {
        return DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() == this.status;
    }

    public boolean isNormal() {
        return DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() == this.status;
    }

    public Set<ProtectGroupReplica> getReplicaList() {
        return this.replicaList;
    }

    public void setReplicaList(Set<ProtectGroupReplica> replicaList) {
        this.replicaList = replicaList;
    }

    public int getReplicaCount() {
        if (this.replicaList != null) {
            return this.replicaList.size();
        }
        return 0;
    }

    @Override
    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public Long getLastExecTime() {
        return this.lastExecTime;
    }

    public void setLastExecTime(Long lastExecTime) {
        this.lastExecTime = lastExecTime;
    }

    @Deprecated
    public int getPgReplicaIndex() {
        return this.pgReplicaIndex;
    }

    @Deprecated
    public void setPgReplicaIndex(int pgReplicaIndex) {
        this.pgReplicaIndex = pgReplicaIndex;
    }

    public String getProductSiteId() {
        return this.productSiteId;
    }

    public void setProductSiteId(String productSiteId) {
        this.productSiteId = productSiteId;
    }

    public String getProductSiteName() {
        return this.productSiteName;
    }

    public void setProductSiteName(String productSiteName) {
        this.productSiteName = productSiteName;
    }

    public PolicyTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(PolicyTemplate template) {
        this.template = template;
    }

    public Set<ProtectGroupLog> getPgHistoryLogs() {
        return this.pgHistoryLogs;
    }

    public void setPgHistoryLogs(Set<ProtectGroupLog> pgHistoryLogs) {
        this.pgHistoryLogs = pgHistoryLogs;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public Integer getLastExecResult() {
        return this.lastExecResult;
    }

    public void setLastExecResult(Integer lastExecResult) {
        this.lastExecResult = lastExecResult;
    }

    public String getLastExecErrorDetail() {
        return this.lastExecErrorDetail;
    }

    public void setLastExecErrorDetail(String lastExecErrorDetail) {
        this.lastExecErrorDetail = lastExecErrorDetail;
    }

    public String getLastExecParam() {
        return this.lastExecParam;
    }

    public void setLastExecParam(String lastExecParam) {
        this.lastExecParam = lastExecParam;
    }

    public String getUtcTimeStamp() {
        return this.lastExecTime != null ? CommUtil.formatDate(new Date(this.lastExecTime)) : "--";
    }

    public void addProtectObject(ProtectObject protectObject) {
        protectObject.setProtectGroup(this);
        this.getPolist().add(protectObject);
    }

    public void addProtectGroupReplica(ProtectGroupReplica protectGroupReplica) {
        protectGroupReplica.setPg(this);
        this.getReplicaList().add(protectGroupReplica);
    }

    public Long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(Long lockTime) {
        this.lockTime = lockTime;
    }

    public ProtectGroupReplica getLatestRepica() {
        return this.latestRepica;
    }

    public void setLatestRepica(ProtectGroupReplica latestRepica) {
        this.latestRepica = latestRepica;
    }

    public Object clone() throws CloneNotSupportedException {
        ProtectGroup result = (ProtectGroup)super.clone();
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.putAll(this.getProps());
        result.setProps(newMap);
        HashSet<ProtectObject> protectObjectList = new HashSet<ProtectObject>();
        for (ProtectObject protectObject : result.getPolist()) {
            ProtectObject cloneProtectObject = (ProtectObject)protectObject.clone();
            cloneProtectObject.setProtectGroup(result);
            protectObjectList.add(cloneProtectObject);
        }
        result.setPolist(protectObjectList);
        HashSet<ProtectGroupReplica> protectGroupReplicaList = new HashSet<ProtectGroupReplica>();
        for (ProtectGroupReplica protectGroupReplica : result.getReplicaList()) {
            ProtectGroupReplica cloneProtectGroupReplica = (ProtectGroupReplica)protectGroupReplica.clone();
            cloneProtectGroupReplica.setPg(result);
            protectGroupReplicaList.add(cloneProtectGroupReplica);
        }
        result.setReplicaList(protectGroupReplicaList);
        HashSet<ProtectGroupLog> hashSet = new HashSet<ProtectGroupLog>();
        result.setPgHistoryLogs(hashSet);
        result.setTemplate((PolicyTemplate)result.getTemplate().clone());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public List<ReplicationRelationBo> getReplicationRelationByRecoverySiteId(String siteId) {
        List<ReplicationRelationBo> result = new ArrayList<ReplicationRelationBo>();
        if (siteId == null || this.replicaList == null || this.replicaList.isEmpty()) {
            return result;
        }
        ProtectGroupReplica siteReplica = null;
        for (ProtectGroupReplica replica : this.replicaList) {
            if (2 != replica.getType() && 1 != replica.getType() || !siteId.equals(replica.getRecoverySite())) continue;
            siteReplica = replica;
            break;
        }
        if (siteReplica == null) {
            return result;
        }
        Set<ProtectObjectReplica> protectObjectReplicas = siteReplica.getReplicas();
        if (protectObjectReplicas == null || protectObjectReplicas.isEmpty()) {
            return result;
        }
        result = this.getReplicationRelationBos(protectObjectReplicas);
        return result;
    }

    public List<ReplicationRelationBo> getReplicationRelationBos(Set<ProtectObjectReplica> protectObjectReplicas) {
        HashSet<ReplicationRelationBo> result = new HashSet<ReplicationRelationBo>();
        HashMap<String, ReplicationRelationBo> repliationMapping = new HashMap<String, ReplicationRelationBo>();
        for (ProtectObjectReplica replica : protectObjectReplicas) {
            Set<RelicaStorageInfo> replicaStorageInfos = replica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : replicaStorageInfos) {
                ReplicationRelationBo replication;
                if (!(storageInfo instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteReplica = (RemoteStorageReplica)storageInfo;
                String replicationId = remoteReplica.getConsistentGroupId();
                if (!VerifyUtil.isEmpty((String)replicationId) && !"--".equals(replicationId) && null == repliationMapping.get(replicationId)) {
                    replication = new ReplicationRelationBo();
                    replication.setReplicationId(replicationId);
                    replication.setConsistentGroup(true);
                    repliationMapping.put(replicationId, replication);
                }
                if ((replication = (ReplicationRelationBo)repliationMapping.get(replicationId)) == null) {
                    replication = new ReplicationRelationBo();
                    replication.setReplicationId(remoteReplica.getReplicationPairId());
                }
                replication.setDrRingId(remoteReplica.getDrRingId());
                replication.setSrcDeviceSn(remoteReplica.getSrcStorageProviderSN());
                replication.setTgtDeviceSn(remoteReplica.getStorageProviderSN());
                replication.setResourceType(DrmEnumDefine.ResourceTypeE.LUN.getValue());
                String wwn = storageInfo.getProtectObjectStorageWwn();
                if (VerifyUtil.isEmpty((String)wwn) || wwn.contains("/")) {
                    replication.setResourceType(DrmEnumDefine.ResourceTypeE.NAS.getValue());
                }
                Map<String, String> tgtLun = replication.getTgtLuns();
                tgtLun.put(remoteReplica.getSrcStorageId(), remoteReplica.getStorageId());
                replication.setTgtLuns(tgtLun);
                replication.setSyncMode(replica.getPgReplica().getType());
                result.add(replication);
            }
        }
        ArrayList<ReplicationRelationBo> resultList = new ArrayList<ReplicationRelationBo>();
        resultList.addAll(result);
        return resultList;
    }

    public Map<String, List<ReplicationRelationBo>> getAllReplicationRelation() {
        if (VerifyUtil.isEmpty(this.replicaList)) {
            return null;
        }
        HashMap<String, List<ReplicationRelationBo>> result = new HashMap<String, List<ReplicationRelationBo>>();
        for (ProtectGroupReplica replica : this.replicaList) {
            String site = replica.getRecoverySite();
            result.put(site, this.getReplicationRelationByRecoverySiteId(site));
        }
        return result;
    }

    public int getLocationReplicaCount(int location) {
        int count = 0;
        for (ProtectGroupReplica replica : this.replicaList) {
            if (replica.getProtectLocation() != location) continue;
            ++count;
        }
        return count;
    }

    public void setCurrentReplicaIndex(int protectLocation, int index) {
        this.props.put("DrmFrameWork_Pg_Replica_Inedx" + protectLocation, String.valueOf(index));
    }

    public int getCurrentReplicaIndex(int protectLocation) {
        String indexStr = this.props.get("DrmFrameWork_Pg_Replica_Inedx" + protectLocation);
        int result = 1;
        if (!VerifyUtil.isEmpty((String)indexStr)) {
            try {
                result = Integer.parseInt(indexStr);
            }
            catch (NumberFormatException e) {
                result = 1;
            }
        }
        return result;
    }

    public void removeAllReplicaIndex() {
        this.props.entrySet().removeIf(stringStringEntry -> ((String)stringStringEntry.getKey()).startsWith("DrmFrameWork_Pg_Replica_Inedx"));
    }

    public List<ProtectGroupReplica> listAllReplicatonRepica() {
        if (VerifyUtil.isEmpty(this.replicaList)) {
            return null;
        }
        ArrayList<ProtectGroupReplica> results = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : this.replicaList) {
            if (!replica.isStorageReplicationReplica()) continue;
            results.add(replica);
        }
        return results;
    }

    public ProtectGroupReplica getAnyoneReplicationReplica() {
        List<ProtectGroupReplica> protectGroupReplicaList = this.listAllReplicatonRepica();
        if (protectGroupReplicaList == null || protectGroupReplicaList.isEmpty()) {
            return null;
        }
        return protectGroupReplicaList.iterator().next();
    }

    public ProtectGroupReplica getProtectGroupReplicaById(String replicaId) {
        if (replicaId == null || VerifyUtil.isEmpty(this.replicaList)) {
            return null;
        }
        for (ProtectGroupReplica replica : this.replicaList) {
            if (!replicaId.equals(replica.getId())) continue;
            return replica;
        }
        return null;
    }

    public ProtectGroupReplica getReplicationReplicaByLocation(DrmEnumDefine.ProtectLocation location) {
        if (null == location || VerifyUtil.isEmpty(this.replicaList)) {
            return null;
        }
        for (ProtectGroupReplica replica : this.replicaList) {
            if (location.getValue() != replica.getProtectLocation() || !replica.isStorageReplicationReplica()) continue;
            return replica;
        }
        return null;
    }

    public ProtectGroupReplica getReplicationReplicaByRecoverySiteId(String siteId) {
        if (siteId == null || VerifyUtil.isEmpty(this.replicaList)) {
            return null;
        }
        for (ProtectGroupReplica replica : this.replicaList) {
            if (!siteId.equals(replica.getRecoverySite()) || !replica.isStorageReplicationReplica()) continue;
            return replica;
        }
        return null;
    }

    public List<ReplicationRelationBo> getSortedReplication() {
        LinkedList<ReplicationRelationBo> sortedReplicationList = new LinkedList<ReplicationRelationBo>();
        Map<String, List<ReplicationRelationBo>> allReplicationMap = this.getAllReplicationRelation();
        if (null == allReplicationMap || allReplicationMap.isEmpty()) {
            return sortedReplicationList;
        }
        Collection<List<ReplicationRelationBo>> replicationRelationList = allReplicationMap.values();
        for (List<ReplicationRelationBo> oneList : replicationRelationList) {
            for (ReplicationRelationBo replication : oneList) {
                ReplicationRelationBo pre = this.previousReplication(replication, replicationRelationList);
                ReplicationRelationBo next = this.nextReplication(replication, replicationRelationList);
                if (null == pre && null == next) {
                    sortedReplicationList.add(replication);
                }
                this.handleLastReplication(sortedReplicationList, replication, pre, next);
                this.handleFirstReplication(sortedReplicationList, replication, pre, next);
                this.handleMiddleReplication(sortedReplicationList, replication, pre, next);
            }
        }
        return sortedReplicationList;
    }

    private void handleMiddleReplication(List<ReplicationRelationBo> sortedReplicationList, ReplicationRelationBo replication, ReplicationRelationBo pre, ReplicationRelationBo next) {
        if (pre != null && next != null) {
            int preIndex = sortedReplicationList.indexOf(pre);
            int nextIndex = sortedReplicationList.indexOf(next);
            if (preIndex > -1 && nextIndex == -1) {
                if (preIndex == sortedReplicationList.size()) {
                    sortedReplicationList.add(preIndex, replication);
                } else {
                    sortedReplicationList.add(preIndex + 1, replication);
                }
            }
            if (preIndex == -1 && nextIndex > -1) {
                sortedReplicationList.add(nextIndex, replication);
            }
            if (preIndex > -1 && nextIndex > -1) {
                sortedReplicationList.add(nextIndex, replication);
            }
            if (preIndex == -1 && nextIndex == -1) {
                sortedReplicationList.add(replication);
            }
        }
    }

    private void handleFirstReplication(List<ReplicationRelationBo> sortedReplicationList, ReplicationRelationBo replication, ReplicationRelationBo pre, ReplicationRelationBo next) {
        if (next != null && pre == null) {
            int nextIndex = sortedReplicationList.indexOf(next);
            if (nextIndex > -1) {
                sortedReplicationList.add(nextIndex, replication);
            } else {
                sortedReplicationList.add(0, replication);
            }
        }
    }

    private void handleLastReplication(List<ReplicationRelationBo> sortedReplicationList, ReplicationRelationBo replication, ReplicationRelationBo pre, ReplicationRelationBo next) {
        int listSize = sortedReplicationList.size();
        if (pre != null && next == null) {
            int preIndex = sortedReplicationList.indexOf(pre);
            if (preIndex > -1) {
                if (preIndex == listSize) {
                    sortedReplicationList.add(preIndex, replication);
                } else {
                    sortedReplicationList.add(preIndex + 1, replication);
                }
            } else {
                sortedReplicationList.add(listSize, replication);
            }
        }
    }

    private ReplicationRelationBo nextReplication(ReplicationRelationBo replication, Collection<List<ReplicationRelationBo>> allRelationList) {
        boolean hasNext = false;
        ReplicationRelationBo result = null;
        for (List<ReplicationRelationBo> oneList : allRelationList) {
            for (ReplicationRelationBo oneReplication : oneList) {
                if (!replication.getTgtDeviceSn().equals(oneReplication.getSrcDeviceSn())) continue;
                result = oneReplication;
                hasNext = true;
                break;
            }
            if (!hasNext) continue;
            break;
        }
        return result;
    }

    private ReplicationRelationBo previousReplication(ReplicationRelationBo replication, Collection<List<ReplicationRelationBo>> allRelationList) {
        boolean hasPrevius = false;
        ReplicationRelationBo result = null;
        for (List<ReplicationRelationBo> oneList : allRelationList) {
            for (ReplicationRelationBo oneReplication : oneList) {
                if (!replication.getSrcDeviceSn().equals(oneReplication.getTgtDeviceSn())) continue;
                hasPrevius = true;
                result = oneReplication;
                break;
            }
            if (!hasPrevius) continue;
            break;
        }
        return result;
    }

    public List<ProtectObjectStorageInfo> distinctStorageInfo() {
        Set<ProtectObject> protectObjectList = this.getPolist();
        if (null == protectObjectList || protectObjectList.isEmpty()) {
            return null;
        }
        ArrayList<ProtectObjectStorageInfo> distinctStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObject protectObject : protectObjectList) {
            Set<ProtectObjectStorageInfo> protectObjectStorageInfoSet = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObjectStorageInfoSet) {
                if (distinctStorageInfoList.contains(protectObjectStorageInfo)) continue;
                distinctStorageInfoList.add(protectObjectStorageInfo);
            }
        }
        return distinctStorageInfoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProtectObjectStorageInfo>(Comparator.comparing(storageInfo -> storageInfo.getResourceId() + ";" + storageInfo.getResourceName()))), ArrayList::new));
    }

    public Schedule findFirstSchedule(Schedule currentSchedule) {
        if (null == this.template) {
            return currentSchedule;
        }
        if (null == this.template.getSchedules() || this.template.getSchedules().isEmpty()) {
            return currentSchedule;
        }
        for (Schedule schedule : this.template.getSchedules()) {
            if (null == schedule.getTargetSiteId() || schedule.getTargetSiteId().equals(schedule.getSourceSiteId()) || !schedule.getTargetSiteId().equals(currentSchedule.getSourceSiteId()) || Objects.equals(schedule.getSourceSiteId(), currentSchedule.getTargetSiteId())) continue;
            return this.findFirstSchedule(schedule);
        }
        return currentSchedule;
    }

    public ProtectObjectStorageInfo getAnyProtectObjectStorageInfo() {
        return this.getPolist().stream().filter(Objects::nonNull).map(ProtectObject::getUsedStorageResourceSet).flatMap(Collection::stream).findAny().orElse(null);
    }

    public boolean hasMultiCg() {
        String cgUuid = this.getProps().get("cgUuid");
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            return false;
        }
        try {
            JSONArray jsonArray = JSONArray.fromObject((Object)cgUuid);
            return jsonArray.size() > 1;
        }
        catch (LegoCheckedException e) {
            return false;
        }
    }

    public boolean isRepConsistentGroup() {
        return !VerifyUtil.isEmpty((String)this.getProps().get("cgUuid"));
    }

    public boolean isNeedSecureSnapshot() {
        int type = Optional.ofNullable(this.getTemplate()).map(PolicyTemplate::getType).orElse(-1);
        if (type != 45 && type != 46) {
            return false;
        }
        Set schedules = Optional.ofNullable(this.getTemplate()).map(PolicyTemplate::getSchedules).orElse(null);
        boolean needSecureSnapshot = false;
        if (!VerifyUtil.isEmpty((Collection)schedules)) {
            needSecureSnapshot = schedules.stream().findFirst().map(Schedule::isNeedSecureSnapshot).orElse(false);
        }
        return needSecureSnapshot;
    }

    public boolean isInExecutionPreferred(Integer execMode) {
        int templateType = Optional.ofNullable(this.getTemplate()).map(PolicyTemplate::getType).orElse(-1);
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(templateType)) {
            return false;
        }
        if (execMode != null && execMode == 1) {
            return true;
        }
        Set schedules = Optional.ofNullable(this.getTemplate()).map(PolicyTemplate::getSchedules).orElse(null);
        if (CollectionUtils.isEmpty((Collection)schedules)) {
            return false;
        }
        return schedules.stream().findFirst().map(Schedule::isInExecutionPreferred).orElse(false);
    }

    public boolean isSkipAutoSchedule(Integer execMode) {
        int templateType = Optional.ofNullable(this.getTemplate()).map(PolicyTemplate::getType).orElse(-1);
        if (!PolicyTemplateType.KUBE_RESOURCE_TYPES.contains(templateType)) {
            return false;
        }
        return execMode != null && execMode == 0;
    }

    public boolean isAirGapType() {
        if (VerifyUtil.isEmpty(this.props)) {
            return false;
        }
        return Optional.of(this.props).map(props -> (String)props.get("isAirGapType")).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
    }

    public Set<String> getHyperMetroSiteIdSet() {
        Set<String> hyperMetroSiteIds = new HashSet<String>();
        if (this.template != null && !PolicyTemplateType.HYPERMETRO_SWITCHOVER_TEMPLATE.contains(this.template.getType())) {
            return hyperMetroSiteIds;
        }
        if (this.props == null) {
            return hyperMetroSiteIds;
        }
        String siteInfoListStr = this.props.get("PROP_KEY_SITE_INFO");
        if (VerifyUtil.isEmpty((String)siteInfoListStr)) {
            return hyperMetroSiteIds;
        }
        List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
        if (CollectionUtils.isEmpty((Collection)siteInfoList)) {
            return hyperMetroSiteIds;
        }
        for (SiteInfo siteInfo : siteInfoList) {
            Set<String> siteIdSet = siteInfo.getSiteIdSet();
            if (2 != siteIdSet.size()) continue;
            hyperMetroSiteIds = siteIdSet;
            break;
        }
        return hyperMetroSiteIds;
    }

    public ProtectGroupReplica getReplicaByHMNonReplicaSiteId(String siteId) {
        List<ProtectGroupReplica> protectGroupReplicaList = this.listAllReplicatonRepica();
        if (CollectionUtils.isEmpty(protectGroupReplicaList)) {
            return null;
        }
        Set<String> hmSiteIdSet = this.getHyperMetroSiteIdSet();
        if (CollectionUtils.isEmpty(hmSiteIdSet)) {
            for (ProtectGroupReplica replica : protectGroupReplicaList) {
                if (replica.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue()) {
                    return replica;
                }
                if (replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue()) continue;
                return replica;
            }
            return null;
        }
        Optional<String> opt = hmSiteIdSet.stream().filter(siteIdStr -> !siteIdStr.equals(siteId)).findAny();
        if (!opt.isPresent()) {
            return null;
        }
        return this.getReplicationReplicaByRecoverySiteId(opt.get());
    }
}

