/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.replica.sdk.model;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProtectObjectReplica
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 749874000107219186L;
    private static final Log LOGGER = LogFactory.getInstance(ProtectObjectReplica.class);
    private String id;
    private String poId;
    private String placeholderProtectObjectId;
    private String poMetadata;
    private String rawPoMetaData;
    private ProtectGroupReplica pgReplica;
    private Set<RelicaStorageInfo> storageInfos = new HashSet<RelicaStorageInfo>();
    private ProtectObject protectObject;
    private int detectionStatus;
    private Integer consistentType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public ProtectGroupReplica getPgReplica() {
        return this.pgReplica;
    }

    public void setPgReplica(ProtectGroupReplica pgReplica) {
        this.pgReplica = pgReplica;
    }

    public Set<RelicaStorageInfo> getStorageInfos() {
        return this.storageInfos;
    }

    public void setStorageInfos(Set<RelicaStorageInfo> storageInfos) {
        if (VerifyUtil.isEmpty(storageInfos)) {
            return;
        }
        this.storageInfos = storageInfos;
    }

    public String getPlaceholderProtectObjectId() {
        return this.placeholderProtectObjectId;
    }

    public void setPlaceholderProtectObjectId(String placeholderProtectObjectId) {
        this.placeholderProtectObjectId = placeholderProtectObjectId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pgReplica == null ? 0 : this.pgReplica.hashCode());
        result = 31 * result + (this.poId == null ? 0 : this.poId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtectObjectReplica other = (ProtectObjectReplica)obj;
        if (this.pgReplica == null ? other.pgReplica != null : !this.pgReplica.equals(other.pgReplica)) {
            return false;
        }
        return !(this.poId == null ? other.poId != null : !this.poId.equals(other.poId));
    }

    public void addRelicaStorageInfo(RelicaStorageInfo relicaStorageInfo) {
        relicaStorageInfo.setPoReplica(this);
        this.getStorageInfos().add(relicaStorageInfo);
    }

    public ProtectObject getProtectObject() {
        return this.protectObject;
    }

    public void setProtectObject(ProtectObject protectObject) {
        this.protectObject = protectObject;
    }

    public Object clone() throws CloneNotSupportedException {
        ProtectObjectReplica result = (ProtectObjectReplica)super.clone();
        HashSet<RelicaStorageInfo> relicaStorageInfoList = new HashSet<RelicaStorageInfo>();
        for (RelicaStorageInfo relicaStorageInfo : result.getStorageInfos()) {
            RelicaStorageInfo cloneRelicaStorageInfo = (RelicaStorageInfo)relicaStorageInfo.clone();
            cloneRelicaStorageInfo.setPoReplica(result);
            relicaStorageInfoList.add(cloneRelicaStorageInfo);
        }
        result.setStorageInfos(relicaStorageInfoList);
        return result;
    }

    public JSONObject toJson() {
        JSONArray array = new JSONArray();
        for (RelicaStorageInfo storageInfo : this.storageInfos) {
            array.add((Object)storageInfo.toJson());
        }
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("pgReplica");
        ignoreSet.add("storageInfos");
        ignoreSet.add("protectObject");
        ignoreSet.add("rawPoStorageInfos");
        ignoreSet.add("poStorageInfos");
        JSONObject result = JSONObject.fromObject((Object)this, ignoreSet);
        if (!VerifyUtil.isEmpty((Object)this.protectObject)) {
            result.put((Object)"protectObject", (Object)this.protectObject.toJSONString());
        }
        result.put((Object)"storageInfos", (Object)array.toString());
        return result;
    }

    public static ProtectObjectReplica toBean(JSONObject object) {
        JSONArray storageJsonArray = JSONArray.fromObject((Object)object.get("storageInfos"));
        object.remove((Object)"storageInfos");
        JSONObject json = JSONObject.fromObject((Object)object.get("protectObject"));
        ProtectObject protectObject = ProtectObject.toProtectObject(json);
        object.remove((Object)"protectObject");
        ProtectObjectReplica poReplica = (ProtectObjectReplica)JSONObject.toBean((JSONObject)object, ProtectObjectReplica.class);
        for (int i = 0; i < storageJsonArray.size(); ++i) {
            JSONObject tempJson = JSONObject.fromObject((Object)storageJsonArray.get(i));
            RelicaStorageInfo storageInfo = RelicaStorageInfo.toBean(tempJson);
            if (null == storageInfo) continue;
            storageInfo.setPoReplica(poReplica);
            poReplica.getStorageInfos().add(storageInfo);
        }
        poReplica.setProtectObject(protectObject);
        return poReplica;
    }

    public List<ProtectObjectStorageInfo> getPoStorageInfos() {
        return ProtectObjectReplica.parsePoStorageInfo(this.poMetadata, this.id);
    }

    public List<ProtectObjectStorageInfo> getRawPoStorageInfos() {
        return ProtectObjectReplica.parsePoStorageInfo(this.rawPoMetaData, this.id);
    }

    public String getPoMetadata() {
        return this.poMetadata;
    }

    public void setPoMetadata(String poMetadata) {
        this.poMetadata = poMetadata;
        if (VerifyUtil.isEmpty((String)this.rawPoMetaData)) {
            this.rawPoMetaData = poMetadata;
        }
    }

    public String getRawPoMetaData() {
        return this.rawPoMetaData;
    }

    public void setRawPoMetaData(String rawPoMetaData) {
        this.rawPoMetaData = rawPoMetaData;
    }

    public Integer getConsistentType() {
        return this.consistentType;
    }

    public void setConsistentType(Integer consistentType) {
        this.consistentType = consistentType;
    }

    public int getDetectionStatus() {
        return this.detectionStatus;
    }

    public void setDetectionStatus(int detectionStatus) {
        this.detectionStatus = detectionStatus;
    }

    private static List<ProtectObjectStorageInfo> parsePoStorageInfo(String poMetadata, String id) {
        if (VerifyUtil.isEmpty((String)poMetadata)) {
            LOGGER.info((Object)"PoMetadata is empty, replica id:%s", new Object[]{id});
            return Collections.emptyList();
        }
        JSONObject poMetadataJson = JSONObject.fromObject((Object)poMetadata);
        JSONArray poStorageInfos = poMetadataJson.getJSONArray("poStorageInfos");
        if (VerifyUtil.isEmpty((Collection)poStorageInfos)) {
            LOGGER.info((Object)"PoStorageInfos is empty, replica id:%s", new Object[]{id});
            return Collections.emptyList();
        }
        ArrayList<ProtectObjectStorageInfo> poStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        for (int i = 0; i < poStorageInfos.size(); ++i) {
            JSONObject storageInfo = poStorageInfos.getJSONObject(i);
            ProtectObjectStorageInfo protectObjectStorageInfo = new ProtectObjectStorageInfo();
            protectObjectStorageInfo.setMountPoint(storageInfo.getString("mountPoint"));
            protectObjectStorageInfo.setLunWWN(storageInfo.getString("lunWWN"));
            protectObjectStorageInfo.setResourceProviderSN(storageInfo.getString("resourceProviderSN"));
            protectObjectStorageInfo.setResourceId(storageInfo.getString("resourceId"));
            poStorageInfoList.add(protectObjectStorageInfo);
        }
        return poStorageInfoList;
    }
}

